/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.beam.sdk.coders.BigEndianIntegerCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.OffsetBasedSource;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.testing.SourceTestUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class OffsetBasedSourceTest {
    public static void assertSplitsAre(List<? extends OffsetBasedSource<?>> splits, long[] expectedBoundaries) {
        Assert.assertEquals((long)splits.size(), (long)(expectedBoundaries.length - 1));
        int i = 0;
        for (OffsetBasedSource<?> split : splits) {
            Assert.assertEquals((long)split.getStartOffset(), (long)expectedBoundaries[i]);
            Assert.assertEquals((long)split.getEndOffset(), (long)expectedBoundaries[i + 1]);
            ++i;
        }
    }

    @Test
    public void testSplitPositionsZeroStart() throws Exception {
        long start = 0L;
        long end = 1000L;
        long minBundleSize = 50L;
        CoarseRangeSource testSource = new CoarseRangeSource(start, end, minBundleSize, 1L);
        long[] boundaries = new long[]{0L, 150L, 300L, 450L, 600L, 750L, 900L, 1000L};
        OffsetBasedSourceTest.assertSplitsAre(testSource.split(150L * testSource.getBytesPerOffset(), null), boundaries);
    }

    @Test
    public void testSplitPositionsNonZeroStart() throws Exception {
        long start = 300L;
        long end = 1000L;
        long minBundleSize = 50L;
        CoarseRangeSource testSource = new CoarseRangeSource(start, end, minBundleSize, 1L);
        long[] boundaries = new long[]{300L, 450L, 600L, 750L, 900L, 1000L};
        OffsetBasedSourceTest.assertSplitsAre(testSource.split(150L * testSource.getBytesPerOffset(), null), boundaries);
    }

    @Test
    public void testEstimatedSizeBytes() throws Exception {
        long start = 300L;
        long end = 1000L;
        long minBundleSize = 150L;
        CoarseRangeSource testSource = new CoarseRangeSource(start, end, minBundleSize, 1L);
        PipelineOptions options = PipelineOptionsFactory.create();
        Assert.assertEquals((long)((end - start) * testSource.getBytesPerOffset()), (long)testSource.getEstimatedSizeBytes(options));
    }

    @Test
    public void testMinBundleSize() throws Exception {
        long start = 300L;
        long end = 1000L;
        long minBundleSize = 150L;
        CoarseRangeSource testSource = new CoarseRangeSource(start, end, minBundleSize, 1L);
        long[] boundaries = new long[]{300L, 450L, 600L, 750L, 1000L};
        OffsetBasedSourceTest.assertSplitsAre(testSource.split(100L * testSource.getBytesPerOffset(), null), boundaries);
    }

    @Test
    public void testSplitPositionsCollapseEndBundle() throws Exception {
        long start = 0L;
        long end = 1000L;
        long minBundleSize = 50L;
        CoarseRangeSource testSource = new CoarseRangeSource(start, end, minBundleSize, 1L);
        long[] boundaries = new long[]{0L, 110L, 220L, 330L, 440L, 550L, 660L, 770L, 880L, 1000L};
        OffsetBasedSourceTest.assertSplitsAre(testSource.split(110L * testSource.getBytesPerOffset(), null), boundaries);
    }

    @Test
    public void testReadingGranularityAndFractionConsumed() throws IOException {
        PipelineOptions options = PipelineOptionsFactory.create();
        CoarseRangeSource source = new CoarseRangeSource(13L, 35L, 1L, 10L);
        try (CoarseRangeReader reader = source.createReader(options);){
            ArrayList<Integer> items = new ArrayList<Integer>();
            Assert.assertEquals((double)0.0, (double)reader.getFractionConsumed(), (double)1.0E-6);
            Assert.assertTrue((boolean)reader.start());
            items.add(reader.getCurrent());
            while (reader.advance()) {
                Double fraction = reader.getFractionConsumed();
                Assert.assertNotNull((Object)fraction);
                Assert.assertTrue((String)fraction.toString(), (fraction > 0.0 ? 1 : 0) != 0);
                Assert.assertTrue((String)fraction.toString(), (fraction <= 1.0 ? 1 : 0) != 0);
                items.add(reader.getCurrent());
            }
            Assert.assertEquals((double)1.0, (double)reader.getFractionConsumed(), (double)1.0E-6);
            Assert.assertEquals((long)20L, (long)items.size());
            Assert.assertEquals((long)20L, (long)((Integer)items.get(0)).intValue());
            Assert.assertEquals((long)39L, (long)((Integer)items.get(items.size() - 1)).intValue());
            source = new CoarseRangeSource(13L, 17L, 1L, 10L);
        }
        reader = source.createReader(options);
        var4_4 = null;
        try {
            Assert.assertFalse((boolean)reader.start());
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (reader != null) {
                OffsetBasedSourceTest.$closeResource(var4_4, (AutoCloseable)((Object)reader));
            }
        }
    }

    @Test
    public void testProgress() throws IOException {
        PipelineOptions options = PipelineOptionsFactory.create();
        CoarseRangeSource source = new CoarseRangeSource(13L, 17L, 1L, 2L);
        try (CoarseRangeReader reader = source.createReader(options);){
            Assert.assertEquals((double)0.0, (double)reader.getFractionConsumed(), (double)1.0E-6);
            Assert.assertEquals((long)0L, (long)reader.getSplitPointsConsumed());
            Assert.assertEquals((long)-1L, (long)reader.getSplitPointsRemaining());
            Assert.assertTrue((boolean)reader.start());
            Assert.assertTrue((boolean)reader.isAtSplitPoint());
            Assert.assertEquals((long)14L, (long)((Integer)reader.getCurrent()).intValue());
            Assert.assertEquals((long)0L, (long)reader.getSplitPointsConsumed());
            Assert.assertEquals((long)-1L, (long)reader.getSplitPointsRemaining());
            Assert.assertTrue((boolean)reader.advance());
            Assert.assertEquals((long)15L, (long)((Integer)reader.getCurrent()).intValue());
            Assert.assertEquals((long)0L, (long)reader.getSplitPointsConsumed());
            Assert.assertEquals((long)-1L, (long)reader.getSplitPointsRemaining());
            Assert.assertTrue((boolean)reader.advance());
            Assert.assertTrue((boolean)reader.isAtSplitPoint());
            Assert.assertEquals((long)16L, (long)((Integer)reader.getCurrent()).intValue());
            Assert.assertEquals((long)1L, (long)reader.getSplitPointsConsumed());
            Assert.assertEquals((long)1L, (long)reader.getSplitPointsRemaining());
            Assert.assertTrue((boolean)reader.advance());
            Assert.assertEquals((long)17L, (long)((Integer)reader.getCurrent()).intValue());
            Assert.assertEquals((long)1L, (long)reader.getSplitPointsConsumed());
            Assert.assertEquals((long)1L, (long)reader.getSplitPointsRemaining());
            Assert.assertFalse((boolean)reader.advance());
            Assert.assertEquals((double)1.0, (double)reader.getFractionConsumed(), (double)1.0E-6);
            Assert.assertEquals((long)2L, (long)reader.getSplitPointsConsumed());
            Assert.assertEquals((long)0L, (long)reader.getSplitPointsRemaining());
        }
    }

    @Test
    public void testProgressEmptySource() throws IOException {
        PipelineOptions options = PipelineOptionsFactory.create();
        CoarseRangeSource source = new CoarseRangeSource(13L, 17L, 1L, 100L);
        try (CoarseRangeReader reader = source.createReader(options);){
            Assert.assertEquals((double)0.0, (double)reader.getFractionConsumed(), (double)1.0E-6);
            Assert.assertEquals((long)0L, (long)reader.getSplitPointsConsumed());
            Assert.assertEquals((long)-1L, (long)reader.getSplitPointsRemaining());
            Assert.assertFalse((boolean)reader.start());
            Assert.assertEquals((double)1.0, (double)reader.getFractionConsumed(), (double)1.0E-6);
            Assert.assertEquals((long)0L, (long)reader.getSplitPointsConsumed());
            Assert.assertEquals((long)0L, (long)reader.getSplitPointsRemaining());
        }
    }

    @Test
    public void testSplitAtFraction() throws IOException {
        PipelineOptions options = PipelineOptionsFactory.create();
        CoarseRangeSource source = new CoarseRangeSource(13L, 35L, 1L, 10L);
        try (CoarseRangeReader reader = source.createReader(options);){
            ArrayList<Integer> originalItems = new ArrayList<Integer>();
            Assert.assertTrue((boolean)reader.start());
            originalItems.add(reader.getCurrent());
            Assert.assertTrue((boolean)reader.advance());
            originalItems.add(reader.getCurrent());
            Assert.assertTrue((boolean)reader.advance());
            originalItems.add(reader.getCurrent());
            Assert.assertTrue((boolean)reader.advance());
            originalItems.add(reader.getCurrent());
            Assert.assertNull((Object)reader.splitAtFraction(0.0));
            Assert.assertNull((Object)reader.splitAtFraction(reader.getFractionConsumed() - 0.1));
            OffsetBasedSource residual = reader.splitAtFraction(reader.getFractionConsumed() + 0.1);
            OffsetBasedSource primary = reader.getCurrentSource();
            List primaryItems = SourceTestUtils.readFromSource((BoundedSource)primary, (PipelineOptions)options);
            List residualItems = SourceTestUtils.readFromSource((BoundedSource)residual, (PipelineOptions)options);
            for (Integer item : residualItems) {
                Assert.assertTrue(((long)item.intValue() > reader.getCurrentOffset() ? 1 : 0) != 0);
            }
            Assert.assertFalse((boolean)primaryItems.isEmpty());
            Assert.assertFalse((boolean)residualItems.isEmpty());
            Assert.assertTrue(((Integer)primaryItems.get(primaryItems.size() - 1) <= (Integer)residualItems.get(0) ? 1 : 0) != 0);
            while (reader.advance()) {
                originalItems.add(reader.getCurrent());
            }
            Assert.assertEquals(originalItems, (Object)primaryItems);
        }
    }

    @Test
    public void testSplitAtFractionExhaustive() throws Exception {
        PipelineOptions options = PipelineOptionsFactory.create();
        CoarseRangeSource original = new CoarseRangeSource(13L, 35L, 1L, 10L);
        SourceTestUtils.assertSplitAtFractionExhaustive((BoundedSource)original, (PipelineOptions)options);
    }

    @Test
    public void testEmptyOffsetRange() throws Exception {
        CoarseRangeSource empty = new CoarseRangeSource(0L, 0L, 1L, 1L);
        try (CoarseRangeReader reader = empty.createReader(PipelineOptionsFactory.create());){
            Assert.assertEquals((long)0L, (long)reader.getSplitPointsConsumed());
            Assert.assertEquals((long)-1L, (long)reader.getSplitPointsRemaining());
            Assert.assertEquals((double)0.0, (double)reader.getFractionConsumed(), (double)1.0E-4);
            Assert.assertFalse((boolean)reader.start());
            Assert.assertEquals((long)0L, (long)reader.getSplitPointsConsumed());
            Assert.assertEquals((long)0L, (long)reader.getSplitPointsRemaining());
            Assert.assertEquals((double)1.0, (double)reader.getFractionConsumed(), (double)1.0E-4);
        }
    }

    private static class CoarseRangeReader
    extends OffsetBasedSource.OffsetBasedReader<Integer> {
        private long current = -1L;
        private long granularity;

        public CoarseRangeReader(CoarseRangeSource source) {
            super((OffsetBasedSource)source);
            this.granularity = source.granularity;
        }

        protected long getCurrentOffset() {
            return this.current;
        }

        public boolean startImpl() {
            this.current = this.getCurrentSource().getStartOffset();
            while (this.current % this.granularity != 0L) {
                ++this.current;
            }
            return true;
        }

        public boolean advanceImpl() {
            ++this.current;
            return true;
        }

        public Integer getCurrent() throws NoSuchElementException {
            return (int)this.current;
        }

        public boolean isAtSplitPoint() {
            return this.current % this.granularity == 0L;
        }

        public void close() {
        }
    }

    private static class CoarseRangeSource
    extends OffsetBasedSource<Integer> {
        private long granularity;

        public CoarseRangeSource(long startOffset, long endOffset, long minBundleSize, long granularity) {
            super(startOffset, endOffset, minBundleSize);
            this.granularity = granularity;
        }

        public OffsetBasedSource<Integer> createSourceForSubrange(long start, long end) {
            return new CoarseRangeSource(start, end, this.getMinBundleSize(), this.granularity);
        }

        public Coder<Integer> getOutputCoder() {
            return BigEndianIntegerCoder.of();
        }

        public long getBytesPerOffset() {
            return 4L;
        }

        public long getMaxEndOffset(PipelineOptions options) {
            return this.getEndOffset();
        }

        public CoarseRangeReader createReader(PipelineOptions options) {
            return new CoarseRangeReader(this);
        }
    }
}

