/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.beam.repackaged.beam_sdks_java_core.org.apache.commons.lang3.SystemUtils;
import org.apache.beam.sdk.io.LocalResourceId;
import org.apache.beam.sdk.io.fs.ResolveOptions;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.io.fs.ResourceIdTester;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class LocalResourceIdTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    @Rule
    public TemporaryFolder tmpFolder = new TemporaryFolder();

    @Test
    public void testResolveInUnix() throws Exception {
        if (SystemUtils.IS_OS_WINDOWS) {
            return;
        }
        Assert.assertEquals((Object)this.toResourceIdentifier("/root/tmp/aa"), (Object)this.toResourceIdentifier("/root/tmp/").resolve("aa", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE));
        Assert.assertEquals((Object)this.toResourceIdentifier("/root/tmp/aa/bb/cc/"), (Object)this.toResourceIdentifier("/root/tmp/").resolve("aa", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY).resolve("bb", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY).resolve("cc", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY));
        Assert.assertEquals((Object)this.toResourceIdentifier("/root/tmp/aa"), (Object)this.toResourceIdentifier("/root/tmp/bb/").resolve("/root/tmp/aa", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE));
        Assert.assertEquals((Object)this.toResourceIdentifier("file:/aa"), (Object)this.toResourceIdentifier("file:///").resolve("aa", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE));
    }

    @Test
    public void testResolveNormalizationInUnix() throws Exception {
        if (SystemUtils.IS_OS_WINDOWS) {
            return;
        }
        Assert.assertEquals((Object)this.toResourceIdentifier("file://home/bb"), (Object)this.toResourceIdentifier("file://root/../home/output/../").resolve("aa", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY).resolve("..", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY).resolve("bb", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE));
        Assert.assertEquals((Object)this.toResourceIdentifier("file://root/aa/bb"), (Object)this.toResourceIdentifier("file://root/./").resolve("aa", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY).resolve(".", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY).resolve("bb", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE));
        Assert.assertEquals((Object)this.toResourceIdentifier("aa/bb"), (Object)this.toResourceIdentifier("a/../").resolve("aa", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY).resolve(".", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY).resolve("bb", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE));
        Assert.assertEquals((Object)this.toResourceIdentifier("/aa/bb"), (Object)this.toResourceIdentifier("/a/../").resolve("aa", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY).resolve(".", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY).resolve("bb", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE));
        Assert.assertEquals((Object)this.toResourceIdentifier("aa/bb"), (Object)this.toResourceIdentifier("./").resolve("aa", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY).resolve(".", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY).resolve("bb", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE));
        Assert.assertEquals((Object)this.toResourceIdentifier("../aa/bb"), (Object)this.toResourceIdentifier("../").resolve("aa", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY).resolve(".", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY).resolve("bb", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE));
        Assert.assertEquals((Object)this.toResourceIdentifier("~/aa/bb/"), (Object)this.toResourceIdentifier("~/").resolve("aa", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY).resolve(".", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY).resolve("bb", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY));
    }

    @Test
    public void testResolveHandleBadInputsInUnix() throws Exception {
        if (SystemUtils.IS_OS_WINDOWS) {
            return;
        }
        Assert.assertEquals((Object)this.toResourceIdentifier("/root/tmp/"), (Object)this.toResourceIdentifier("/root/").resolve("tmp/", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY));
    }

    @Test
    public void testResolveInvalidInputs() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("The resolved file: [tmp/] should not end with '/'.");
        this.toResourceIdentifier("/root/").resolve("tmp/", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE);
    }

    @Test
    public void testResolveInvalidNotDirectory() throws Exception {
        LocalResourceId tmp = this.toResourceIdentifier("/root/").resolve("tmp", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE);
        this.thrown.expect(IllegalStateException.class);
        this.thrown.expectMessage("Expected the path is a directory, but had [/root/tmp].");
        tmp.resolve("aa", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE);
    }

    @Test
    public void testResolveInWindowsOS() throws Exception {
        if (!SystemUtils.IS_OS_WINDOWS) {
            return;
        }
        Assert.assertEquals((Object)this.toResourceIdentifier("C:\\my home\\out put"), (Object)this.toResourceIdentifier("C:\\my home\\").resolve("out put", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE));
        Assert.assertEquals((Object)this.toResourceIdentifier("C:\\out put"), (Object)this.toResourceIdentifier("C:\\my home\\").resolve("..", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY).resolve(".", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY).resolve("out put", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE));
        Assert.assertEquals((Object)this.toResourceIdentifier("C:\\my home\\**\\*"), (Object)this.toResourceIdentifier("C:\\my home\\").resolve("**", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY).resolve("*", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE));
    }

    @Test
    public void testGetCurrentDirectoryInUnix() throws Exception {
        Assert.assertEquals((Object)this.toResourceIdentifier("/root/tmp/"), (Object)this.toResourceIdentifier("/root/tmp/").getCurrentDirectory());
        Assert.assertEquals((Object)this.toResourceIdentifier("/"), (Object)this.toResourceIdentifier("/").getCurrentDirectory());
        Assert.assertEquals((Object)this.toResourceIdentifier("./"), (Object)this.toResourceIdentifier("output").getCurrentDirectory());
    }

    @Test
    public void testGetScheme() throws Exception {
        Assert.assertEquals((Object)"file", (Object)this.toResourceIdentifier("/root/tmp/").getScheme());
    }

    @Test
    public void testEquals() throws Exception {
        Assert.assertEquals((Object)this.toResourceIdentifier("/root/tmp/"), (Object)this.toResourceIdentifier("/root/tmp/"));
        Assert.assertNotEquals((Object)this.toResourceIdentifier("/root/tmp"), (Object)this.toResourceIdentifier("/root/tmp/"));
    }

    @Test
    public void testIsDirectory() throws Exception {
        Assert.assertTrue((boolean)this.toResourceIdentifier("/").isDirectory());
        Assert.assertTrue((boolean)this.toResourceIdentifier("/root/tmp/").isDirectory());
        Assert.assertFalse((boolean)this.toResourceIdentifier("/root").isDirectory());
    }

    @Test
    public void testToString() throws Exception {
        File someFile = this.tmpFolder.newFile("somefile");
        LocalResourceId fileResource = LocalResourceId.fromPath((Path)someFile.toPath(), (boolean)false);
        Assert.assertThat((Object)fileResource.toString(), (Matcher)Matchers.not((Matcher)Matchers.endsWith((String)File.separator)));
        Assert.assertThat((Object)fileResource.toString(), (Matcher)Matchers.containsString((String)"somefile"));
        Assert.assertThat((Object)fileResource.toString(), (Matcher)Matchers.startsWith((String)this.tmpFolder.getRoot().getAbsolutePath()));
        LocalResourceId dirResource = LocalResourceId.fromPath((Path)someFile.toPath(), (boolean)true);
        Assert.assertThat((Object)dirResource.toString(), (Matcher)Matchers.endsWith((String)File.separator));
        Assert.assertThat((Object)dirResource.toString(), (Matcher)Matchers.containsString((String)"somefile"));
        Assert.assertThat((Object)dirResource.toString(), (Matcher)Matchers.startsWith((String)this.tmpFolder.getRoot().getAbsolutePath()));
    }

    @Test
    public void testGetFilename() throws Exception {
        Assert.assertEquals(null, (Object)this.toResourceIdentifier("/").getFilename());
        Assert.assertEquals((Object)"tmp", (Object)this.toResourceIdentifier("/root/tmp").getFilename());
        Assert.assertEquals((Object)"tmp", (Object)this.toResourceIdentifier("/root/tmp/").getFilename());
        Assert.assertEquals((Object)"xyz.txt", (Object)this.toResourceIdentifier("/root/tmp/xyz.txt").getFilename());
    }

    @Test
    @Ignore(value="https://issues.apache.org/jira/browse/BEAM-4110")
    public void testResourceIdTester() throws Exception {
        ResourceIdTester.runResourceIdBattery((ResourceId)this.toResourceIdentifier("/tmp/foo/"));
    }

    private LocalResourceId toResourceIdentifier(String str) throws Exception {
        boolean isDirectory = SystemUtils.IS_OS_WINDOWS ? str.endsWith("\\") : str.endsWith("/");
        return LocalResourceId.fromPath((Path)Paths.get(str, new String[0]), (boolean)isDirectory);
    }
}

