/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import java.io.Serializable;
import org.apache.beam.sdk.io.GenerateSequence;
import org.apache.beam.sdk.testing.NeedsRunner;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Count;
import org.apache.beam.sdk.transforms.Distinct;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.Max;
import org.apache.beam.sdk.transforms.Min;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.DisplayDataMatchers;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.values.PCollection;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class GenerateSequenceTest {
    @Rule
    public TestPipeline p = TestPipeline.create();

    public static void addCountingAsserts(PCollection<Long> input, long start, long end) {
        PAssert.thatSingleton((PCollection)((PCollection)input.apply("Count", Count.globally()))).isEqualTo((Object)(end - start));
        PAssert.thatSingleton((PCollection)((PCollection)((PCollection)input.apply((PTransform)Distinct.create())).apply("UniqueCount", Count.globally()))).isEqualTo((Object)(end - start));
        PAssert.thatSingleton((PCollection)((PCollection)input.apply("Min", (PTransform)Min.globally()))).isEqualTo((Object)start);
        PAssert.thatSingleton((PCollection)((PCollection)input.apply("Max", (PTransform)Max.globally()))).isEqualTo((Object)(end - 1L));
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testBoundedInput() {
        long numElements = 1000L;
        PCollection input = (PCollection)this.p.apply((PTransform)GenerateSequence.from((long)0L).to(numElements));
        GenerateSequenceTest.addCountingAsserts((PCollection<Long>)input, 0L, numElements);
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testEmptyBoundedInput() {
        PCollection input = (PCollection)this.p.apply((PTransform)GenerateSequence.from((long)0L).to(0L));
        PAssert.that((PCollection)input).empty();
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testEmptyBoundedInputSubrange() {
        PCollection input = (PCollection)this.p.apply((PTransform)GenerateSequence.from((long)42L).to(42L));
        PAssert.that((PCollection)input).empty();
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testBoundedInputSubrange() {
        long start = 10L;
        long end = 1000L;
        PCollection input = (PCollection)this.p.apply((PTransform)GenerateSequence.from((long)start).to(end));
        GenerateSequenceTest.addCountingAsserts((PCollection<Long>)input, start, end);
        this.p.run();
    }

    @Test
    public void testBoundedDisplayData() {
        GenerateSequence input = GenerateSequence.from((long)0L).to(1234L);
        DisplayData displayData = DisplayData.from((HasDisplayData)input);
        Assert.assertThat((Object)displayData, DisplayDataMatchers.hasDisplayItem("from", 0L));
        Assert.assertThat((Object)displayData, DisplayDataMatchers.hasDisplayItem("to", 1234L));
    }

    @Test
    public void testBoundedDisplayDataSubrange() {
        GenerateSequence input = GenerateSequence.from((long)12L).to(1234L);
        DisplayData displayData = DisplayData.from((HasDisplayData)input);
        Assert.assertThat((Object)displayData, DisplayDataMatchers.hasDisplayItem("from", 12L));
        Assert.assertThat((Object)displayData, DisplayDataMatchers.hasDisplayItem("to", 1234L));
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testUnboundedInputRate() {
        long numElements = 5000L;
        long elemsPerPeriod = 10L;
        Duration periodLength = Duration.millis((long)8L);
        PCollection input = (PCollection)this.p.apply((PTransform)GenerateSequence.from((long)0L).to(numElements).withRate(elemsPerPeriod, periodLength));
        GenerateSequenceTest.addCountingAsserts((PCollection<Long>)input, 0L, numElements);
        long expectedRuntimeMillis = periodLength.getMillis() * numElements / elemsPerPeriod;
        Instant startTime = Instant.now();
        this.p.run();
        Instant endTime = Instant.now();
        Assert.assertThat((Object)endTime.isAfter((ReadableInstant)startTime.plus(expectedRuntimeMillis)), (Matcher)Matchers.is((Object)true));
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testUnboundedInputTimestamps() {
        long numElements = 1000L;
        PCollection input = (PCollection)this.p.apply((PTransform)GenerateSequence.from((long)0L).to(numElements).withTimestampFn((SerializableFunction)new ValueAsTimestampFn()));
        GenerateSequenceTest.addCountingAsserts((PCollection<Long>)input, 0L, numElements);
        PCollection diffs = (PCollection)((PCollection)input.apply("TimestampDiff", (PTransform)ParDo.of((DoFn)new ElementValueDiff()))).apply("DistinctTimestamps", (PTransform)Distinct.create());
        PAssert.thatSingleton((PCollection)diffs).isEqualTo((Object)0L);
        this.p.run();
    }

    @Test
    public void testUnboundedDisplayData() {
        Duration maxReadTime = Duration.standardHours((long)5L);
        SerializableFunction & Serializable timestampFn = (SerializableFunction & Serializable)input -> Instant.now();
        GenerateSequence input2 = GenerateSequence.from((long)0L).to(1234L).withMaxReadTime(maxReadTime).withTimestampFn((SerializableFunction)timestampFn);
        DisplayData displayData = DisplayData.from((HasDisplayData)input2);
        Assert.assertThat((Object)displayData, DisplayDataMatchers.hasDisplayItem("maxReadTime", maxReadTime));
        Assert.assertThat((Object)displayData, DisplayDataMatchers.hasDisplayItem("timestampFn", timestampFn.getClass()));
    }

    private static class ValueAsTimestampFn
    implements SerializableFunction<Long, Instant> {
        private ValueAsTimestampFn() {
        }

        public Instant apply(Long input) {
            return new Instant((Object)input);
        }
    }

    private static class ElementValueDiff
    extends DoFn<Long, Long> {
        private ElementValueDiff() {
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) throws Exception {
            c.output((Object)((Long)c.element() - c.timestamp().getMillis()));
        }
    }
}

