/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import java.io.Writer;
import java.nio.channels.Channels;
import java.nio.charset.StandardCharsets;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.FluentIterable;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.ImmutableList;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.Sets;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.io.Files;
import org.apache.beam.repackaged.beam_sdks_java_core.org.apache.commons.lang3.SystemUtils;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.LocalFileSystem;
import org.apache.beam.sdk.io.LocalFileSystemRegistrar;
import org.apache.beam.sdk.io.LocalResourceId;
import org.apache.beam.sdk.io.fs.CreateOptions;
import org.apache.beam.sdk.io.fs.MoveOptions;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class FileSystemsTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private LocalFileSystem localFileSystem = new LocalFileSystem();

    @Test
    public void testGetLocalFileSystem() throws Exception {
        Assert.assertTrue((boolean)(FileSystems.getFileSystemInternal((String)this.toLocalResourceId("~/home/").getScheme()) instanceof LocalFileSystem));
        Assert.assertTrue((boolean)(FileSystems.getFileSystemInternal((String)this.toLocalResourceId("file://home").getScheme()) instanceof LocalFileSystem));
        Assert.assertTrue((boolean)(FileSystems.getFileSystemInternal((String)this.toLocalResourceId("FILE://home").getScheme()) instanceof LocalFileSystem));
        Assert.assertTrue((boolean)(FileSystems.getFileSystemInternal((String)this.toLocalResourceId("File://home").getScheme()) instanceof LocalFileSystem));
        if (SystemUtils.IS_OS_WINDOWS) {
            Assert.assertTrue((boolean)(FileSystems.getFileSystemInternal((String)this.toLocalResourceId("c:\\home\\").getScheme()) instanceof LocalFileSystem));
        }
    }

    @Test
    public void testVerifySchemesAreUnique() throws Exception {
        this.thrown.expect(RuntimeException.class);
        this.thrown.expectMessage("Scheme: [file] has conflicting filesystems");
        FileSystems.verifySchemesAreUnique((PipelineOptions)PipelineOptionsFactory.create(), Sets.newHashSet(new LocalFileSystemRegistrar(), new LocalFileSystemRegistrar()));
    }

    @Test
    public void testDeleteIgnoreMissingFiles() throws Exception {
        Path existingPath = this.temporaryFolder.newFile().toPath();
        Path nonExistentPath = existingPath.resolveSibling("non-existent");
        this.createFileWithContent(existingPath, "content1");
        FileSystems.delete(this.toResourceIds(ImmutableList.of(existingPath, nonExistentPath), false), (MoveOptions[])new MoveOptions[0]);
    }

    @Test
    public void testCopyThrowsNoSuchFileException() throws Exception {
        Path existingPath = this.temporaryFolder.newFile().toPath();
        Path nonExistentPath = existingPath.resolveSibling("non-existent");
        Path destPath1 = existingPath.resolveSibling("dest1");
        Path destPath2 = nonExistentPath.resolveSibling("dest2");
        this.createFileWithContent(existingPath, "content1");
        this.thrown.expect(NoSuchFileException.class);
        FileSystems.copy(this.toResourceIds(ImmutableList.of(existingPath, nonExistentPath), false), this.toResourceIds(ImmutableList.of(destPath1, destPath2), false), (MoveOptions[])new MoveOptions[0]);
    }

    @Test
    public void testCopyIgnoreMissingFiles() throws Exception {
        Path srcPath1 = this.temporaryFolder.newFile().toPath();
        Path nonExistentPath = srcPath1.resolveSibling("non-existent");
        Path srcPath3 = this.temporaryFolder.newFile().toPath();
        Path destPath1 = srcPath1.resolveSibling("dest1");
        Path destPath2 = nonExistentPath.resolveSibling("dest2");
        Path destPath3 = srcPath1.resolveSibling("dest3");
        this.createFileWithContent(srcPath1, "content1");
        this.createFileWithContent(srcPath3, "content3");
        FileSystems.copy(this.toResourceIds(ImmutableList.of(srcPath1, nonExistentPath, srcPath3), false), this.toResourceIds(ImmutableList.of(destPath1, destPath2, destPath3), false), (MoveOptions[])new MoveOptions[]{MoveOptions.StandardMoveOptions.IGNORE_MISSING_FILES});
        Assert.assertTrue((boolean)srcPath1.toFile().exists());
        Assert.assertTrue((boolean)srcPath3.toFile().exists());
        Assert.assertThat(Files.readLines(srcPath1.toFile(), StandardCharsets.UTF_8), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"content1"}));
        Assert.assertFalse((boolean)destPath2.toFile().exists());
        Assert.assertThat(Files.readLines(srcPath3.toFile(), StandardCharsets.UTF_8), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"content3"}));
    }

    @Test
    public void testRenameThrowsNoSuchFileException() throws Exception {
        Path existingPath = this.temporaryFolder.newFile().toPath();
        Path nonExistentPath = existingPath.resolveSibling("non-existent");
        Path destPath1 = existingPath.resolveSibling("dest1");
        Path destPath2 = nonExistentPath.resolveSibling("dest2");
        this.createFileWithContent(existingPath, "content1");
        this.thrown.expect(NoSuchFileException.class);
        FileSystems.rename(this.toResourceIds(ImmutableList.of(existingPath, nonExistentPath), false), this.toResourceIds(ImmutableList.of(destPath1, destPath2), false), (MoveOptions[])new MoveOptions[0]);
    }

    @Test
    public void testRenameIgnoreMissingFiles() throws Exception {
        Path srcPath1 = this.temporaryFolder.newFile().toPath();
        Path nonExistentPath = srcPath1.resolveSibling("non-existent");
        Path srcPath3 = this.temporaryFolder.newFile().toPath();
        Path destPath1 = srcPath1.resolveSibling("dest1");
        Path destPath2 = nonExistentPath.resolveSibling("dest2");
        Path destPath3 = srcPath1.resolveSibling("dest3");
        this.createFileWithContent(srcPath1, "content1");
        this.createFileWithContent(srcPath3, "content3");
        FileSystems.rename(this.toResourceIds(ImmutableList.of(srcPath1, nonExistentPath, srcPath3), false), this.toResourceIds(ImmutableList.of(destPath1, destPath2, destPath3), false), (MoveOptions[])new MoveOptions[]{MoveOptions.StandardMoveOptions.IGNORE_MISSING_FILES});
        Assert.assertFalse((boolean)srcPath1.toFile().exists());
        Assert.assertFalse((boolean)srcPath3.toFile().exists());
        Assert.assertThat(Files.readLines(destPath1.toFile(), StandardCharsets.UTF_8), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"content1"}));
        Assert.assertFalse((boolean)destPath2.toFile().exists());
        Assert.assertThat(Files.readLines(destPath3.toFile(), StandardCharsets.UTF_8), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"content3"}));
    }

    @Test
    public void testValidMatchNewResourceForLocalFileSystem() {
        Assert.assertEquals((Object)"file", (Object)FileSystems.matchNewResource((String)"/tmp/f1", (boolean)false).getScheme());
        Assert.assertEquals((Object)"file", (Object)FileSystems.matchNewResource((String)"tmp/f1", (boolean)false).getScheme());
        Assert.assertEquals((Object)"file", (Object)FileSystems.matchNewResource((String)"c:\\tmp\\f1", (boolean)false).getScheme());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidSchemaMatchNewResource() {
        Assert.assertEquals((Object)"file", (Object)FileSystems.matchNewResource((String)"invalidschema://tmp/f1", (boolean)false));
    }

    private List<ResourceId> toResourceIds(List<Path> paths, boolean isDirectory) {
        return FluentIterable.from(paths).transform(path -> LocalResourceId.fromPath((Path)path, (boolean)isDirectory)).toList();
    }

    private void createFileWithContent(Path path, String content) throws Exception {
        try (Writer writer = Channels.newWriter(this.localFileSystem.create(LocalResourceId.fromPath((Path)path, (boolean)false), (CreateOptions)((CreateOptions.StandardCreateOptions.Builder)CreateOptions.StandardCreateOptions.builder().setMimeType("text/plain")).build()), StandardCharsets.UTF_8.name());){
            writer.write(content);
        }
    }

    private LocalResourceId toLocalResourceId(String str) throws Exception {
        boolean isDirectory = SystemUtils.IS_OS_WINDOWS ? str.endsWith("\\") : str.endsWith("/");
        return LocalResourceId.fromPath((Path)Paths.get(str, new String[0]), (boolean)isDirectory);
    }
}

