/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.base.Charsets;
import org.apache.beam.sdk.io.Compression;
import org.apache.beam.sdk.io.FileIO;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.fs.EmptyMatchTreatment;
import org.apache.beam.sdk.io.fs.MatchResult;
import org.apache.beam.sdk.io.fs.ResolveOptions;
import org.apache.beam.sdk.testing.NeedsRunner;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Contextful;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.Watch;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.values.PCollection;
import org.hamcrest.Matchers;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class FileIOTest
implements Serializable {
    @Rule
    public transient TestPipeline p = TestPipeline.create();
    @Rule
    public transient TemporaryFolder tmpFolder = new TemporaryFolder();
    @Rule
    public transient ExpectedException thrown = ExpectedException.none();

    @Test
    @Category(value={NeedsRunner.class})
    public void testMatchAndMatchAll() throws IOException {
        Path firstPath = this.tmpFolder.newFile("first").toPath();
        Path secondPath = this.tmpFolder.newFile("second").toPath();
        int firstSize = 37;
        int secondSize = 42;
        Files.write(firstPath, new byte[firstSize], new OpenOption[0]);
        Files.write(secondPath, new byte[secondSize], new OpenOption[0]);
        PAssert.that((PCollection)((PCollection)this.p.apply("Match existing", (PTransform)FileIO.match().filepattern(this.tmpFolder.getRoot().getAbsolutePath() + "/*")))).containsInAnyOrder((Object[])new MatchResult.Metadata[]{FileIOTest.metadata(firstPath, firstSize), FileIOTest.metadata(secondPath, secondSize)});
        PAssert.that((PCollection)((PCollection)this.p.apply("Match existing with provider", (PTransform)FileIO.match().filepattern(this.p.newProvider((Object)(this.tmpFolder.getRoot().getAbsolutePath() + "/*")))))).containsInAnyOrder((Object[])new MatchResult.Metadata[]{FileIOTest.metadata(firstPath, firstSize), FileIOTest.metadata(secondPath, secondSize)});
        PAssert.that((PCollection)((PCollection)((PCollection)this.p.apply("Create existing", (PTransform)Create.of((Object)(this.tmpFolder.getRoot().getAbsolutePath() + "/*"), (Object[])new String[0]))).apply("MatchAll existing", (PTransform)FileIO.matchAll()))).containsInAnyOrder((Object[])new MatchResult.Metadata[]{FileIOTest.metadata(firstPath, firstSize), FileIOTest.metadata(secondPath, secondSize)});
        PAssert.that((PCollection)((PCollection)this.p.apply("Match non-existing ALLOW", (PTransform)FileIO.match().filepattern(this.tmpFolder.getRoot().getAbsolutePath() + "/blah").withEmptyMatchTreatment(EmptyMatchTreatment.ALLOW)))).containsInAnyOrder((Object[])new MatchResult.Metadata[0]);
        PAssert.that((PCollection)((PCollection)((PCollection)this.p.apply("Create non-existing", (PTransform)Create.of((Object)(this.tmpFolder.getRoot().getAbsolutePath() + "/blah"), (Object[])new String[0]))).apply("MatchAll non-existing ALLOW", (PTransform)FileIO.matchAll().withEmptyMatchTreatment(EmptyMatchTreatment.ALLOW)))).containsInAnyOrder((Object[])new MatchResult.Metadata[0]);
        PAssert.that((PCollection)((PCollection)this.p.apply("Match non-existing ALLOW_IF_WILDCARD", (PTransform)FileIO.match().filepattern(this.tmpFolder.getRoot().getAbsolutePath() + "/blah*").withEmptyMatchTreatment(EmptyMatchTreatment.ALLOW_IF_WILDCARD)))).containsInAnyOrder((Object[])new MatchResult.Metadata[0]);
        PAssert.that((PCollection)((PCollection)((PCollection)this.p.apply("Create non-existing wildcard + explicit", (PTransform)Create.of((Object)(this.tmpFolder.getRoot().getAbsolutePath() + "/blah*"), (Object[])new String[0]))).apply("MatchAll non-existing ALLOW_IF_WILDCARD", (PTransform)FileIO.matchAll().withEmptyMatchTreatment(EmptyMatchTreatment.ALLOW_IF_WILDCARD)))).containsInAnyOrder((Object[])new MatchResult.Metadata[0]);
        PAssert.that((PCollection)((PCollection)((PCollection)this.p.apply("Create non-existing wildcard + default", (PTransform)Create.of((Object)(this.tmpFolder.getRoot().getAbsolutePath() + "/blah*"), (Object[])new String[0]))).apply("MatchAll non-existing default", (PTransform)FileIO.matchAll()))).containsInAnyOrder((Object[])new MatchResult.Metadata[0]);
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testMatchDisallowEmptyDefault() throws IOException {
        this.p.apply("Match", (PTransform)FileIO.match().filepattern(this.tmpFolder.getRoot().getAbsolutePath() + "/*"));
        this.thrown.expectCause(Matchers.isA(FileNotFoundException.class));
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testMatchDisallowEmptyExplicit() throws IOException {
        this.p.apply((PTransform)FileIO.match().filepattern(this.tmpFolder.getRoot().getAbsolutePath() + "/*").withEmptyMatchTreatment(EmptyMatchTreatment.DISALLOW));
        this.thrown.expectCause(Matchers.isA(FileNotFoundException.class));
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testMatchDisallowEmptyNonWildcard() throws IOException {
        this.p.apply((PTransform)FileIO.match().filepattern(this.tmpFolder.getRoot().getAbsolutePath() + "/blah").withEmptyMatchTreatment(EmptyMatchTreatment.ALLOW_IF_WILDCARD));
        this.thrown.expectCause(Matchers.isA(FileNotFoundException.class));
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testMatchAllDisallowEmptyExplicit() throws IOException {
        ((PCollection)this.p.apply((PTransform)Create.of((Object)(this.tmpFolder.getRoot().getAbsolutePath() + "/*"), (Object[])new String[0]))).apply((PTransform)FileIO.matchAll().withEmptyMatchTreatment(EmptyMatchTreatment.DISALLOW));
        this.thrown.expectCause(Matchers.isA(FileNotFoundException.class));
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testMatchAllDisallowEmptyNonWildcard() throws IOException {
        ((PCollection)this.p.apply((PTransform)Create.of((Object)(this.tmpFolder.getRoot().getAbsolutePath() + "/blah"), (Object[])new String[0]))).apply((PTransform)FileIO.matchAll().withEmptyMatchTreatment(EmptyMatchTreatment.ALLOW_IF_WILDCARD));
        this.thrown.expectCause(Matchers.isA(FileNotFoundException.class));
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testMatchWatchForNewFiles() throws IOException, InterruptedException {
        Path basePath = this.tmpFolder.getRoot().toPath().resolve("watch");
        basePath.toFile().mkdir();
        PCollection matchMetadata = (PCollection)this.p.apply((PTransform)FileIO.match().filepattern(basePath.resolve("*").toString()).continuously(Duration.millis((long)100L), (Watch.Growth.TerminationCondition)Watch.Growth.afterTimeSinceNewOutput((ReadableDuration)Duration.standardSeconds((long)3L))));
        PCollection matchAllMetadata = (PCollection)((PCollection)this.p.apply((PTransform)Create.of((Object)basePath.resolve("*").toString(), (Object[])new String[0]))).apply((PTransform)FileIO.matchAll().continuously(Duration.millis((long)100L), (Watch.Growth.TerminationCondition)Watch.Growth.afterTimeSinceNewOutput((ReadableDuration)Duration.standardSeconds((long)3L))));
        Assert.assertEquals((Object)PCollection.IsBounded.UNBOUNDED, (Object)matchMetadata.isBounded());
        Assert.assertEquals((Object)PCollection.IsBounded.UNBOUNDED, (Object)matchAllMetadata.isBounded());
        Thread writer = new Thread(() -> {
            try {
                Thread.sleep(1000L);
                Files.write(basePath.resolve("first"), new byte[42], new OpenOption[0]);
                Thread.sleep(300L);
                Files.write(basePath.resolve("second"), new byte[37], new OpenOption[0]);
                Thread.sleep(300L);
                Files.write(basePath.resolve("third"), new byte[99], new OpenOption[0]);
            }
            catch (IOException | InterruptedException e) {
                throw new RuntimeException(e);
            }
        });
        writer.start();
        List<MatchResult.Metadata> expected = Arrays.asList(FileIOTest.metadata(basePath.resolve("first"), 42), FileIOTest.metadata(basePath.resolve("second"), 37), FileIOTest.metadata(basePath.resolve("third"), 99));
        PAssert.that((PCollection)matchMetadata).containsInAnyOrder(expected);
        PAssert.that((PCollection)matchAllMetadata).containsInAnyOrder(expected);
        this.p.run();
        writer.join();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testRead() throws IOException {
        String path = this.tmpFolder.newFile("file").getAbsolutePath();
        String pathGZ = this.tmpFolder.newFile("file.gz").getAbsolutePath();
        Files.write(new File(path).toPath(), "Hello world".getBytes(Charsets.UTF_8), new OpenOption[0]);
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new GZIPOutputStream(new FileOutputStream(pathGZ)), Charsets.UTF_8);){
            writer.write("Hello world");
        }
        PCollection matches = (PCollection)this.p.apply("Match", (PTransform)FileIO.match().filepattern(path));
        PCollection decompressedAuto = (PCollection)matches.apply("Read AUTO", (PTransform)FileIO.readMatches().withCompression(Compression.AUTO));
        PCollection decompressedDefault = (PCollection)matches.apply("Read default", (PTransform)FileIO.readMatches());
        PCollection decompressedUncompressed = (PCollection)matches.apply("Read UNCOMPRESSED", (PTransform)FileIO.readMatches().withCompression(Compression.UNCOMPRESSED));
        for (PCollection c : Arrays.asList(decompressedAuto, decompressedDefault, decompressedUncompressed)) {
            PAssert.thatSingleton((PCollection)c).satisfies((SerializableFunction & Serializable)input -> {
                Assert.assertEquals((Object)path, (Object)input.getMetadata().resourceId().toString());
                Assert.assertEquals((long)"Hello world".length(), (long)input.getMetadata().sizeBytes());
                Assert.assertEquals((Object)Compression.UNCOMPRESSED, (Object)input.getCompression());
                Assert.assertTrue((boolean)input.getMetadata().isReadSeekEfficient());
                try {
                    Assert.assertEquals((Object)"Hello world", (Object)input.readFullyAsUTF8String());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return null;
            });
        }
        PCollection matchesGZ = (PCollection)this.p.apply("Match GZ", (PTransform)FileIO.match().filepattern(pathGZ));
        PCollection compressionAuto = (PCollection)matchesGZ.apply("Read GZ AUTO", (PTransform)FileIO.readMatches().withCompression(Compression.AUTO));
        PCollection compressionDefault = (PCollection)matchesGZ.apply("Read GZ default", (PTransform)FileIO.readMatches());
        PCollection compressionGzip = (PCollection)matchesGZ.apply("Read GZ GZIP", (PTransform)FileIO.readMatches().withCompression(Compression.GZIP));
        for (PCollection c : Arrays.asList(compressionAuto, compressionDefault, compressionGzip)) {
            PAssert.thatSingleton((PCollection)c).satisfies((SerializableFunction & Serializable)input -> {
                Assert.assertEquals((Object)pathGZ, (Object)input.getMetadata().resourceId().toString());
                Assert.assertFalse((input.getMetadata().sizeBytes() == (long)"Hello world".length() ? 1 : 0) != 0);
                Assert.assertEquals((Object)Compression.GZIP, (Object)input.getCompression());
                Assert.assertFalse((boolean)input.getMetadata().isReadSeekEfficient());
                try {
                    Assert.assertEquals((Object)"Hello world", (Object)input.readFullyAsUTF8String());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return null;
            });
        }
        this.p.run();
    }

    private static MatchResult.Metadata metadata(Path path, int size) {
        return MatchResult.Metadata.builder().setResourceId(FileSystems.matchNewResource((String)path.toString(), (boolean)false)).setIsReadSeekEfficient(true).setSizeBytes((long)size).build();
    }

    private static FileIO.Write.FileNaming resolveFileNaming(FileIO.Write<?, ?> write) throws Exception {
        return (FileIO.Write.FileNaming)((Contextful.Fn)write.resolveFileNamingFn().getClosure()).apply(null, null);
    }

    private static String getDefaultFileName(FileIO.Write<?, ?> write) throws Exception {
        return FileIOTest.resolveFileNaming(write).getFilename(null, null, 0, 0, null);
    }

    @Test
    public void testFilenameFnResolution() throws Exception {
        FileIO.Write.FileNaming & Serializable foo = (FileIO.Write.FileNaming & Serializable)(window, pane, numShards, shardIndex, compression) -> "foo";
        String expected = FileSystems.matchNewResource((String)"test", (boolean)true).resolve("foo", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE).toString();
        Assert.assertEquals((String)"Filenames should be resolved within a relative directory if '.to' is invoked", (Object)expected, (Object)FileIOTest.getDefaultFileName(FileIO.writeDynamic().to("test").withNaming((SerializableFunction & Serializable)o -> foo)));
        Assert.assertEquals((String)"Filenames should be resolved within a relative directory if '.to' is invoked", (Object)expected, (Object)FileIOTest.getDefaultFileName(FileIO.write().to("test").withNaming((FileIO.Write.FileNaming)foo)));
        Assert.assertEquals((String)"Filenames should be resolved as the direct result of the filenaming function if '.to' is not invoked", (Object)"foo", (Object)FileIOTest.getDefaultFileName(FileIO.writeDynamic().withNaming((SerializableFunction & Serializable)o -> foo)));
        Assert.assertEquals((String)"Filenames should be resolved as the direct result of the filenaming function if '.to' is not invoked", (Object)"foo", (Object)FileIOTest.getDefaultFileName(FileIO.write().withNaming((FileIO.Write.FileNaming)foo)));
        Assert.assertEquals((String)"Default to the defaultNaming if a filenaming isn't provided for a non-dynamic write", (Object)"output-00000-of-00000", (Object)FileIOTest.resolveFileNaming(FileIO.write()).getFilename((BoundedWindow)GlobalWindow.INSTANCE, PaneInfo.ON_TIME_AND_ONLY_FIRING, 0, 0, Compression.UNCOMPRESSED));
        Assert.assertEquals((String)"Default Naming should take prefix and suffix into account if provided", (Object)"foo-00000-of-00000.bar", (Object)FileIOTest.resolveFileNaming(FileIO.write().withPrefix("foo").withSuffix(".bar")).getFilename((BoundedWindow)GlobalWindow.INSTANCE, PaneInfo.ON_TIME_AND_ONLY_FIRING, 0, 0, Compression.UNCOMPRESSED));
        Assert.assertEquals((String)"Filenames should be resolved within a relative directory if '.to' is invoked, even with default naming", (Object)FileSystems.matchNewResource((String)"test", (boolean)true).resolve("output-00000-of-00000", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE).toString(), (Object)FileIOTest.resolveFileNaming(FileIO.write().to("test")).getFilename((BoundedWindow)GlobalWindow.INSTANCE, PaneInfo.ON_TIME_AND_ONLY_FIRING, 0, 0, Compression.UNCOMPRESSED));
    }
}

