/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Random;
import javax.annotation.Nullable;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.FileBasedSource;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.Read;
import org.apache.beam.sdk.io.fs.EmptyMatchTreatment;
import org.apache.beam.sdk.io.fs.MatchResult;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.testing.NeedsRunner;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.SourceTestUtils;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.values.PCollection;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class FileBasedSourceTest {
    private Random random = new Random(0L);
    @Rule
    public final TestPipeline p = TestPipeline.create();
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    public File createFileWithData(String fileName, List<String> data) throws IOException {
        File file = this.tempFolder.newFile(fileName);
        Files.write(file.toPath(), data, StandardCharsets.UTF_8, new OpenOption[0]);
        return file;
    }

    private String createRandomString(int length) {
        char[] chars = "abcdefghijklmnopqrstuvwxyz".toCharArray();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            builder.append(chars[this.random.nextInt(chars.length)]);
        }
        return builder.toString();
    }

    public List<String> createStringDataset(int dataItemLength, int numItems) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < numItems; ++i) {
            list.add(this.createRandomString(dataItemLength));
        }
        return list;
    }

    @Test
    public void testFullyReadSingleFile() throws IOException {
        PipelineOptions options = PipelineOptionsFactory.create();
        List<String> data = this.createStringDataset(3, 50);
        String fileName = "file";
        File file = this.createFileWithData(fileName, data);
        TestFileBasedSource source = new TestFileBasedSource(file.getPath(), 64L, null);
        Assert.assertEquals(data, (Object)SourceTestUtils.readFromSource((BoundedSource)source, (PipelineOptions)options));
    }

    @Test
    public void testFullyReadFilePattern() throws IOException {
        PipelineOptions options = PipelineOptionsFactory.create();
        List<String> data1 = this.createStringDataset(3, 50);
        File file1 = this.createFileWithData("file1", data1);
        List<String> data2 = this.createStringDataset(3, 50);
        this.createFileWithData("file2", data2);
        List<String> data3 = this.createStringDataset(3, 50);
        this.createFileWithData("file3", data3);
        List<String> data4 = this.createStringDataset(3, 50);
        this.createFileWithData("otherfile", data4);
        TestFileBasedSource source = new TestFileBasedSource(new File(file1.getParent(), "file*").getPath(), 64L, null);
        ArrayList<String> expectedResults = new ArrayList<String>();
        expectedResults.addAll(data1);
        expectedResults.addAll(data2);
        expectedResults.addAll(data3);
        Assert.assertThat(expectedResults, (Matcher)Matchers.containsInAnyOrder((Object[])SourceTestUtils.readFromSource((BoundedSource)source, (PipelineOptions)options).toArray()));
    }

    @Test
    public void testEmptyFilepatternTreatmentDefaultDisallow() throws IOException {
        PipelineOptions options = PipelineOptionsFactory.create();
        TestFileBasedSource source = new TestFileBasedSource(new File(this.tempFolder.getRoot(), "doesNotExist").getPath(), 64L, null);
        this.thrown.expect(FileNotFoundException.class);
        SourceTestUtils.readFromSource((BoundedSource)source, (PipelineOptions)options);
    }

    @Test
    public void testEmptyFilepatternTreatmentAllow() throws IOException {
        PipelineOptions options = PipelineOptionsFactory.create();
        TestFileBasedSource source = new TestFileBasedSource(new File(this.tempFolder.getRoot(), "doesNotExist").getPath(), EmptyMatchTreatment.ALLOW, 64L, null);
        TestFileBasedSource sourceWithWildcard = new TestFileBasedSource(new File(this.tempFolder.getRoot(), "doesNotExist*").getPath(), EmptyMatchTreatment.ALLOW_IF_WILDCARD, 64L, null);
        Assert.assertEquals((long)0L, (long)SourceTestUtils.readFromSource((BoundedSource)source, (PipelineOptions)options).size());
        Assert.assertEquals((long)0L, (long)SourceTestUtils.readFromSource((BoundedSource)sourceWithWildcard, (PipelineOptions)options).size());
    }

    @Test
    public void testEmptyFilepatternTreatmentAllowIfWildcard() throws IOException {
        PipelineOptions options = PipelineOptionsFactory.create();
        TestFileBasedSource source = new TestFileBasedSource(new File(this.tempFolder.getRoot(), "doesNotExist").getPath(), EmptyMatchTreatment.ALLOW_IF_WILDCARD, 64L, null);
        this.thrown.expect(FileNotFoundException.class);
        SourceTestUtils.readFromSource((BoundedSource)source, (PipelineOptions)options);
    }

    @Test
    public void testCloseUnstartedFilePatternReader() throws IOException {
        PipelineOptions options = PipelineOptionsFactory.create();
        List<String> data1 = this.createStringDataset(3, 50);
        File file1 = this.createFileWithData("file1", data1);
        List<String> data2 = this.createStringDataset(3, 50);
        this.createFileWithData("file2", data2);
        List<String> data3 = this.createStringDataset(3, 50);
        this.createFileWithData("file3", data3);
        List<String> data4 = this.createStringDataset(3, 50);
        this.createFileWithData("otherfile", data4);
        TestFileBasedSource source = new TestFileBasedSource(new File(file1.getParent(), "file*").getPath(), 64L, null);
        BoundedSource.BoundedReader reader = source.createReader(options);
        try {
            reader.close();
        }
        catch (Exception e) {
            throw new AssertionError("Closing an unstarted FilePatternReader should not throw an exception", e);
        }
    }

    @Test
    public void testSplittingFailsOnEmptyFileExpansion() throws Exception {
        PipelineOptions options = PipelineOptionsFactory.create();
        String missingFilePath = this.tempFolder.newFolder().getAbsolutePath() + "/missing.txt";
        TestFileBasedSource source = new TestFileBasedSource(missingFilePath, Long.MAX_VALUE, null);
        this.thrown.expect(FileNotFoundException.class);
        this.thrown.expectMessage(missingFilePath);
        source.split(1234L, options);
    }

    @Test
    public void testFractionConsumedWhenReadingFilepattern() throws IOException {
        List<String> data1 = this.createStringDataset(3, 1000);
        File file1 = this.createFileWithData("file1", data1);
        List<String> data2 = this.createStringDataset(3, 1000);
        this.createFileWithData("file2", data2);
        List<String> data3 = this.createStringDataset(3, 1000);
        this.createFileWithData("file3", data3);
        TestFileBasedSource source = new TestFileBasedSource(file1.getParent() + "/file*", 1024L, null);
        try (BoundedSource.BoundedReader reader = source.createReader(null);){
            double lastFractionConsumed = 0.0;
            Assert.assertEquals((double)0.0, (double)reader.getFractionConsumed(), (double)1.0E-6);
            Assert.assertTrue((boolean)reader.start());
            Assert.assertTrue((boolean)reader.advance());
            Assert.assertTrue((boolean)reader.advance());
            Assert.assertTrue((reader.getFractionConsumed() > 0.0 ? 1 : 0) != 0);
            Assert.assertTrue((reader.getFractionConsumed() < 0.3333333333333333 ? 1 : 0) != 0);
            while (reader.advance()) {
                double fractionConsumed = reader.getFractionConsumed();
                Assert.assertTrue((fractionConsumed > lastFractionConsumed ? 1 : 0) != 0);
                lastFractionConsumed = fractionConsumed;
            }
            Assert.assertEquals((double)1.0, (double)reader.getFractionConsumed(), (double)1.0E-6);
        }
    }

    @Test
    public void testFullyReadFilePatternFirstRecordEmpty() throws IOException {
        PipelineOptions options = PipelineOptionsFactory.create();
        File file1 = this.createFileWithData("file1", new ArrayList<String>());
        String pattern = file1.getParent() + "/file*";
        List<String> data2 = this.createStringDataset(3, 50);
        this.createFileWithData("file2", data2);
        List<String> data3 = this.createStringDataset(3, 50);
        this.createFileWithData("file3", data3);
        List<String> data4 = this.createStringDataset(3, 50);
        this.createFileWithData("otherfile", data4);
        TestFileBasedSource source = new TestFileBasedSource(pattern, 64L, null);
        ArrayList<String> expectedResults = new ArrayList<String>();
        expectedResults.addAll(data2);
        expectedResults.addAll(data3);
        Assert.assertThat(expectedResults, (Matcher)Matchers.containsInAnyOrder((Object[])SourceTestUtils.readFromSource((BoundedSource)source, (PipelineOptions)options).toArray()));
    }

    @Test
    public void testReadRangeAtStart() throws IOException {
        PipelineOptions options = PipelineOptionsFactory.create();
        List<String> data = this.createStringDataset(3, 50);
        String fileName = "file";
        File file = this.createFileWithData(fileName, data);
        MatchResult.Metadata metadata = FileSystems.matchSingleFileSpec((String)file.getPath());
        TestFileBasedSource source1 = new TestFileBasedSource(metadata, 64L, 0L, 25L, null);
        TestFileBasedSource source2 = new TestFileBasedSource(metadata, 64L, 25L, Long.MAX_VALUE, null);
        ArrayList results = new ArrayList();
        results.addAll(SourceTestUtils.readFromSource((BoundedSource)source1, (PipelineOptions)options));
        results.addAll(SourceTestUtils.readFromSource((BoundedSource)source2, (PipelineOptions)options));
        Assert.assertThat(data, (Matcher)Matchers.containsInAnyOrder((Object[])results.toArray()));
    }

    @Test
    public void testReadEverythingFromFileWithSplits() throws IOException {
        PipelineOptions options = PipelineOptionsFactory.create();
        String header = "<h>";
        ArrayList<String> data = new ArrayList<String>();
        for (int i = 0; i < 10; ++i) {
            data.add(header);
            data.addAll(this.createStringDataset(3, 9));
        }
        String fileName = "file";
        File file = this.createFileWithData(fileName, data);
        TestFileBasedSource source = new TestFileBasedSource(file.getPath(), 64L, header);
        ArrayList<String> expectedResults = new ArrayList<String>();
        expectedResults.addAll(data);
        expectedResults.removeAll(Collections.singletonList(header));
        Assert.assertEquals(expectedResults, (Object)SourceTestUtils.readFromSource((BoundedSource)source, (PipelineOptions)options));
    }

    @Test
    public void testReadRangeFromFileWithSplitsFromStart() throws IOException {
        PipelineOptions options = PipelineOptionsFactory.create();
        String header = "<h>";
        ArrayList<String> data = new ArrayList<String>();
        for (int i = 0; i < 10; ++i) {
            data.add(header);
            data.addAll(this.createStringDataset(3, 9));
        }
        String fileName = "file";
        File file = this.createFileWithData(fileName, data);
        MatchResult.Metadata metadata = FileSystems.matchSingleFileSpec((String)file.getPath());
        TestFileBasedSource source1 = new TestFileBasedSource(metadata, 64L, 0L, 60L, header);
        TestFileBasedSource source2 = new TestFileBasedSource(metadata, 64L, 60L, Long.MAX_VALUE, header);
        ArrayList<String> expectedResults = new ArrayList<String>();
        expectedResults.addAll(data);
        expectedResults.removeAll(Arrays.asList(header));
        ArrayList results = new ArrayList();
        results.addAll(SourceTestUtils.readFromSource((BoundedSource)source1, (PipelineOptions)options));
        results.addAll(SourceTestUtils.readFromSource((BoundedSource)source2, (PipelineOptions)options));
        Assert.assertThat(expectedResults, (Matcher)Matchers.containsInAnyOrder((Object[])results.toArray()));
    }

    @Test
    public void testReadRangeFromFileWithSplitsFromMiddle() throws IOException {
        PipelineOptions options = PipelineOptionsFactory.create();
        String header = "<h>";
        ArrayList<String> data = new ArrayList<String>();
        for (int i = 0; i < 10; ++i) {
            data.add(header);
            data.addAll(this.createStringDataset(3, 9));
        }
        String fileName = "file";
        File file = this.createFileWithData(fileName, data);
        MatchResult.Metadata metadata = FileSystems.matchSingleFileSpec((String)file.getPath());
        TestFileBasedSource source1 = new TestFileBasedSource(metadata, 64L, 0L, 42L, header);
        TestFileBasedSource source2 = new TestFileBasedSource(metadata, 64L, 42L, 112L, header);
        TestFileBasedSource source3 = new TestFileBasedSource(metadata, 64L, 112L, Long.MAX_VALUE, header);
        ArrayList<String> expectedResults = new ArrayList<String>();
        expectedResults.addAll(data);
        expectedResults.removeAll(Collections.singletonList(header));
        ArrayList results = new ArrayList();
        results.addAll(SourceTestUtils.readFromSource((BoundedSource)source1, (PipelineOptions)options));
        results.addAll(SourceTestUtils.readFromSource((BoundedSource)source2, (PipelineOptions)options));
        results.addAll(SourceTestUtils.readFromSource((BoundedSource)source3, (PipelineOptions)options));
        Assert.assertThat(expectedResults, (Matcher)Matchers.containsInAnyOrder((Object[])results.toArray()));
    }

    @Test
    public void testReadFileWithSplitsWithEmptyRange() throws IOException {
        PipelineOptions options = PipelineOptionsFactory.create();
        String header = "<h>";
        ArrayList<String> data = new ArrayList<String>();
        for (int i = 0; i < 5; ++i) {
            data.add(header);
            data.addAll(this.createStringDataset(3, 9));
        }
        String fileName = "file";
        File file = this.createFileWithData(fileName, data);
        MatchResult.Metadata metadata = FileSystems.matchSingleFileSpec((String)file.getPath());
        TestFileBasedSource source1 = new TestFileBasedSource(metadata, 64L, 0L, 42L, header);
        TestFileBasedSource source2 = new TestFileBasedSource(metadata, 64L, 42L, 62L, header);
        TestFileBasedSource source3 = new TestFileBasedSource(metadata, 64L, 62L, Long.MAX_VALUE, header);
        ArrayList<String> expectedResults = new ArrayList<String>();
        expectedResults.addAll(data);
        expectedResults.removeAll(Collections.singletonList(header));
        ArrayList results = new ArrayList();
        results.addAll(SourceTestUtils.readFromSource((BoundedSource)source1, (PipelineOptions)options));
        results.addAll(SourceTestUtils.readFromSource((BoundedSource)source2, (PipelineOptions)options));
        results.addAll(SourceTestUtils.readFromSource((BoundedSource)source3, (PipelineOptions)options));
        Assert.assertThat(expectedResults, (Matcher)Matchers.containsInAnyOrder((Object[])results.toArray()));
    }

    @Test
    public void testReadRangeFromFileWithSplitsFromMiddleOfHeader() throws IOException {
        PipelineOptions options = PipelineOptionsFactory.create();
        String header = "<h>";
        ArrayList<String> data = new ArrayList<String>();
        for (int i = 0; i < 10; ++i) {
            data.add(header);
            data.addAll(this.createStringDataset(3, 9));
        }
        String fileName = "file";
        File file = this.createFileWithData(fileName, data);
        ArrayList expectedResults = new ArrayList();
        expectedResults.addAll(data.subList(10, data.size()));
        expectedResults.removeAll(Collections.singletonList(header));
        MatchResult.Metadata metadata = FileSystems.matchSingleFileSpec((String)file.getPath());
        TestFileBasedSource source = new TestFileBasedSource(metadata, 64L, 1L, Long.MAX_VALUE, header);
        Assert.assertThat(expectedResults, (Matcher)Matchers.containsInAnyOrder((Object[])SourceTestUtils.readFromSource((BoundedSource)source, (PipelineOptions)options).toArray()));
        source = new TestFileBasedSource(metadata, 64L, 2L, Long.MAX_VALUE, header);
        Assert.assertThat(expectedResults, (Matcher)Matchers.containsInAnyOrder((Object[])SourceTestUtils.readFromSource((BoundedSource)source, (PipelineOptions)options).toArray()));
        source = new TestFileBasedSource(metadata, 64L, 3L, Long.MAX_VALUE, header);
        Assert.assertThat(expectedResults, (Matcher)Matchers.containsInAnyOrder((Object[])SourceTestUtils.readFromSource((BoundedSource)source, (PipelineOptions)options).toArray()));
    }

    @Test
    public void testReadRangeAtMiddle() throws IOException {
        PipelineOptions options = PipelineOptionsFactory.create();
        List<String> data = this.createStringDataset(3, 50);
        String fileName = "file";
        File file = this.createFileWithData(fileName, data);
        MatchResult.Metadata metadata = FileSystems.matchSingleFileSpec((String)file.getPath());
        TestFileBasedSource source1 = new TestFileBasedSource(metadata, 64L, 0L, 52L, null);
        TestFileBasedSource source2 = new TestFileBasedSource(metadata, 64L, 52L, 72L, null);
        TestFileBasedSource source3 = new TestFileBasedSource(metadata, 64L, 72L, Long.MAX_VALUE, null);
        ArrayList results = new ArrayList();
        results.addAll(SourceTestUtils.readFromSource((BoundedSource)source1, (PipelineOptions)options));
        results.addAll(SourceTestUtils.readFromSource((BoundedSource)source2, (PipelineOptions)options));
        results.addAll(SourceTestUtils.readFromSource((BoundedSource)source3, (PipelineOptions)options));
        Assert.assertThat(data, (Matcher)Matchers.containsInAnyOrder((Object[])results.toArray()));
    }

    @Test
    public void testReadRangeAtEnd() throws IOException {
        PipelineOptions options = PipelineOptionsFactory.create();
        List<String> data = this.createStringDataset(3, 50);
        String fileName = "file";
        File file = this.createFileWithData(fileName, data);
        MatchResult.Metadata metadata = FileSystems.matchSingleFileSpec((String)file.getPath());
        TestFileBasedSource source1 = new TestFileBasedSource(metadata, 64L, 0L, 162L, null);
        TestFileBasedSource source2 = new TestFileBasedSource(metadata, 1024L, 162L, Long.MAX_VALUE, null);
        ArrayList results = new ArrayList();
        results.addAll(SourceTestUtils.readFromSource((BoundedSource)source1, (PipelineOptions)options));
        results.addAll(SourceTestUtils.readFromSource((BoundedSource)source2, (PipelineOptions)options));
        Assert.assertThat(data, (Matcher)Matchers.containsInAnyOrder((Object[])results.toArray()));
    }

    @Test
    public void testReadAllSplitsOfSingleFile() throws Exception {
        PipelineOptions options = PipelineOptionsFactory.create();
        String fileName = "file";
        List<String> data = this.createStringDataset(3, 50);
        File file = this.createFileWithData(fileName, data);
        TestFileBasedSource source = new TestFileBasedSource(file.getPath(), 16L, null);
        List sources = source.split(32L, null);
        Assert.assertTrue((sources.size() > 1 ? 1 : 0) != 0);
        ArrayList results = new ArrayList();
        for (BoundedSource split : sources) {
            results.addAll(SourceTestUtils.readFromSource((BoundedSource)split, (PipelineOptions)options));
        }
        Assert.assertThat(data, (Matcher)Matchers.containsInAnyOrder((Object[])results.toArray()));
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testDataflowFile() throws IOException {
        List<String> data = this.createStringDataset(3, 50);
        String fileName = "file";
        File file = this.createFileWithData(fileName, data);
        TestFileBasedSource source = new TestFileBasedSource(file.getPath(), 64L, null);
        PCollection output = (PCollection)this.p.apply("ReadFileData", (PTransform)Read.from((BoundedSource)source));
        PAssert.that((PCollection)output).containsInAnyOrder(data);
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testDataflowFilePattern() throws IOException {
        List<String> data1 = this.createStringDataset(3, 50);
        File file1 = this.createFileWithData("file1", data1);
        List<String> data2 = this.createStringDataset(3, 50);
        this.createFileWithData("file2", data2);
        List<String> data3 = this.createStringDataset(3, 50);
        this.createFileWithData("file3", data3);
        List<String> data4 = this.createStringDataset(3, 50);
        this.createFileWithData("otherfile", data4);
        TestFileBasedSource source = new TestFileBasedSource(new File(file1.getParent(), "file*").getPath(), 64L, null);
        PCollection output = (PCollection)this.p.apply("ReadFileData", (PTransform)Read.from((BoundedSource)source));
        ArrayList<String> expectedResults = new ArrayList<String>();
        expectedResults.addAll(data1);
        expectedResults.addAll(data2);
        expectedResults.addAll(data3);
        PAssert.that((PCollection)output).containsInAnyOrder(expectedResults);
        this.p.run();
    }

    @Test
    public void testEstimatedSizeOfFile() throws Exception {
        List<String> data = this.createStringDataset(3, 50);
        String fileName = "file";
        File file = this.createFileWithData(fileName, data);
        TestFileBasedSource source = new TestFileBasedSource(file.getPath(), 64L, null);
        Assert.assertEquals((long)file.length(), (long)source.getEstimatedSizeBytes(null));
    }

    @Test
    public void testEstimatedSizeOfFilePattern() throws Exception {
        List<String> data1 = this.createStringDataset(3, 20);
        File file1 = this.createFileWithData("file1", data1);
        List<String> data2 = this.createStringDataset(3, 40);
        File file2 = this.createFileWithData("file2", data2);
        List<String> data3 = this.createStringDataset(3, 30);
        File file3 = this.createFileWithData("file3", data3);
        List<String> data4 = this.createStringDataset(3, 45);
        this.createFileWithData("otherfile", data4);
        List<String> data5 = this.createStringDataset(3, 53);
        this.createFileWithData("anotherfile", data5);
        TestFileBasedSource source = new TestFileBasedSource(new File(file1.getParent(), "file*").getPath(), 64L, null);
        Assert.assertEquals((long)(file1.length() + file2.length() + file3.length()), (long)source.getEstimatedSizeBytes(null));
    }

    @Test
    public void testReadAllSplitsOfFilePattern() throws Exception {
        PipelineOptions options = PipelineOptionsFactory.create();
        List<String> data1 = this.createStringDataset(3, 50);
        File file1 = this.createFileWithData("file1", data1);
        List<String> data2 = this.createStringDataset(3, 50);
        this.createFileWithData("file2", data2);
        List<String> data3 = this.createStringDataset(3, 50);
        this.createFileWithData("file3", data3);
        List<String> data4 = this.createStringDataset(3, 50);
        this.createFileWithData("otherfile", data4);
        TestFileBasedSource source = new TestFileBasedSource(new File(file1.getParent(), "file*").getPath(), 64L, null);
        List sources = source.split(512L, null);
        Assert.assertTrue((sources.size() > 1 ? 1 : 0) != 0);
        ArrayList results = new ArrayList();
        for (BoundedSource split : sources) {
            results.addAll(SourceTestUtils.readFromSource((BoundedSource)split, (PipelineOptions)options));
        }
        ArrayList<String> expectedResults = new ArrayList<String>();
        expectedResults.addAll(data1);
        expectedResults.addAll(data2);
        expectedResults.addAll(data3);
        Assert.assertThat(expectedResults, (Matcher)Matchers.containsInAnyOrder((Object[])results.toArray()));
    }

    @Test
    public void testSplitAtFraction() throws Exception {
        PipelineOptions options = PipelineOptionsFactory.create();
        File file = this.createFileWithData("file", this.createStringDataset(3, 100));
        MatchResult.Metadata metadata = FileSystems.matchSingleFileSpec((String)file.getPath());
        TestFileBasedSource source = new TestFileBasedSource(metadata, 1L, 0L, file.length(), null);
        SourceTestUtils.assertSplitAtFractionFails((BoundedSource)source, (int)0, (double)0.7, (PipelineOptions)options);
        SourceTestUtils.assertSplitAtFractionSucceedsAndConsistent((BoundedSource)source, (int)1, (double)0.7, (PipelineOptions)options);
        SourceTestUtils.assertSplitAtFractionSucceedsAndConsistent((BoundedSource)source, (int)30, (double)0.7, (PipelineOptions)options);
        SourceTestUtils.assertSplitAtFractionFails((BoundedSource)source, (int)0, (double)0.0, (PipelineOptions)options);
        SourceTestUtils.assertSplitAtFractionFails((BoundedSource)source, (int)70, (double)0.3, (PipelineOptions)options);
        SourceTestUtils.assertSplitAtFractionFails((BoundedSource)source, (int)100, (double)1.0, (PipelineOptions)options);
        SourceTestUtils.assertSplitAtFractionFails((BoundedSource)source, (int)100, (double)0.99, (PipelineOptions)options);
        SourceTestUtils.assertSplitAtFractionSucceedsAndConsistent((BoundedSource)source, (int)100, (double)0.995, (PipelineOptions)options);
    }

    @Test
    public void testSplitAtFractionExhaustive() throws Exception {
        PipelineOptions options = PipelineOptionsFactory.create();
        File file = this.createFileWithData("file", this.createStringDataset(3, 20));
        MatchResult.Metadata metadata = FileSystems.matchSingleFileSpec((String)file.getPath());
        TestFileBasedSource source = new TestFileBasedSource(metadata, 1L, 0L, file.length(), null);
        SourceTestUtils.assertSplitAtFractionExhaustive((BoundedSource)source, (PipelineOptions)options);
    }

    @Test
    public void testToStringFile() throws Exception {
        File f = this.createFileWithData("foo", Collections.emptyList());
        MatchResult.Metadata metadata = FileSystems.matchSingleFileSpec((String)f.getPath());
        TestFileBasedSource source = new TestFileBasedSource(metadata, 1L, 0L, 10L, null);
        Assert.assertEquals((Object)String.format("%s range [0, 10)", f.getAbsolutePath()), (Object)source.toString());
    }

    private static class TestReaderWithSplits
    extends FileBasedSource.FileBasedReader<String> {
        private LineReader lineReader;
        private final String splitHeader;
        private boolean foundFirstSplitPoint = false;
        private boolean isAtSplitPoint = false;
        private long currentOffset;

        public TestReaderWithSplits(TestFileBasedSource source) {
            super((FileBasedSource)source);
            this.splitHeader = source.splitHeader;
        }

        protected void startReading(ReadableByteChannel channel) throws IOException {
            this.lineReader = new LineReader(channel);
        }

        protected boolean readNextRecord() throws IOException {
            if (!this.foundFirstSplitPoint) {
                while (!this.isAtSplitPoint) {
                    if (this.readNextRecordInternal()) continue;
                    return false;
                }
                this.foundFirstSplitPoint = true;
                return true;
            }
            return this.readNextRecordInternal();
        }

        private boolean readNextRecordInternal() throws IOException {
            this.isAtSplitPoint = false;
            if (!this.lineReader.readNextLine()) {
                return false;
            }
            this.currentOffset = this.lineReader.getCurrentLineStart();
            while (this.getCurrent().equals(this.splitHeader)) {
                this.currentOffset = this.lineReader.getCurrentLineStart();
                if (!this.lineReader.readNextLine()) {
                    return false;
                }
                this.isAtSplitPoint = true;
            }
            return true;
        }

        protected boolean isAtSplitPoint() {
            return this.isAtSplitPoint;
        }

        protected long getCurrentOffset() {
            return this.currentOffset;
        }

        public String getCurrent() throws NoSuchElementException {
            return this.lineReader.getCurrent();
        }
    }

    private static class TestReader
    extends FileBasedSource.FileBasedReader<String> {
        private LineReader lineReader = null;

        public TestReader(TestFileBasedSource source) {
            super((FileBasedSource)source);
        }

        protected void startReading(ReadableByteChannel channel) throws IOException {
            this.lineReader = new LineReader(channel);
        }

        protected boolean readNextRecord() throws IOException {
            return this.lineReader.readNextLine();
        }

        protected boolean isAtSplitPoint() {
            return true;
        }

        protected long getCurrentOffset() {
            return this.lineReader.getCurrentLineStart();
        }

        public String getCurrent() throws NoSuchElementException {
            return this.lineReader.getCurrent();
        }
    }

    private static class LineReader {
        private ReadableByteChannel channel = null;
        private long nextLineStart = 0L;
        private long currentLineStart = 0L;
        private final ByteBuffer buf = ByteBuffer.allocate(1024);
        private static final int BUF_SIZE = 1024;
        private String currentValue = null;

        public LineReader(ReadableByteChannel channel) throws IOException {
            this.buf.flip();
            boolean removeLine = false;
            if (channel instanceof SeekableByteChannel) {
                SeekableByteChannel seekChannel = (SeekableByteChannel)channel;
                if (seekChannel.position() > 0L) {
                    seekChannel.position(seekChannel.position() - 1L);
                    removeLine = true;
                }
                this.nextLineStart = seekChannel.position();
            }
            this.channel = channel;
            if (removeLine) {
                this.nextLineStart += (long)this.readNextLine(new ByteArrayOutputStream());
            }
        }

        private int readNextLine(ByteArrayOutputStream out) throws IOException {
            int byteCount = 0;
            while (true) {
                if (!this.buf.hasRemaining()) {
                    this.buf.clear();
                    int read = this.channel.read(this.buf);
                    if (read < 0) break;
                    this.buf.flip();
                }
                byte b = this.buf.get();
                ++byteCount;
                if (b == 10) break;
                out.write(b);
            }
            return byteCount;
        }

        public boolean readNextLine() throws IOException {
            this.currentLineStart = this.nextLineStart;
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            int offsetAdjustment = this.readNextLine(buf);
            if (offsetAdjustment == 0) {
                return false;
            }
            this.nextLineStart += (long)offsetAdjustment;
            this.currentValue = ((String)CoderUtils.decodeFromByteArray((Coder)StringUtf8Coder.of(), (byte[])buf.toByteArray())).trim();
            return true;
        }

        public String getCurrent() {
            return this.currentValue;
        }

        public long getCurrentLineStart() {
            return this.currentLineStart;
        }
    }

    static class TestFileBasedSource
    extends FileBasedSource<String> {
        final String splitHeader;

        public TestFileBasedSource(String fileOrPattern, long minBundleSize, String splitHeader) {
            super((ValueProvider)ValueProvider.StaticValueProvider.of((Object)fileOrPattern), minBundleSize);
            this.splitHeader = splitHeader;
        }

        public TestFileBasedSource(String fileOrPattern, EmptyMatchTreatment emptyMatchTreatment, long minBundleSize, String splitHeader) {
            super((ValueProvider)ValueProvider.StaticValueProvider.of((Object)fileOrPattern), emptyMatchTreatment, minBundleSize);
            this.splitHeader = splitHeader;
        }

        public TestFileBasedSource(MatchResult.Metadata fileOrPattern, long minBundleSize, long startOffset, long endOffset, @Nullable String splitHeader) {
            super(fileOrPattern, minBundleSize, startOffset, endOffset);
            this.splitHeader = splitHeader;
        }

        public Coder<String> getOutputCoder() {
            return StringUtf8Coder.of();
        }

        protected FileBasedSource<String> createForSubrangeOfFile(MatchResult.Metadata fileName, long start, long end) {
            return new TestFileBasedSource(fileName, this.getMinBundleSize(), start, end, this.splitHeader);
        }

        protected FileBasedSource.FileBasedReader<String> createSingleFileReader(PipelineOptions options) {
            if (this.splitHeader == null) {
                return new TestReader(this);
            }
            return new TestReaderWithSplits(this);
        }
    }
}

