/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import org.apache.beam.sdk.io.FileBasedSink;

public class DrunkWritableByteChannelFactory
implements FileBasedSink.WritableByteChannelFactory {
    public WritableByteChannel create(WritableByteChannel channel) throws IOException {
        return new DrunkWritableByteChannel(channel);
    }

    public String getMimeType() {
        return "text/plain";
    }

    public String getSuggestedFilenameSuffix() {
        return ".drunk";
    }

    public String toString() {
        return "DRUNK";
    }

    private static class DrunkWritableByteChannel
    implements WritableByteChannel {
        protected final WritableByteChannel channel;

        public DrunkWritableByteChannel(WritableByteChannel channel) {
            this.channel = channel;
        }

        @Override
        public boolean isOpen() {
            return this.channel.isOpen();
        }

        @Override
        public void close() throws IOException {
            this.channel.close();
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            int w1 = this.channel.write(src);
            src.rewind();
            int w2 = this.channel.write(src);
            return w1 + w2;
        }
    }
}

