/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import org.apache.beam.sdk.io.DefaultFilenamePolicy;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class DefaultFilenamePolicyTest {
    private static String constructName(String baseFilename, String shardTemplate, String suffix, int shardNum, int numShards, String paneStr, String windowStr) {
        ResourceId constructed = DefaultFilenamePolicy.constructName((ResourceId)FileSystems.matchNewResource((String)baseFilename, (boolean)false), (String)shardTemplate, (String)suffix, (int)shardNum, (int)numShards, (String)paneStr, (String)windowStr);
        return constructed.toString();
    }

    @Test
    public void testConstructName() {
        Assert.assertEquals((Object)"/path/to/output-001-of-123.txt", (Object)DefaultFilenamePolicyTest.constructName("/path/to/output", "-SSS-of-NNN", ".txt", 1, 123, null, null));
        Assert.assertEquals((Object)"/path/to/out.txt/part-00042", (Object)DefaultFilenamePolicyTest.constructName("/path/to/out.txt", "/part-SSSSS", "", 42, 100, null, null));
        Assert.assertEquals((Object)"/path/to/out.txt", (Object)DefaultFilenamePolicyTest.constructName("/path/to/ou", "t.t", "xt", 1, 1, null, null));
        Assert.assertEquals((Object)"/path/to/out0102shard.txt", (Object)DefaultFilenamePolicyTest.constructName("/path/to/out", "SSNNshard", ".txt", 1, 2, null, null));
        Assert.assertEquals((Object)"/path/to/out-2/1.part-1-of-2.txt", (Object)DefaultFilenamePolicyTest.constructName("/path/to/out", "-N/S.part-S-of-N", ".txt", 1, 2, null, null));
    }

    @Test
    public void testConstructNameWithLargeShardCount() {
        Assert.assertEquals((Object)"/out-100-of-5000.txt", (Object)DefaultFilenamePolicyTest.constructName("/out", "-SS-of-NN", ".txt", 100, 5000, null, null));
    }

    @Test
    public void testConstructWindowedName() {
        Assert.assertEquals((Object)"/path/to/output-001-of-123.txt", (Object)DefaultFilenamePolicyTest.constructName("/path/to/output", "-SSS-of-NNN", ".txt", 1, 123, null, null));
        Assert.assertEquals((Object)"/path/to/output-001-of-123-PPP-W.txt", (Object)DefaultFilenamePolicyTest.constructName("/path/to/output", "-SSS-of-NNN-PPP-W", ".txt", 1, 123, null, null));
        Assert.assertEquals((Object)"/path/to/out.txt/part-00042-myPaneStr-myWindowStr", (Object)DefaultFilenamePolicyTest.constructName("/path/to/out.txt", "/part-SSSSS-P-W", "", 42, 100, "myPaneStr", "myWindowStr"));
        Assert.assertEquals((Object)"/path/to/out.txt", (Object)DefaultFilenamePolicyTest.constructName("/path/to/ou", "t.t", "xt", 1, 1, "myPaneStr2", "anotherWindowStr"));
        Assert.assertEquals((Object)"/path/to/out0102shard-oneMoreWindowStr-anotherPaneStr.txt", (Object)DefaultFilenamePolicyTest.constructName("/path/to/out", "SSNNshard-W-P", ".txt", 1, 2, "anotherPaneStr", "oneMoreWindowStr"));
        Assert.assertEquals((Object)"/out-2/1.part-1-of-2-slidingWindow1-myPaneStr3-windowslidingWindow1-panemyPaneStr3.txt", (Object)DefaultFilenamePolicyTest.constructName("/out", "-N/S.part-S-of-N-W-P-windowW-paneP", ".txt", 1, 2, "myPaneStr3", "slidingWindow1"));
        Assert.assertEquals((Object)"/out.txt/part-00042-myWindowStr-pane-11-true-false", (Object)DefaultFilenamePolicyTest.constructName("/out.txt", "/part-SSSSS-W-P", "", 42, 100, "pane-11-true-false", "myWindowStr"));
        Assert.assertEquals((Object)"/path/to/out.txt", (Object)DefaultFilenamePolicyTest.constructName("/path/to/ou", "t.t", "xt", 1, 1, "pane", "anotherWindowStr"));
        Assert.assertEquals((Object)"/out0102shard-oneMoreWindowStr-pane--1-false-false-pane--1-false-false.txt", (Object)DefaultFilenamePolicyTest.constructName("/out", "SSNNshard-W-P-P", ".txt", 1, 2, "pane--1-false-false", "oneMoreWindowStr"));
        Assert.assertEquals((Object)"/path/to/out-2/1.part-1-of-2-sWindow1-winsWindow1-ppaneL.txt", (Object)DefaultFilenamePolicyTest.constructName("/path/to/out", "-N/S.part-S-of-N-W-winW-pP", ".txt", 1, 2, "paneL", "sWindow1"));
    }
}

