/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Random;
import org.apache.avro.Schema;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.reflect.AvroDefault;
import org.apache.avro.reflect.Nullable;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.reflect.ReflectDatumWriter;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.base.MoreObjects;
import org.apache.beam.sdk.coders.AvroCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.DefaultCoder;
import org.apache.beam.sdk.io.AvroSource;
import org.apache.beam.sdk.io.BlockBasedSource;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.fs.MatchResult;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.testing.SourceTestUtils;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.DisplayDataMatchers;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.util.SerializableUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class AvroSourceTest {
    @Rule
    public TemporaryFolder tmpFolder = new TemporaryFolder();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private static final int DEFAULT_RECORD_COUNT = 1000;

    private <T> String generateTestFile(String filename, List<T> elems, SyncBehavior syncBehavior, int syncInterval, AvroCoder<T> coder, String codec) throws IOException {
        Random random = new Random(0L);
        File tmpFile = this.tmpFolder.newFile(filename);
        String path = tmpFile.toString();
        FileOutputStream os = new FileOutputStream(tmpFile);
        GenericDatumWriter datumWriter = coder.getType().equals(GenericRecord.class) ? new GenericDatumWriter(coder.getSchema()) : new ReflectDatumWriter(coder.getSchema());
        try (DataFileWriter writer = new DataFileWriter((DatumWriter)datumWriter);){
            writer.setCodec(CodecFactory.fromString((String)codec));
            writer.create(coder.getSchema(), (OutputStream)os);
            int recordIndex = 0;
            int syncIndex = syncBehavior == SyncBehavior.SYNC_RANDOM ? random.nextInt(syncInterval) : 0;
            for (T elem : elems) {
                writer.append(elem);
                ++recordIndex;
                switch (syncBehavior) {
                    case SYNC_REGULAR: {
                        if (recordIndex != syncInterval) break;
                        recordIndex = 0;
                        writer.sync();
                        break;
                    }
                    case SYNC_RANDOM: {
                        if (recordIndex != syncIndex) break;
                        recordIndex = 0;
                        writer.sync();
                        syncIndex = random.nextInt(syncInterval);
                        break;
                    }
                }
            }
        }
        return path;
    }

    @Test
    public void testReadWithDifferentCodecs() throws Exception {
        String[] codecs = new String[]{"null", "bzip2", "deflate", "snappy", "xz"};
        List<Bird> expected = AvroSourceTest.createRandomRecords(65536L);
        for (String codec : codecs) {
            String filename = this.generateTestFile(codec, expected, SyncBehavior.SYNC_DEFAULT, 0, AvroCoder.of(Bird.class), codec);
            AvroSource source = AvroSource.from((String)filename).withSchema(Bird.class);
            List actual = SourceTestUtils.readFromSource((BoundedSource)source, null);
            Assert.assertThat(expected, (Matcher)Matchers.containsInAnyOrder((Object[])actual.toArray()));
        }
    }

    @Test
    public void testSplitAtFraction() throws Exception {
        List<FixedRecord> expected = AvroSourceTest.createFixedRecords(1000);
        String filename = this.generateTestFile("tmp.avro", expected, SyncBehavior.SYNC_REGULAR, 100, AvroCoder.of(FixedRecord.class), "null");
        File file = new File(filename);
        AvroSource source = AvroSource.from((String)filename).withSchema(FixedRecord.class);
        List splits = source.split(file.length() / 3L, null);
        for (BoundedSource subSource : splits) {
            int items = SourceTestUtils.readFromSource((BoundedSource)subSource, null).size();
            SourceTestUtils.assertSplitAtFractionFails((BoundedSource)subSource, (int)0, (double)0.0, null);
            SourceTestUtils.assertSplitAtFractionFails((BoundedSource)subSource, (int)0, (double)0.7, null);
            SourceTestUtils.assertSplitAtFractionSucceedsAndConsistent((BoundedSource)subSource, (int)1, (double)0.7, null);
            SourceTestUtils.assertSplitAtFractionSucceedsAndConsistent((BoundedSource)subSource, (int)10, (double)0.7, null);
            SourceTestUtils.assertSplitAtFractionSucceedsAndConsistent((BoundedSource)subSource, (int)100, (double)0.1, null);
            SourceTestUtils.assertSplitAtFractionFails((BoundedSource)subSource, (int)101, (double)0.1, null);
            SourceTestUtils.assertSplitAtFractionFails((BoundedSource)subSource, (int)333, (double)0.3, null);
            SourceTestUtils.assertSplitAtFractionFails((BoundedSource)subSource, (int)items, (double)0.9, null);
            SourceTestUtils.assertSplitAtFractionFails((BoundedSource)subSource, (int)items, (double)1.0, null);
            SourceTestUtils.assertSplitAtFractionSucceedsAndConsistent((BoundedSource)subSource, (int)items, (double)0.999, null);
        }
    }

    @Test
    public void testGetProgressFromUnstartedReader() throws Exception {
        List<FixedRecord> records = AvroSourceTest.createFixedRecords(1000);
        String filename = this.generateTestFile("tmp.avro", records, SyncBehavior.SYNC_DEFAULT, 1000, AvroCoder.of(FixedRecord.class), "null");
        File file = new File(filename);
        AvroSource source = AvroSource.from((String)filename).withSchema(FixedRecord.class);
        Object object = null;
        try (BoundedSource.BoundedReader reader = source.createReader(null);){
            Assert.assertEquals((Object)0.0, (Object)reader.getFractionConsumed());
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        List splits = source.split(file.length() / 3L, null);
        for (BoundedSource subSource : splits) {
            BoundedSource.BoundedReader reader = subSource.createReader(null);
            Throwable throwable = null;
            try {
                Assert.assertEquals((Object)0.0, (Object)reader.getFractionConsumed());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (reader == null) continue;
                AvroSourceTest.$closeResource(throwable, (AutoCloseable)reader);
            }
        }
    }

    @Test
    public void testProgress() throws Exception {
        List<FixedRecord> records = AvroSourceTest.createFixedRecords(5);
        String filename = this.generateTestFile("tmp.avro", records, SyncBehavior.SYNC_REGULAR, 2, AvroCoder.of(FixedRecord.class), "null");
        AvroSource source = AvroSource.from((String)filename).withSchema(FixedRecord.class);
        try (BoundedSource.BoundedReader readerOrig = source.createReader(null);){
            Assert.assertThat((Object)readerOrig, (Matcher)Matchers.instanceOf(BlockBasedSource.BlockBasedReader.class));
            BlockBasedSource.BlockBasedReader reader = (BlockBasedSource.BlockBasedReader)readerOrig;
            Assert.assertEquals((double)0.0, (double)reader.getFractionConsumed(), (double)1.0E-6);
            Assert.assertEquals((long)0L, (long)reader.getSplitPointsConsumed());
            Assert.assertEquals((long)-1L, (long)reader.getSplitPointsRemaining());
            Assert.assertTrue((boolean)reader.start());
            Assert.assertTrue((boolean)reader.isAtSplitPoint());
            Assert.assertEquals((long)0L, (long)reader.getSplitPointsConsumed());
            Assert.assertEquals((long)-1L, (long)reader.getSplitPointsRemaining());
            Assert.assertTrue((boolean)reader.advance());
            Assert.assertFalse((boolean)reader.isAtSplitPoint());
            Assert.assertEquals((long)0L, (long)reader.getSplitPointsConsumed());
            Assert.assertEquals((long)-1L, (long)reader.getSplitPointsRemaining());
            Assert.assertTrue((boolean)reader.advance());
            Assert.assertTrue((boolean)reader.isAtSplitPoint());
            Assert.assertEquals((long)1L, (long)reader.getSplitPointsConsumed());
            Assert.assertEquals((long)-1L, (long)reader.getSplitPointsRemaining());
            Assert.assertTrue((boolean)reader.advance());
            Assert.assertFalse((boolean)reader.isAtSplitPoint());
            Assert.assertEquals((long)1L, (long)reader.getSplitPointsConsumed());
            Assert.assertEquals((long)-1L, (long)reader.getSplitPointsRemaining());
            Assert.assertTrue((boolean)reader.advance());
            Assert.assertTrue((boolean)reader.isAtSplitPoint());
            Assert.assertEquals((long)2L, (long)reader.getSplitPointsConsumed());
            Assert.assertEquals((long)1L, (long)reader.getSplitPointsRemaining());
            Assert.assertFalse((boolean)reader.advance());
            Assert.assertEquals((long)3L, (long)reader.getSplitPointsConsumed());
            Assert.assertEquals((long)0L, (long)reader.getSplitPointsRemaining());
            Assert.assertEquals((double)1.0, (double)reader.getFractionConsumed(), (double)1.0E-6);
        }
    }

    @Test
    public void testProgressEmptySource() throws Exception {
        List records = Collections.emptyList();
        String filename = this.generateTestFile("tmp.avro", records, SyncBehavior.SYNC_REGULAR, 2, AvroCoder.of(FixedRecord.class), "null");
        AvroSource source = AvroSource.from((String)filename).withSchema(FixedRecord.class);
        try (BoundedSource.BoundedReader readerOrig = source.createReader(null);){
            Assert.assertThat((Object)readerOrig, (Matcher)Matchers.instanceOf(BlockBasedSource.BlockBasedReader.class));
            BlockBasedSource.BlockBasedReader reader = (BlockBasedSource.BlockBasedReader)readerOrig;
            Assert.assertEquals((double)0.0, (double)reader.getFractionConsumed(), (double)1.0E-6);
            Assert.assertEquals((long)0L, (long)reader.getSplitPointsConsumed());
            Assert.assertEquals((long)-1L, (long)reader.getSplitPointsRemaining());
            Assert.assertFalse((boolean)reader.start());
            Assert.assertEquals((long)0L, (long)reader.getSplitPointsConsumed());
            Assert.assertEquals((long)0L, (long)reader.getSplitPointsRemaining());
            Assert.assertEquals((double)1.0, (double)reader.getFractionConsumed(), (double)1.0E-6);
        }
    }

    @Test
    public void testGetCurrentFromUnstartedReader() throws Exception {
        List<FixedRecord> records = AvroSourceTest.createFixedRecords(1000);
        String filename = this.generateTestFile("tmp.avro", records, SyncBehavior.SYNC_DEFAULT, 1000, AvroCoder.of(FixedRecord.class), "null");
        AvroSource source = AvroSource.from((String)filename).withSchema(FixedRecord.class);
        try (BlockBasedSource.BlockBasedReader reader = (BlockBasedSource.BlockBasedReader)source.createReader(null);){
            Assert.assertEquals(null, (Object)reader.getCurrentBlock());
            this.expectedException.expect(NoSuchElementException.class);
            this.expectedException.expectMessage("No block has been successfully read from");
            reader.getCurrent();
        }
    }

    @Test
    public void testSplitAtFractionExhaustive() throws Exception {
        List<FixedRecord> expected = AvroSourceTest.createFixedRecords(20);
        String filename = this.generateTestFile("tmp.avro", expected, SyncBehavior.SYNC_REGULAR, 5, AvroCoder.of(FixedRecord.class), "null");
        AvroSource source = AvroSource.from((String)filename).withSchema(FixedRecord.class);
        SourceTestUtils.assertSplitAtFractionExhaustive((BoundedSource)source, null);
    }

    @Test
    public void testSplitsWithSmallBlocks() throws Exception {
        PipelineOptions options = PipelineOptionsFactory.create();
        List<Bird> expected = AvroSourceTest.createRandomRecords(1000L);
        String filename = this.generateTestFile("tmp.avro", expected, SyncBehavior.SYNC_RANDOM, 50, AvroCoder.of(Bird.class), "null");
        File file = new File(filename);
        AvroSource source = AvroSource.from((String)filename).withSchema(Bird.class).withMinBundleSize(100L);
        Assert.assertEquals(expected, (Object)SourceTestUtils.readFromSource((BoundedSource)source, (PipelineOptions)options));
        List splits = source.split(100L, options);
        Assert.assertTrue((splits.size() > 2 ? 1 : 0) != 0);
        SourceTestUtils.assertSourcesEqualReferenceSource((BoundedSource)source, (List)splits, (PipelineOptions)options);
        int nonEmptySplits = 0;
        for (BoundedSource subSource : splits) {
            if (SourceTestUtils.readFromSource((BoundedSource)subSource, (PipelineOptions)options).size() <= 0) continue;
            ++nonEmptySplits;
        }
        Assert.assertTrue((nonEmptySplits > 2 ? 1 : 0) != 0);
        splits = source.split(file.length() / 4L, options);
        Assert.assertTrue((splits.size() > 2 ? 1 : 0) != 0);
        SourceTestUtils.assertSourcesEqualReferenceSource((BoundedSource)source, (List)splits, (PipelineOptions)options);
        nonEmptySplits = 0;
        for (BoundedSource subSource : splits) {
            if (SourceTestUtils.readFromSource((BoundedSource)subSource, (PipelineOptions)options).size() <= 0) continue;
            ++nonEmptySplits;
        }
        Assert.assertTrue((nonEmptySplits > 2 ? 1 : 0) != 0);
        splits = source.split(file.length(), options);
        Assert.assertTrue((splits.size() == 1 ? 1 : 0) != 0);
        SourceTestUtils.assertSourcesEqualReferenceSource((BoundedSource)source, (List)splits, (PipelineOptions)options);
    }

    @Test
    public void testMultipleFiles() throws Exception {
        String baseName = "tmp-";
        ArrayList<Bird> expected = new ArrayList<Bird>();
        for (int i = 0; i < 10; ++i) {
            List<Bird> contents = AvroSourceTest.createRandomRecords(100L);
            expected.addAll(contents);
            this.generateTestFile(baseName + i, contents, SyncBehavior.SYNC_DEFAULT, 0, AvroCoder.of(Bird.class), "null");
        }
        AvroSource source = AvroSource.from((String)new File(this.tmpFolder.getRoot().toString(), baseName + "*").toString()).withSchema(Bird.class);
        List actual = SourceTestUtils.readFromSource((BoundedSource)source, null);
        Assert.assertThat((Object)actual, (Matcher)Matchers.containsInAnyOrder((Object[])expected.toArray()));
    }

    @Test
    public void testCreationWithSchema() throws Exception {
        List<Bird> expected = AvroSourceTest.createRandomRecords(100L);
        String filename = this.generateTestFile("tmp.avro", expected, SyncBehavior.SYNC_DEFAULT, 0, AvroCoder.of(Bird.class), "null");
        Schema schema = ReflectData.get().getSchema(Bird.class);
        AvroSource source = AvroSource.from((String)filename).withSchema(schema);
        List records = SourceTestUtils.readFromSource((BoundedSource)source, null);
        this.assertEqualsWithGeneric(expected, records);
        String schemaString = ReflectData.get().getSchema(Bird.class).toString();
        source = AvroSource.from((String)filename).withSchema(schemaString);
        records = SourceTestUtils.readFromSource((BoundedSource)source, null);
        this.assertEqualsWithGeneric(expected, records);
    }

    @Test
    public void testSchemaUpdate() throws Exception {
        List<Bird> birds = AvroSourceTest.createRandomRecords(100L);
        String filename = this.generateTestFile("tmp.avro", birds, SyncBehavior.SYNC_DEFAULT, 0, AvroCoder.of(Bird.class), "null");
        AvroSource source = AvroSource.from((String)filename).withSchema(FancyBird.class);
        List actual = SourceTestUtils.readFromSource((BoundedSource)source, null);
        ArrayList<FancyBird> expected = new ArrayList<FancyBird>();
        for (Bird bird : birds) {
            expected.add(new FancyBird(bird.number, bird.species, bird.quality, bird.quantity, null, "MAXIMUM OVERDRIVE"));
        }
        Assert.assertThat((Object)actual, (Matcher)Matchers.containsInAnyOrder((Object[])expected.toArray()));
    }

    @Test
    public void testSchemaStringIsInterned() throws Exception {
        List<Bird> birds = AvroSourceTest.createRandomRecords(100L);
        String filename = this.generateTestFile("tmp.avro", birds, SyncBehavior.SYNC_DEFAULT, 0, AvroCoder.of(Bird.class), "null");
        MatchResult.Metadata fileMetadata = FileSystems.matchSingleFileSpec((String)filename);
        String schema = AvroSource.readMetadataFromFile((ResourceId)fileMetadata.resourceId()).getSchemaString();
        AvroSource sourceA = AvroSource.from((String)filename).withSchema("" + schema);
        AvroSource sourceB = AvroSource.from((String)filename).withSchema("" + schema);
        Assert.assertSame((Object)sourceA.getReaderSchemaString(), (Object)sourceB.getReaderSchemaString());
        AvroSource sourceC = (AvroSource)SerializableUtils.clone((Serializable)sourceB);
        Assert.assertSame((Object)sourceA.getReaderSchemaString(), (Object)sourceC.getReaderSchemaString());
    }

    @Test
    public void testParseFn() throws Exception {
        List<Bird> expected = AvroSourceTest.createRandomRecords(100L);
        String filename = this.generateTestFile("tmp.avro", expected, SyncBehavior.SYNC_DEFAULT, 0, AvroCoder.of(Bird.class), "null");
        AvroSource source = AvroSource.from((String)filename).withParseFn((SerializableFunction & Serializable)input -> new Bird((Long)input.get("number"), input.get("species").toString(), input.get("quality").toString(), (Long)input.get("quantity")), (Coder)AvroCoder.of(Bird.class));
        List actual = SourceTestUtils.readFromSource((BoundedSource)source, null);
        Assert.assertThat((Object)actual, (Matcher)Matchers.containsInAnyOrder((Object[])expected.toArray()));
    }

    private void assertEqualsWithGeneric(List<Bird> expected, List<GenericRecord> actual) {
        Assert.assertEquals((long)expected.size(), (long)actual.size());
        for (int i = 0; i < expected.size(); ++i) {
            Bird fixed = expected.get(i);
            GenericRecord generic = actual.get(i);
            Assert.assertEquals((Object)fixed.number, (Object)generic.get("number"));
            Assert.assertEquals((Object)fixed.quality, (Object)generic.get("quality").toString());
            Assert.assertEquals((Object)fixed.quantity, (Object)generic.get("quantity"));
            Assert.assertEquals((Object)fixed.species, (Object)generic.get("species").toString());
        }
    }

    private byte[] createHaystack(byte[] needle, int position, int size) {
        byte[] haystack = new byte[size];
        int i = position;
        for (int j = 0; i < size && j < needle.length; ++i, ++j) {
            haystack[i] = needle[j];
        }
        return haystack;
    }

    private void testAdvancePastNextSyncMarkerAt(int position, int size) throws IOException {
        int sentinel = -1;
        byte[] marker = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6};
        byte[] haystack = this.createHaystack(marker, position, size);
        PushbackInputStream stream = new PushbackInputStream(new ByteArrayInputStream(haystack), marker.length);
        if (position + marker.length < size) {
            haystack[position + marker.length] = sentinel;
            Assert.assertEquals((long)(position + marker.length), (long)AvroSource.AvroReader.advancePastNextSyncMarker((PushbackInputStream)stream, (byte[])marker));
            Assert.assertEquals((long)sentinel, (long)((byte)stream.read()));
        } else {
            Assert.assertEquals((long)size, (long)AvroSource.AvroReader.advancePastNextSyncMarker((PushbackInputStream)stream, (byte[])marker));
            Assert.assertEquals((long)-1L, (long)stream.read());
        }
    }

    @Test
    public void testAdvancePastNextSyncMarker() throws IOException {
        for (int i = 0; i <= 16; ++i) {
            this.testAdvancePastNextSyncMarkerAt(i, 1000);
            this.testAdvancePastNextSyncMarkerAt(160 + i, 1000);
        }
        this.testAdvancePastNextSyncMarkerAt(983, 1000);
        this.testAdvancePastNextSyncMarkerAt(984, 1000);
        this.testAdvancePastNextSyncMarkerAt(985, 1000);
        this.testAdvancePastNextSyncMarkerAt(999, 1000);
        this.testAdvancePastNextSyncMarkerAt(1000, 1000);
    }

    @Test
    public void testSeekerFind() {
        byte[] marker = new byte[]{0, 1, 2, 3};
        AvroSource.AvroReader.Seeker s = new AvroSource.AvroReader.Seeker(marker);
        byte[] buffer = new byte[]{0, 1, 2, 3, 4, 5, 6, 7};
        Assert.assertEquals((long)3L, (long)s.find(buffer, buffer.length));
        buffer = new byte[]{0, 0, 0, 0, 0, 1, 2, 3};
        Assert.assertEquals((long)7L, (long)s.find(buffer, buffer.length));
        buffer = new byte[]{0, 1, 2, 0, 0, 1, 2, 3};
        Assert.assertEquals((long)7L, (long)s.find(buffer, buffer.length));
        buffer = new byte[]{0, 1, 2, 3};
        Assert.assertEquals((long)3L, (long)s.find(buffer, buffer.length));
    }

    @Test
    public void testSeekerFindResume() {
        byte[] marker = new byte[]{0, 1, 2, 3};
        AvroSource.AvroReader.Seeker s = new AvroSource.AvroReader.Seeker(marker);
        byte[] buffer = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
        Assert.assertEquals((long)-1L, (long)s.find(buffer, buffer.length));
        buffer = new byte[]{1, 2, 3, 0, 0, 0, 0, 0};
        Assert.assertEquals((long)2L, (long)s.find(buffer, buffer.length));
        buffer = new byte[]{0, 0, 0, 0, 0, 0, 1, 2};
        Assert.assertEquals((long)-1L, (long)s.find(buffer, buffer.length));
        buffer = new byte[]{3, 0, 1, 2, 3, 0, 1, 2};
        Assert.assertEquals((long)0L, (long)s.find(buffer, buffer.length));
        buffer = new byte[]{0};
        Assert.assertEquals((long)-1L, (long)s.find(buffer, buffer.length));
        buffer = new byte[]{1};
        Assert.assertEquals((long)-1L, (long)s.find(buffer, buffer.length));
        buffer = new byte[]{2};
        Assert.assertEquals((long)-1L, (long)s.find(buffer, buffer.length));
        buffer = new byte[]{3};
        Assert.assertEquals((long)0L, (long)s.find(buffer, buffer.length));
    }

    @Test
    public void testSeekerUsesBufferLength() {
        byte[] marker = new byte[]{0, 0, 1};
        AvroSource.AvroReader.Seeker s = new AvroSource.AvroReader.Seeker(marker);
        byte[] buffer = new byte[]{0, 0, 0, 1};
        Assert.assertEquals((long)-1L, (long)s.find(buffer, 3));
        s = new AvroSource.AvroReader.Seeker(marker);
        buffer = new byte[]{0, 0};
        Assert.assertEquals((long)-1L, (long)s.find(buffer, 1));
        buffer = new byte[]{1, 0};
        Assert.assertEquals((long)-1L, (long)s.find(buffer, 1));
        s = new AvroSource.AvroReader.Seeker(marker);
        buffer = new byte[]{0, 2};
        Assert.assertEquals((long)-1L, (long)s.find(buffer, 1));
        buffer = new byte[]{0, 2};
        Assert.assertEquals((long)-1L, (long)s.find(buffer, 1));
        buffer = new byte[]{1, 2};
        Assert.assertEquals((long)0L, (long)s.find(buffer, 1));
    }

    @Test
    public void testSeekerFindPartial() {
        byte[] marker = new byte[]{0, 0, 1};
        AvroSource.AvroReader.Seeker s = new AvroSource.AvroReader.Seeker(marker);
        byte[] buffer = new byte[]{0, 0, 0, 1};
        Assert.assertEquals((long)3L, (long)s.find(buffer, buffer.length));
        marker = new byte[]{1, 1, 1, 2};
        s = new AvroSource.AvroReader.Seeker(marker);
        buffer = new byte[]{1, 1, 1, 1, 1};
        Assert.assertEquals((long)-1L, (long)s.find(buffer, buffer.length));
        buffer = new byte[]{1, 1, 2};
        Assert.assertEquals((long)2L, (long)s.find(buffer, buffer.length));
        buffer = new byte[]{1, 1, 1, 1, 1};
        Assert.assertEquals((long)-1L, (long)s.find(buffer, buffer.length));
        buffer = new byte[]{2, 1, 1, 1, 2};
        Assert.assertEquals((long)0L, (long)s.find(buffer, buffer.length));
    }

    @Test
    public void testSeekerFindAllLocations() {
        byte[] marker = new byte[]{1, 1, 2};
        byte[] allOnes = new byte[]{1, 1, 1, 1};
        byte[] findIn = new byte[]{1, 1, 1, 1};
        AvroSource.AvroReader.Seeker s = new AvroSource.AvroReader.Seeker(marker);
        for (int i = 0; i < findIn.length; ++i) {
            Assert.assertEquals((long)-1L, (long)s.find(allOnes, allOnes.length));
            findIn[i] = 2;
            Assert.assertEquals((long)i, (long)s.find(findIn, findIn.length));
            findIn[i] = 1;
        }
    }

    @Test
    public void testDisplayData() {
        AvroSource source = AvroSource.from((String)"foobar.txt").withSchema(Bird.class).withMinBundleSize(1234L);
        DisplayData displayData = DisplayData.from((HasDisplayData)source);
        Assert.assertThat((Object)displayData, DisplayDataMatchers.hasDisplayItem("filePattern", "foobar.txt"));
        Assert.assertThat((Object)displayData, DisplayDataMatchers.hasDisplayItem("minBundleSize", 1234L));
    }

    @Test
    public void testReadMetadataWithCodecs() throws Exception {
        String[] codecs = new String[]{"null", "bzip2", "deflate", "snappy", "xz"};
        List<Bird> expected = AvroSourceTest.createRandomRecords(1000L);
        for (String codec : codecs) {
            String filename = this.generateTestFile(codec, expected, SyncBehavior.SYNC_DEFAULT, 0, AvroCoder.of(Bird.class), codec);
            MatchResult.Metadata fileMeta = FileSystems.matchSingleFileSpec((String)filename);
            AvroSource.AvroMetadata metadata = AvroSource.readMetadataFromFile((ResourceId)fileMeta.resourceId());
            Assert.assertEquals((Object)codec, (Object)metadata.getCodec());
        }
    }

    @Test
    public void testReadSchemaString() throws Exception {
        List<Bird> expected = AvroSourceTest.createRandomRecords(1000L);
        String codec = "null";
        String filename = this.generateTestFile(codec, expected, SyncBehavior.SYNC_DEFAULT, 0, AvroCoder.of(Bird.class), codec);
        MatchResult.Metadata fileMeta = FileSystems.matchSingleFileSpec((String)filename);
        AvroSource.AvroMetadata metadata = AvroSource.readMetadataFromFile((ResourceId)fileMeta.resourceId());
        Schema schema = new Schema.Parser().parse(metadata.getSchemaString());
        Assert.assertEquals((long)4L, (long)schema.getFields().size());
    }

    private static List<FixedRecord> createFixedRecords(int count) {
        ArrayList<FixedRecord> records = new ArrayList<FixedRecord>();
        for (int i = 0; i < count; ++i) {
            records.add(new FixedRecord(i));
        }
        return records;
    }

    private static List<Bird> createRandomRecords(long n) {
        String[] qualities = new String[]{"miserable", "forelorn", "fidgity", "squirrelly", "fanciful", "chipper", "lazy"};
        String[] species = new String[]{"pigeons", "owls", "gulls", "hawks", "robins", "jays"};
        Random random = new Random(0L);
        ArrayList<Bird> records = new ArrayList<Bird>();
        long i = 0L;
        while (i < n) {
            Bird bird = new Bird();
            bird.quality = qualities[random.nextInt(qualities.length)];
            bird.species = species[random.nextInt(species.length)];
            bird.number = i++;
            bird.quantity = random.nextLong();
            records.add(bird);
        }
        return records;
    }

    @DefaultCoder(value=AvroCoder.class)
    public static class FancyBird {
        long number;
        String species;
        String quality;
        long quantity;
        @Nullable
        String habitat;
        @AvroDefault(value="\"MAXIMUM OVERDRIVE\"")
        String fancinessLevel;

        public FancyBird() {
        }

        public FancyBird(long number, String species, String quality, long quantity, String habitat, String fancinessLevel) {
            this.number = number;
            this.species = species;
            this.quality = quality;
            this.quantity = quantity;
            this.habitat = habitat;
            this.fancinessLevel = fancinessLevel;
        }

        public String toString() {
            return MoreObjects.toStringHelper(FancyBird.class).addValue(this.number).addValue(this.species).addValue(this.quality).addValue(this.quantity).addValue(this.habitat).addValue(this.fancinessLevel).toString();
        }

        public boolean equals(Object obj) {
            if (obj instanceof FancyBird) {
                FancyBird other = (FancyBird)obj;
                return Objects.equals(this.species, other.species) && Objects.equals(this.quality, other.quality) && this.quantity == other.quantity && this.number == other.number && Objects.equals(this.fancinessLevel, other.fancinessLevel) && Objects.equals(this.habitat, other.habitat);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.number, this.species, this.quality, this.quantity, this.habitat, this.fancinessLevel);
        }
    }

    @DefaultCoder(value=AvroCoder.class)
    static class Bird {
        long number;
        String species;
        String quality;
        long quantity;

        public Bird() {
        }

        public Bird(long number, String species, String quality, long quantity) {
            this.number = number;
            this.species = species;
            this.quality = quality;
            this.quantity = quantity;
        }

        public String toString() {
            return MoreObjects.toStringHelper(Bird.class).addValue(this.number).addValue(this.species).addValue(this.quantity).addValue(this.quality).toString();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Bird) {
                Bird other = (Bird)obj;
                return Objects.equals(this.species, other.species) && Objects.equals(this.quality, other.quality) && this.quantity == other.quantity && this.number == other.number;
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.number, this.species, this.quality, this.quantity);
        }
    }

    @DefaultCoder(value=AvroCoder.class)
    public static class FixedRecord {
        private byte[] value = new byte[15];

        public FixedRecord() {
            this(0);
        }

        public FixedRecord(int i) {
            this.value[0] = (byte)i;
            this.value[1] = (byte)(i >> 8);
            this.value[2] = (byte)(i >> 16);
            this.value[3] = (byte)(i >> 24);
        }

        public int asInt() {
            return this.value[0] | this.value[1] << 8 | this.value[2] << 16 | this.value[3] << 24;
        }

        public boolean equals(Object o) {
            if (o instanceof FixedRecord) {
                FixedRecord other = (FixedRecord)o;
                return this.asInt() == other.asInt();
            }
            return false;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public String toString() {
            return Integer.toString(this.asInt());
        }
    }

    private static enum SyncBehavior {
        SYNC_REGULAR,
        SYNC_RANDOM,
        SYNC_DEFAULT;

    }
}

