/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders.org.apache.beam.sdk.coders;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.Lists;
import org.apache.beam.sdk.coders.RowCoder;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.values.Row;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.junit.Assert;
import org.junit.Test;

public class RowCoderTest {
    void checkEncodeDecode(Row row) throws IOException {
        RowCoder coder = RowCoder.of((Schema)row.getSchema());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        coder.encode(row, (OutputStream)out);
        Assert.assertEquals((Object)row, (Object)coder.decode((InputStream)new ByteArrayInputStream(out.toByteArray())));
    }

    @Test
    public void testPrimitiveTypes() throws Exception {
        Schema schema = Schema.builder().addByteField("f_byte").addInt16Field("f_int16").addInt32Field("f_int32").addInt64Field("f_int64").addDecimalField("f_decimal").addFloatField("f_float").addDoubleField("f_double").addStringField("f_string").addDateTimeField("f_datetime").addBooleanField("f_boolean").build();
        DateTime dateTime = new DateTime().withDate(1979, 3, 14).withTime(1, 2, 3, 4).withZone(DateTimeZone.UTC);
        Row row = Row.withSchema((Schema)schema).addValues(new Object[]{(byte)0, (short)1, 2, 3L, new BigDecimal(2.3), Float.valueOf(1.2f), 3.0, "str", dateTime, false}).build();
        this.checkEncodeDecode(row);
    }

    @Test
    public void testNestedTypes() throws Exception {
        Schema nestedSchema = Schema.builder().addInt32Field("f1_int").addStringField("f1_str").build();
        Schema schema = Schema.builder().addInt32Field("f_int").addRowField("nested", nestedSchema).build();
        Row nestedRow = Row.withSchema((Schema)nestedSchema).addValues(new Object[]{18, "foobar"}).build();
        Row row = Row.withSchema((Schema)schema).addValues(new Object[]{42, nestedRow}).build();
        this.checkEncodeDecode(row);
    }

    @Test
    public void testArrays() throws Exception {
        Schema schema = Schema.builder().addArrayField("f_array", Schema.FieldType.STRING).build();
        Row row = Row.withSchema((Schema)schema).addArray(new Object[]{"one", "two", "three", "four"}).build();
        this.checkEncodeDecode(row);
    }

    @Test
    public void testArrayOfRow() throws Exception {
        Schema nestedSchema = Schema.builder().addInt32Field("f1_int").addStringField("f1_str").build();
        Schema.FieldType collectionElementType = Schema.FieldType.row((Schema)nestedSchema);
        Schema schema = Schema.builder().addArrayField("f_array", collectionElementType).build();
        Row row = Row.withSchema((Schema)schema).addArray(new Object[]{Row.withSchema((Schema)nestedSchema).addValues(new Object[]{1, "one"}).build(), Row.withSchema((Schema)nestedSchema).addValues(new Object[]{2, "two"}).build(), Row.withSchema((Schema)nestedSchema).addValues(new Object[]{3, "three"}).build()}).build();
        this.checkEncodeDecode(row);
    }

    @Test
    public void testArrayOfArray() throws Exception {
        Schema.FieldType arrayType = Schema.FieldType.array((Schema.FieldType)Schema.FieldType.array((Schema.FieldType)Schema.FieldType.INT32));
        Schema schema = Schema.builder().addField("f_array", arrayType).build();
        Row row = Row.withSchema((Schema)schema).addArray(new Object[]{Lists.newArrayList(1, 2, 3, 4), Lists.newArrayList(5, 6, 7, 8), Lists.newArrayList(9, 10, 11, 12)}).build();
        this.checkEncodeDecode(row);
    }
}

