/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.ImmutableList;
import org.apache.beam.sdk.coders.BigDecimalCoder;
import org.apache.beam.sdk.coders.BigIntegerCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.testing.CoderProperties;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class StructuredCoderTest {
    @Test
    public void testStructuralValue() throws Exception {
        List<Boolean> testBooleans = Arrays.asList(null, true, false);
        List<ObjectIdentityBoolean> testInconsistentBooleans = Arrays.asList(null, new ObjectIdentityBoolean(true), new ObjectIdentityBoolean(false));
        NullBooleanCoder consistentCoder = new NullBooleanCoder();
        for (Boolean value1 : testBooleans) {
            for (Boolean value2 : testBooleans) {
                CoderProperties.structuralValueConsistentWithEquals((Coder)consistentCoder, (Object)value1, (Object)value2);
            }
        }
        ObjectIdentityBooleanCoder inconsistentCoder = new ObjectIdentityBooleanCoder();
        for (ObjectIdentityBoolean value1 : testInconsistentBooleans) {
            for (ObjectIdentityBoolean value2 : testInconsistentBooleans) {
                CoderProperties.structuralValueConsistentWithEquals((Coder)inconsistentCoder, (Object)value1, (Object)value2);
            }
        }
    }

    @Test
    public void testToString() {
        Assert.assertThat((Object)new ObjectIdentityBooleanCoder().toString(), (Matcher)CoreMatchers.equalTo((Object)"StructuredCoderTest$ObjectIdentityBooleanCoder"));
        ObjectIdentityBooleanCoder coderWithArgs = new ObjectIdentityBooleanCoder(){

            @Override
            public List<? extends Coder<?>> getCoderArguments() {
                return ((ImmutableList.Builder)ImmutableList.builder().add(new Coder[]{BigDecimalCoder.of(), BigIntegerCoder.of()})).build();
            }
        };
        Assert.assertThat((Object)coderWithArgs.toString(), (Matcher)CoreMatchers.equalTo((Object)"StructuredCoderTest$1(BigDecimalCoder,BigIntegerCoder)"));
    }

    @Test
    public void testGenericStandardCoderFallsBackToT() throws Exception {
        Assert.assertThat((Object)new Foo().getEncodedTypeDescriptor().getType(), (Matcher)CoreMatchers.not((Object)TypeDescriptor.of(String.class).getType()));
    }

    @Test
    public void testGenericStandardCoder() throws Exception {
        Assert.assertThat((Object)new FooTwo().getEncodedTypeDescriptor(), (Matcher)CoreMatchers.equalTo((Object)TypeDescriptor.of(String.class)));
    }

    private static class FooTwo
    extends Foo<String> {
        private FooTwo() {
        }
    }

    private static class Foo<T>
    extends StructuredCoder<T> {
        private Foo() {
        }

        public void encode(T value, OutputStream outStream) throws CoderException, IOException {
            throw new UnsupportedOperationException();
        }

        public T decode(InputStream inStream) throws CoderException, IOException {
            throw new UnsupportedOperationException();
        }

        public List<? extends Coder<?>> getCoderArguments() {
            throw new UnsupportedOperationException();
        }

        public void verifyDeterministic() throws Coder.NonDeterministicException {
        }
    }

    private static class ObjectIdentityBooleanCoder
    extends StructuredCoder<ObjectIdentityBoolean> {
        private static final long serialVersionUID = 0L;

        private ObjectIdentityBooleanCoder() {
        }

        public void encode(@Nullable ObjectIdentityBoolean value, OutputStream outStream) throws CoderException, IOException {
            if (value == null) {
                outStream.write(2);
            } else if (value.getValue()) {
                outStream.write(1);
            } else {
                outStream.write(0);
            }
        }

        @Nullable
        public ObjectIdentityBoolean decode(InputStream inStream) throws CoderException, IOException {
            int value = inStream.read();
            if (value == 0) {
                return new ObjectIdentityBoolean(false);
            }
            if (value == 1) {
                return new ObjectIdentityBoolean(true);
            }
            if (value == 2) {
                return null;
            }
            throw new CoderException("Invalid value for nullable Boolean: " + value);
        }

        public List<? extends Coder<?>> getCoderArguments() {
            return Collections.emptyList();
        }

        public void verifyDeterministic() throws Coder.NonDeterministicException {
        }

        public boolean consistentWithEquals() {
            return false;
        }
    }

    private static class ObjectIdentityBoolean {
        private final boolean value;

        public ObjectIdentityBoolean(boolean value) {
            this.value = value;
        }

        public boolean getValue() {
            return this.value;
        }
    }

    private static class NullBooleanCoder
    extends StructuredCoder<Boolean> {
        private static final long serialVersionUID = 0L;

        private NullBooleanCoder() {
        }

        public void encode(@Nullable Boolean value, OutputStream outStream) throws CoderException, IOException {
            if (value == null) {
                outStream.write(2);
            } else if (value.booleanValue()) {
                outStream.write(1);
            } else {
                outStream.write(0);
            }
        }

        @Nullable
        public Boolean decode(InputStream inStream) throws CoderException, IOException {
            int value = inStream.read();
            if (value == 0) {
                return false;
            }
            if (value == 1) {
                return true;
            }
            if (value == 2) {
                return null;
            }
            throw new CoderException("Invalid value for nullable Boolean: " + value);
        }

        public List<? extends Coder<?>> getCoderArguments() {
            return Collections.emptyList();
        }

        public void verifyDeterministic() throws Coder.NonDeterministicException {
        }

        public boolean consistentWithEquals() {
            return true;
        }
    }
}

