/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StringDelegateCoder;
import org.apache.beam.sdk.testing.CoderProperties;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class StringDelegateCoderTest {
    private static final Coder<URI> uriCoder = StringDelegateCoder.of(URI.class);
    private static final List<String> TEST_URI_STRINGS = Arrays.asList("http://www.example.com", "gs://myproject/mybucket/some/gcs/path", "/just/some/path", "file:/path/with/no/authority", "file:///path/with/empty/authority");

    @Test
    public void testDeterministic() throws Exception, Coder.NonDeterministicException {
        uriCoder.verifyDeterministic();
        for (String uriString : TEST_URI_STRINGS) {
            CoderProperties.coderDeterministic(uriCoder, (Object)new URI(uriString), (Object)new URI(uriString));
        }
    }

    @Test
    public void testDecodeEncodeEqual() throws Exception {
        for (String uriString : TEST_URI_STRINGS) {
            CoderProperties.coderDecodeEncodeEqual(uriCoder, (Object)new URI(uriString));
        }
    }

    @Test
    public void testSerializable() throws Exception {
        CoderProperties.coderSerializable(uriCoder);
    }

    @Test
    public void testEncodedTypeDescriptor() throws Exception {
        Assert.assertThat((Object)StringDelegateCoder.of(URI.class).getEncodedTypeDescriptor(), (Matcher)Matchers.equalTo((Object)TypeDescriptor.of(URI.class)));
    }
}

