/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.SetCoder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.testing.CoderProperties;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class SetCoderTest {
    private static final Coder<Set<Integer>> TEST_CODER = SetCoder.of((Coder)VarIntCoder.of());
    private static final List<Set<Integer>> TEST_VALUES = Arrays.asList(Collections.emptySet(), Collections.singleton(13), new TreeSet<Integer>(Arrays.asList(31, -5, 83)));
    private static final List<String> TEST_ENCODINGS = Arrays.asList("AAAAAA", "AAAAAQ0", "AAAAA_v___8PH1M");
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testCoderIsSerializableWithWellKnownCoderType() throws Exception {
        CoderProperties.coderSerializable((Coder)SetCoder.of((Coder)GlobalWindow.Coder.INSTANCE));
    }

    @Test
    public void testDecodeEncodeContentsEqual() throws Exception {
        for (Set<Integer> value : TEST_VALUES) {
            CoderProperties.coderDecodeEncodeContentsEqual(TEST_CODER, value);
        }
    }

    @Test
    public void testWireFormatEncode() throws Exception {
        CoderProperties.coderEncodesBase64(TEST_CODER, TEST_VALUES, TEST_ENCODINGS);
    }

    @Test
    public void encodeNullThrowsCoderException() throws Exception {
        this.thrown.expect(CoderException.class);
        this.thrown.expectMessage("cannot encode a null Set");
        CoderUtils.encodeToBase64(TEST_CODER, null);
    }

    @Test
    public void testEncodedTypeDescriptor() throws Exception {
        TypeDescriptor<Set<Integer>> typeDescriptor = new TypeDescriptor<Set<Integer>>(){};
        Assert.assertThat((Object)TEST_CODER.getEncodedTypeDescriptor(), (Matcher)Matchers.equalTo((Object)typeDescriptor));
    }
}

