/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.coders.DefaultCoder;
import org.apache.beam.sdk.coders.IterableCoder;
import org.apache.beam.sdk.coders.SerializableCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.testing.CoderProperties;
import org.apache.beam.sdk.testing.ExpectedLogs;
import org.apache.beam.sdk.testing.NeedsRunner;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class SerializableCoderTest
implements Serializable {
    @Rule
    public ExpectedLogs expectedLogs = ExpectedLogs.none(SerializableCoder.class);
    static final List<String> LINES = Arrays.asList("To be,", "or not to be");
    @Rule
    public TestPipeline p = TestPipeline.create().enableAbandonedNodeEnforcement(false);

    @Test
    public void testSerializableCoder() throws Exception {
        IterableCoder coder = IterableCoder.of((Coder)SerializableCoder.of(MyRecord.class));
        ArrayList<MyRecord> records = new ArrayList<MyRecord>();
        for (String l : LINES) {
            records.add(new MyRecord(l));
        }
        byte[] encoded = CoderUtils.encodeToByteArray((Coder)coder, records);
        Iterable decoded = (Iterable)CoderUtils.decodeFromByteArray((Coder)coder, (byte[])encoded);
        Assert.assertEquals(records, (Object)decoded);
    }

    @Test
    public void testSerializableCoderConstruction() throws Exception {
        SerializableCoder coder = SerializableCoder.of(MyRecord.class);
        Assert.assertEquals((Object)coder.getRecordType(), MyRecord.class);
        CoderProperties.coderSerializable((Coder)coder);
        SerializableCoder decoded = (SerializableCoder)SerializableUtils.clone((Serializable)coder);
        Assert.assertThat((Object)decoded.getRecordType(), (Matcher)Matchers.equalTo(MyRecord.class));
    }

    @Test
    public <T extends Serializable> void testSerializableCoderIsSerializableWithGenericTypeToken() throws Exception {
        SerializableCoder coder = SerializableCoder.of((TypeDescriptor)new TypeDescriptor<T>(){});
        CoderProperties.coderSerializable((Coder)coder);
    }

    @Test
    public void testNullEquals() {
        SerializableCoder coder = SerializableCoder.of(MyRecord.class);
        Assert.assertFalse((boolean)coder.equals(null));
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testDefaultCoder() throws Exception {
        this.p.enableAbandonedNodeEnforcement(true);
        PCollection output = (PCollection)((PCollection)((PCollection)this.p.apply((PTransform)Create.of((Object)"Hello", (Object[])new String[]{"World"}))).apply((PTransform)ParDo.of((DoFn)new StringToRecord()))).apply((PTransform)ParDo.of((DoFn)new RecordToString()));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new String[]{"Hello", "World"});
        this.p.run();
    }

    @Test
    public void testLongStringEncoding() throws Exception {
        byte[] nestedEncoding;
        StringUtf8Coder coder = StringUtf8Coder.of();
        char[] chars = new char[102400];
        Arrays.fill(chars, 'o');
        String source = new String(chars);
        Assert.assertEquals((Object)source, (Object)CoderUtils.decodeFromByteArray((Coder)coder, (byte[])CoderUtils.encodeToByteArray((Coder)coder, (Object)source)));
        int[] codePoints = new int[20480];
        Arrays.fill(codePoints, 120074);
        String source2 = new String(codePoints, 0, codePoints.length);
        Assert.assertEquals((Object)source2, (Object)CoderUtils.decodeFromByteArray((Coder)coder, (byte[])CoderUtils.encodeToByteArray((Coder)coder, (Object)source2)));
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            coder.encode(source, (OutputStream)os);
            coder.encode(source2, (OutputStream)os);
            nestedEncoding = os.toByteArray();
        }
        var8_7 = null;
        try (ByteArrayInputStream is = new ByteArrayInputStream(nestedEncoding);){
            Assert.assertEquals((Object)source, (Object)coder.decode((InputStream)is));
            Assert.assertEquals((Object)source2, (Object)coder.decode((InputStream)is));
            Assert.assertEquals((long)0L, (long)is.available());
        }
        catch (Throwable throwable) {
            var8_7 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testNullEncoding() throws Exception {
        SerializableCoder coder = SerializableCoder.of(String.class);
        byte[] encodedBytes = CoderUtils.encodeToByteArray((Coder)coder, null);
        Assert.assertNull((Object)CoderUtils.decodeFromByteArray((Coder)coder, (byte[])encodedBytes));
    }

    @Test
    public void testMixedWithNullsEncoding() throws Exception {
        byte[] encodedBytes;
        SerializableCoder coder = SerializableCoder.of(String.class);
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            coder.encode(null, (OutputStream)os);
            coder.encode((Object)"TestValue", (OutputStream)os);
            coder.encode(null, (OutputStream)os);
            coder.encode((Object)"TestValue2", (OutputStream)os);
            coder.encode(null, (OutputStream)os);
            encodedBytes = os.toByteArray();
        }
        var4_3 = null;
        try (ByteArrayInputStream is = new ByteArrayInputStream(encodedBytes);){
            Assert.assertNull((Object)coder.decode((InputStream)is));
            Assert.assertEquals((Object)"TestValue", (Object)coder.decode((InputStream)is));
            Assert.assertNull((Object)coder.decode((InputStream)is));
            Assert.assertEquals((Object)"TestValue2", (Object)coder.decode((InputStream)is));
            Assert.assertNull((Object)coder.decode((InputStream)is));
            Assert.assertEquals((long)0L, (long)is.available());
        }
        catch (Throwable throwable) {
            var4_3 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testEncodedTypeDescriptor() throws Exception {
        Assert.assertThat((Object)SerializableCoder.of(MyRecord.class).getEncodedTypeDescriptor(), (Matcher)Matchers.equalTo((Object)TypeDescriptor.of(MyRecord.class)));
    }

    @Test
    public void testSerializableCoderProviderIsRegistered() throws Exception {
        Assert.assertThat((Object)CoderRegistry.createDefault().getCoder(AutoRegistration.class), (Matcher)Matchers.instanceOf(SerializableCoder.class));
    }

    @Test
    public void coderWarnsForInterface() throws Exception {
        SerializableCoder.of(TestInterface.class);
        this.expectedLogs.verifyWarn("Can't verify serialized elements of type TestInterface have well defined equals method.");
    }

    @Test
    public void coderWarnsForNoEquals() throws Exception {
        SerializableCoder.of(NoEquals.class);
        this.expectedLogs.verifyWarn("Can't verify serialized elements of type NoEquals have well defined equals method.");
    }

    @Test
    public void coderChecksForEquals() throws Exception {
        SerializableCoder.of(ProperEquals.class);
        this.expectedLogs.verifyNotLogged("Can't verify serialized elements of type");
    }

    @Test(expected=IOException.class)
    public void coderDoesNotWrapIoException() throws Exception {
        SerializableCoder coder = SerializableCoder.of(String.class);
        OutputStream outputStream = (OutputStream)Mockito.mock(OutputStream.class, invocationOnMock -> {
            throw new IOException();
        });
        coder.encode((Serializable)((Object)""), outputStream);
    }

    private static class ProperEquals
    implements Serializable {
        private int x;

        private ProperEquals() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProperEquals that = (ProperEquals)o;
            return this.x == that.x;
        }

        public int hashCode() {
            return this.x;
        }
    }

    private static class NoEquals
    implements Serializable {
        private NoEquals() {
        }
    }

    private static interface TestInterface
    extends Serializable {
    }

    private static class AutoRegistration
    implements Serializable {
        private static final long serialVersionUID = 42L;

        private AutoRegistration() {
        }
    }

    static class RecordToString
    extends DoFn<MyRecord, String> {
        RecordToString() {
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) {
            c.output((Object)((MyRecord)c.element()).value);
        }
    }

    static class StringToRecord
    extends DoFn<String, MyRecord> {
        StringToRecord() {
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) {
            c.output((Object)new MyRecord((String)c.element()));
        }
    }

    @DefaultCoder(value=SerializableCoder.class)
    static class MyRecord
    implements Serializable {
        private static final long serialVersionUID = 42L;
        public String value;

        public MyRecord(String value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MyRecord myRecord = (MyRecord)o;
            return this.value.equals(myRecord.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

