/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.base.Joiner;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.Lists;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.util.CoderUtils;

public class PrintBase64Encodings {
    private static Field getField(Class<?> clazz, String fieldName) throws Exception {
        for (Field field : clazz.getDeclaredFields()) {
            if (!field.getName().equals(fieldName)) continue;
            if (!Modifier.isPublic(field.getModifiers())) {
                field.setAccessible(true);
            }
            return field;
        }
        throw new NoSuchFieldException(clazz.getCanonicalName() + "." + fieldName);
    }

    private static Object getFullyQualifiedValue(String fullyQualifiedName) throws Exception {
        int lastDot = fullyQualifiedName.lastIndexOf(".");
        String className = fullyQualifiedName.substring(0, lastDot);
        String fieldName = fullyQualifiedName.substring(lastDot + 1);
        Class<?> clazz = Class.forName(className);
        Field field = PrintBase64Encodings.getField(clazz, fieldName);
        return field.get(null);
    }

    public static void main(String[] argv) throws Exception {
        Coder testCoder = (Coder)PrintBase64Encodings.getFullyQualifiedValue(argv[0]);
        List testValues = (List)PrintBase64Encodings.getFullyQualifiedValue(argv[1]);
        ArrayList<String> base64Encodings = Lists.newArrayList();
        for (Object value : testValues) {
            base64Encodings.add(CoderUtils.encodeToBase64((Coder)testCoder, value));
        }
        System.out.println(String.format("\"%s\"", Joiner.on("\",\n\"").join(base64Encodings)));
    }
}

