/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.base.Preconditions;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.ImmutableList;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.DoubleCoder;
import org.apache.beam.sdk.coders.ListCoder;
import org.apache.beam.sdk.coders.NullableCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.testing.CoderProperties;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class NullableCoderTest {
    private static final Coder<String> TEST_CODER = NullableCoder.of((Coder)StringUtf8Coder.of());
    private static final List<String> TEST_VALUES = Arrays.asList("", "a", "13", "hello", null, "a longer string with spaces and all that", "a string with a \n newline", "\u30b9\u30bf\u30ea\u30f3\u30b0");
    private static final List<String> TEST_ENCODINGS = Arrays.asList("AQ", "AWE", "ATEz", "AWhlbGxv", "AA", "AWEgbG9uZ2VyIHN0cmluZyB3aXRoIHNwYWNlcyBhbmQgYWxsIHRoYXQ", "AWEgc3RyaW5nIHdpdGggYSAKIG5ld2xpbmU", "AeOCueOCv-ODquODs-OCsA");
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testDecodeEncodeContentsInSameOrder() throws Exception {
        for (String value : TEST_VALUES) {
            CoderProperties.coderDecodeEncodeEqual(TEST_CODER, (Object)value);
        }
    }

    @Test
    public void testCoderSerializable() throws Exception {
        CoderProperties.coderSerializable(TEST_CODER);
    }

    @Test
    public void testCoderIsSerializableWithWellKnownCoderType() throws Exception {
        CoderProperties.coderSerializable((Coder)NullableCoder.of((Coder)GlobalWindow.Coder.INSTANCE));
    }

    @Test
    public void testWireFormatEncode() throws Exception {
        CoderProperties.coderEncodesBase64(TEST_CODER, TEST_VALUES, TEST_ENCODINGS);
    }

    @Test
    public void testEncodedSize() throws Exception {
        NullableCoder coder = NullableCoder.of((Coder)DoubleCoder.of());
        Assert.assertEquals((long)1L, (long)coder.getEncodedElementByteSize(null));
        Assert.assertEquals((long)9L, (long)coder.getEncodedElementByteSize((Object)5.0));
    }

    @Test
    public void testEncodedSizeNested() throws Exception {
        NullableCoder varLenCoder = NullableCoder.of((Coder)StringUtf8Coder.of());
        Assert.assertEquals((long)1L, (long)varLenCoder.getEncodedElementByteSize(null));
        Assert.assertEquals((long)6L, (long)varLenCoder.getEncodedElementByteSize((Object)"spam"));
    }

    @Test
    public void testObserverIsCheap() throws Exception {
        NullableCoder coder = NullableCoder.of((Coder)DoubleCoder.of());
        Assert.assertTrue((boolean)coder.isRegisterByteSizeObserverCheap((Object)5.0));
    }

    @Test
    public void testObserverIsNotCheap() throws Exception {
        NullableCoder coder = NullableCoder.of((Coder)ListCoder.of((Coder)StringUtf8Coder.of()));
        Assert.assertFalse((boolean)coder.isRegisterByteSizeObserverCheap(ImmutableList.of("hi", "test")));
    }

    @Test
    public void testObserverIsAlwaysCheapForNullValues() throws Exception {
        NullableCoder coder = NullableCoder.of((Coder)ListCoder.of((Coder)StringUtf8Coder.of()));
        Assert.assertTrue((boolean)coder.isRegisterByteSizeObserverCheap(null));
    }

    @Test
    public void testStructuralValueConsistentWithEquals() throws Exception {
        CoderProperties.structuralValueConsistentWithEquals(TEST_CODER, null, null);
    }

    @Test
    public void testDecodingError() throws Exception {
        this.thrown.expect(CoderException.class);
        this.thrown.expectMessage(Matchers.equalTo((Object)"NullableCoder expects either a byte valued 0 (null) or 1 (present), got 5"));
        ByteArrayInputStream input = new ByteArrayInputStream(new byte[]{5});
        TEST_CODER.decode((InputStream)input, Coder.Context.OUTER);
    }

    @Test
    public void testSubcoderRecievesEntireStream() throws Exception {
        NullableCoder coder = NullableCoder.of((Coder)new EntireStreamExpectingCoder());
        CoderProperties.coderDecodeEncodeEqualInContext((Coder)coder, (Coder.Context)Coder.Context.OUTER, null);
        CoderProperties.coderDecodeEncodeEqualInContext((Coder)coder, (Coder.Context)Coder.Context.OUTER, (Object)"foo");
    }

    @Test
    public void testNestedNullableCoder() {
        NullableCoder coder = NullableCoder.of((Coder)DoubleCoder.of());
        Assert.assertThat((Object)NullableCoder.of((Coder)coder), (Matcher)Matchers.theInstance((Object)coder));
    }

    @Test
    public void testEncodedTypeDescriptor() throws Exception {
        Assert.assertThat((Object)TEST_CODER.getEncodedTypeDescriptor(), (Matcher)Matchers.equalTo((Object)TypeDescriptor.of(String.class)));
    }

    private static class EntireStreamExpectingCoder
    extends AtomicCoder<String> {
        private EntireStreamExpectingCoder() {
        }

        public void encode(String value, OutputStream outStream) throws IOException {
            this.encode(value, outStream, Coder.Context.NESTED);
        }

        public void encode(String value, OutputStream outStream, Coder.Context context) throws IOException {
            Preconditions.checkArgument(context.isWholeStream, "Expected to get entire stream");
            StringUtf8Coder.of().encode(value, outStream, context);
        }

        public String decode(InputStream inStream) throws CoderException, IOException {
            return this.decode(inStream, Coder.Context.NESTED);
        }

        public String decode(InputStream inStream, Coder.Context context) throws CoderException, IOException {
            Preconditions.checkArgument(context.isWholeStream, "Expected to get entire stream");
            return StringUtf8Coder.of().decode(inStream, context);
        }

        public List<? extends Coder<?>> getCoderArguments() {
            return Collections.emptyList();
        }

        public void verifyDeterministic() throws Coder.NonDeterministicException {
        }
    }
}

