/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.ImmutableMap;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.MapCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.testing.CoderProperties;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class MapCoderTest {
    private static final Coder<Map<Integer, String>> TEST_CODER = MapCoder.of((Coder)VarIntCoder.of(), (Coder)StringUtf8Coder.of());
    private static final List<Map<Integer, String>> TEST_VALUES = Arrays.asList(Collections.emptyMap(), new TreeMap<Integer, String>(new ImmutableMap.Builder<Integer, String>().put(1, "hello").put(-1, "foo").build()));
    private static final List<String> TEST_ENCODINGS = Arrays.asList("AAAAAA", "AAAAAv____8PA2ZvbwFoZWxsbw");
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testDecodeEncodeContentsInSameOrder() throws Exception {
        for (Map<Integer, String> value : TEST_VALUES) {
            CoderProperties.coderDecodeEncodeEqual(TEST_CODER, value);
        }
    }

    @Test
    public void testCoderIsSerializableWithWellKnownCoderType() throws Exception {
        CoderProperties.coderSerializable((Coder)MapCoder.of((Coder)GlobalWindow.Coder.INSTANCE, (Coder)GlobalWindow.Coder.INSTANCE));
    }

    @Test
    public void testWireFormatEncode() throws Exception {
        CoderProperties.coderEncodesBase64(TEST_CODER, TEST_VALUES, TEST_ENCODINGS);
    }

    @Test
    public void encodeNullThrowsCoderException() throws Exception {
        this.thrown.expect(CoderException.class);
        this.thrown.expectMessage("cannot encode a null Map");
        CoderUtils.encodeToBase64(TEST_CODER, null);
    }

    @Test
    public void testEncodedTypeDescriptor() throws Exception {
        TypeDescriptor<Map<Integer, String>> typeDescriptor = new TypeDescriptor<Map<Integer, String>>(){};
        Assert.assertThat((Object)TEST_CODER.getEncodedTypeDescriptor(), (Matcher)Matchers.equalTo((Object)typeDescriptor));
    }
}

