/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.ListCoder;
import org.apache.beam.sdk.coders.SerializableCoder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.testing.CoderProperties;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ListCoderTest {
    private static final Coder<List<Integer>> TEST_CODER = ListCoder.of((Coder)VarIntCoder.of());
    private static final List<List<Integer>> TEST_VALUES = Arrays.asList(Collections.emptyList(), Collections.singletonList(43), Arrays.asList(1, 2, 3, 4), new ArrayList<Integer>(Arrays.asList(7, 6, 5)));
    private static final List<String> TEST_ENCODINGS = Arrays.asList("AAAAAA", "AAAAASs", "AAAABAECAwQ", "AAAAAwcGBQ");
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testCoderIsSerializableWithWellKnownCoderType() throws Exception {
        CoderProperties.coderSerializable((Coder)ListCoder.of((Coder)GlobalWindow.Coder.INSTANCE));
    }

    @Test
    public void testDecodeEncodeContentsInSameOrder() throws Exception {
        for (List<Integer> value : TEST_VALUES) {
            CoderProperties.coderDecodeEncodeContentsInSameOrder(TEST_CODER, value);
        }
    }

    @Test
    public void testEmptyList() throws Exception {
        List list = Collections.emptyList();
        ListCoder coder = ListCoder.of((Coder)VarIntCoder.of());
        CoderProperties.coderDecodeEncodeEqual((Coder)coder, list);
    }

    @Test
    public void testCoderSerializable() throws Exception {
        CoderProperties.coderSerializable(TEST_CODER);
    }

    @Test
    public void testWireFormatEncode() throws Exception {
        CoderProperties.coderEncodesBase64(TEST_CODER, TEST_VALUES, TEST_ENCODINGS);
    }

    @Test
    public void encodeNullThrowsCoderException() throws Exception {
        this.thrown.expect(CoderException.class);
        this.thrown.expectMessage("cannot encode a null List");
        CoderUtils.encodeToBase64(TEST_CODER, null);
    }

    @Test
    public void testListWithNullsAndVarIntCoderThrowsException() throws Exception {
        this.thrown.expect(CoderException.class);
        this.thrown.expectMessage("cannot encode a null Integer");
        List<Integer> list = Arrays.asList(1, 2, 3, null, 4);
        ListCoder coder = ListCoder.of((Coder)VarIntCoder.of());
        CoderProperties.coderDecodeEncodeEqual((Coder)coder, list);
    }

    @Test
    public void testListWithNullsAndSerializableCoder() throws Exception {
        List<Integer> list = Arrays.asList(1, 2, 3, null, 4);
        ListCoder coder = ListCoder.of((Coder)SerializableCoder.of(Integer.class));
        CoderProperties.coderDecodeEncodeEqual((Coder)coder, list);
    }

    @Test
    public void testEncodedTypeDescriptor() throws Exception {
        TypeDescriptor<List<Integer>> typeDescriptor = new TypeDescriptor<List<Integer>>(){};
        Assert.assertThat((Object)TEST_CODER.getEncodedTypeDescriptor(), (Matcher)Matchers.equalTo((Object)typeDescriptor));
    }
}

