/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.util.Arrays;
import java.util.List;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.ImmutableList;
import org.apache.beam.sdk.coders.BigEndianLongCoder;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.DoubleCoder;
import org.apache.beam.sdk.coders.LengthPrefixCoder;
import org.apache.beam.sdk.coders.ListCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.testing.CoderProperties;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.util.CoderUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class LengthPrefixCoderTest {
    private static final StructuredCoder<byte[]> TEST_CODER = LengthPrefixCoder.of((Coder)ByteArrayCoder.of());
    private static final List<byte[]> TEST_VALUES = Arrays.asList({10, 11, 12}, {13, 3}, {13, 14}, new byte[0]);
    private static final ImmutableList<String> TEST_ENCODINGS = ImmutableList.of("AwoLDA", "Ag0D", "Ag0O", "AA");

    @Test
    public void testCoderSerializable() throws Exception {
        CoderProperties.coderSerializable(TEST_CODER);
    }

    @Test
    public void testCoderIsSerializableWithWellKnownCoderType() throws Exception {
        CoderProperties.coderSerializable((Coder)LengthPrefixCoder.of((Coder)GlobalWindow.Coder.INSTANCE));
    }

    @Test
    public void testEncodedSize() throws Exception {
        Assert.assertEquals((long)5L, (long)TEST_CODER.getEncodedElementByteSize((Object)TEST_VALUES.get(0)));
    }

    @Test
    public void testObserverIsCheap() throws Exception {
        LengthPrefixCoder coder = LengthPrefixCoder.of((Coder)DoubleCoder.of());
        Assert.assertTrue((boolean)coder.isRegisterByteSizeObserverCheap((Object)5.0));
    }

    @Test
    public void testObserverIsNotCheap() throws Exception {
        LengthPrefixCoder coder = LengthPrefixCoder.of((Coder)ListCoder.of((Coder)StringUtf8Coder.of()));
        Assert.assertFalse((boolean)coder.isRegisterByteSizeObserverCheap(ImmutableList.of("hi", "test")));
    }

    @Test
    public void testDecodeEncodeEquals() throws Exception {
        for (byte[] value : TEST_VALUES) {
            CoderProperties.coderDecodeEncodeEqual(TEST_CODER, (Object)value);
        }
    }

    @Test
    public void testRegisterByteSizeObserver() throws Exception {
        CoderProperties.testByteCount((Coder)LengthPrefixCoder.of((Coder)VarIntCoder.of()), (Coder.Context)Coder.Context.NESTED, (Object[])new Integer[]{0, 10, 1000});
    }

    @Test
    public void testStructuralValueConsistentWithEquals() throws Exception {
        for (byte[] value1 : TEST_VALUES) {
            for (byte[] value2 : TEST_VALUES) {
                CoderProperties.structuralValueConsistentWithEquals(TEST_CODER, (Object)value1, (Object)value2);
            }
        }
    }

    @Test
    public void testWireFormatEncode() throws Exception {
        CoderProperties.coderEncodesBase64(TEST_CODER, TEST_VALUES, TEST_ENCODINGS);
    }

    @Test
    public void testMultiCoderCycle() throws Exception {
        LengthPrefixCoder lengthPrefixedValueCoder = LengthPrefixCoder.of((Coder)BigEndianLongCoder.of());
        LengthPrefixCoder lengthPrefixedBytesCoder = LengthPrefixCoder.of((Coder)ByteArrayCoder.of());
        byte[] userEncoded = CoderUtils.encodeToByteArray((Coder)lengthPrefixedValueCoder, (Object)22L);
        byte[] decodedToBytes = (byte[])CoderUtils.decodeFromByteArray((Coder)lengthPrefixedBytesCoder, (byte[])userEncoded);
        byte[] reencodedBytes = CoderUtils.encodeToByteArray((Coder)lengthPrefixedBytesCoder, (Object)decodedToBytes);
        long userDecoded = (Long)CoderUtils.decodeFromByteArray((Coder)lengthPrefixedValueCoder, (byte[])reencodedBytes);
        Assert.assertFalse((String)"Length-prefix decoding to bytes should drop the length", (boolean)Arrays.equals(userEncoded, decodedToBytes));
        Assert.assertArrayEquals((byte[])userEncoded, (byte[])reencodedBytes);
        Assert.assertEquals((long)22L, (long)userDecoded);
    }
}

