/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.beam.sdk.coders.BigEndianLongCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.ListCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.coders.VarLongCoder;
import org.apache.beam.sdk.testing.CoderProperties;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class KvCoderTest {
    private static final List<AnyCoderAndData> TEST_DATA = Arrays.asList(KvCoderTest.coderAndData(VarIntCoder.of(), Arrays.asList(-1, 0, 1, 13, Integer.MAX_VALUE, Integer.MIN_VALUE)), KvCoderTest.coderAndData(BigEndianLongCoder.of(), Arrays.asList(-1L, 0L, 1L, 13L, Long.MAX_VALUE, Long.MIN_VALUE)), KvCoderTest.coderAndData(StringUtf8Coder.of(), Arrays.asList("", "hello", "goodbye", "1")), KvCoderTest.coderAndData(KvCoder.of((Coder)StringUtf8Coder.of(), (Coder)VarIntCoder.of()), Arrays.asList(KV.of((Object)"", (Object)-1), KV.of((Object)"hello", (Object)0), KV.of((Object)"goodbye", (Object)Integer.MAX_VALUE))), KvCoderTest.coderAndData(ListCoder.of((Coder)VarLongCoder.of()), Arrays.asList(Arrays.asList(1L, 2L, 3L), Collections.emptyList())));
    private static final Coder<KV<String, Integer>> TEST_CODER = KvCoder.of((Coder)StringUtf8Coder.of(), (Coder)VarIntCoder.of());
    private static final List<KV<String, Integer>> TEST_VALUES = Arrays.asList(KV.of((Object)"", (Object)-1), KV.of((Object)"hello", (Object)0), KV.of((Object)"goodbye", (Object)Integer.MAX_VALUE));
    private static final List<String> TEST_ENCODINGS = Arrays.asList("AP____8P", "BWhlbGxvAA", "B2dvb2RieWX_____Bw");
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    private static <T> AnyCoderAndData coderAndData(Coder<T> coder, List<T> data) {
        CoderAndData coderAndData = new CoderAndData();
        coderAndData.coder = coder;
        coderAndData.data = data;
        AnyCoderAndData res = new AnyCoderAndData();
        res.coderAndData = coderAndData;
        return res;
    }

    @Test
    public void testDecodeEncodeEqual() throws Exception {
        for (AnyCoderAndData keyCoderAndData : TEST_DATA) {
            Coder keyCoder = ((AnyCoderAndData)keyCoderAndData).coderAndData.coder;
            for (Object key : ((AnyCoderAndData)keyCoderAndData).coderAndData.data) {
                for (AnyCoderAndData valueCoderAndData : TEST_DATA) {
                    Coder valueCoder = ((AnyCoderAndData)valueCoderAndData).coderAndData.coder;
                    for (Object value : ((AnyCoderAndData)valueCoderAndData).coderAndData.data) {
                        CoderProperties.coderDecodeEncodeEqual((Coder)KvCoder.of(keyCoder, valueCoder), (Object)KV.of(key, value));
                    }
                }
            }
        }
    }

    @Test
    public void testCoderIsSerializableWithWellKnownCoderType() throws Exception {
        CoderProperties.coderSerializable((Coder)KvCoder.of((Coder)GlobalWindow.Coder.INSTANCE, (Coder)GlobalWindow.Coder.INSTANCE));
    }

    @Test
    public void testWireFormatEncode() throws Exception {
        CoderProperties.coderEncodesBase64(TEST_CODER, TEST_VALUES, TEST_ENCODINGS);
    }

    @Test
    public void encodeNullThrowsCoderException() throws Exception {
        this.thrown.expect(CoderException.class);
        this.thrown.expectMessage("cannot encode a null KV");
        CoderUtils.encodeToBase64(TEST_CODER, null);
    }

    @Test
    public void testEncodedTypeDescriptor() throws Exception {
        TypeDescriptor<KV<String, Integer>> typeDescriptor = new TypeDescriptor<KV<String, Integer>>(){};
        Assert.assertThat((Object)TEST_CODER.getEncodedTypeDescriptor(), (Matcher)Matchers.equalTo((Object)typeDescriptor));
    }

    private static class AnyCoderAndData {
        private CoderAndData<?> coderAndData;

        private AnyCoderAndData() {
        }
    }

    private static class CoderAndData<T> {
        Coder<T> coder;
        List<T> data;

        private CoderAndData() {
        }
    }
}

