/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.IterableCoder;
import org.apache.beam.sdk.coders.ListCoder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.testing.CoderProperties;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class IterableCoderTest {
    private static final Coder<Iterable<Integer>> TEST_CODER = IterableCoder.of((Coder)VarIntCoder.of());
    private static final List<Iterable<Integer>> TEST_VALUES = Arrays.asList(Collections.emptyList(), Collections.singletonList(13), Arrays.asList(1, 2, 3, 4), new ArrayList<Integer>(Arrays.asList(7, 6, 5)));
    private static final List<String> TEST_ENCODINGS = Arrays.asList("AAAAAA", "AAAAAQ0", "AAAABAECAwQ", "AAAAAwcGBQ");
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testCoderIsSerializableWithWellKnownCoderType() throws Exception {
        CoderProperties.coderSerializable((Coder)ListCoder.of((Coder)GlobalWindow.Coder.INSTANCE));
    }

    @Test
    public void testDecodeEncodeContentsInSameOrder() throws Exception {
        for (Iterable<Integer> value : TEST_VALUES) {
            CoderProperties.coderDecodeEncodeContentsInSameOrder(TEST_CODER, value);
        }
    }

    @Test
    public void testCoderSerializable() throws Exception {
        CoderProperties.coderSerializable(TEST_CODER);
    }

    @Test
    public void testWireFormatEncode() throws Exception {
        CoderProperties.coderEncodesBase64(TEST_CODER, TEST_VALUES, TEST_ENCODINGS);
    }

    @Test
    public void encodeNullThrowsCoderException() throws Exception {
        this.thrown.expect(CoderException.class);
        this.thrown.expectMessage("cannot encode a null Iterable");
        CoderUtils.encodeToBase64(TEST_CODER, null);
    }

    @Test
    public void testEncodedTypeDescriptor() throws Exception {
        TypeDescriptor<Iterable<Integer>> typeDescriptor = new TypeDescriptor<Iterable<Integer>>(){};
        Assert.assertThat((Object)TEST_CODER.getEncodedTypeDescriptor(), (Matcher)Matchers.equalTo((Object)typeDescriptor));
    }
}

