/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.Lists;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.primitives.UnsignedBytes;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.InstantCoder;
import org.apache.beam.sdk.testing.CoderProperties;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.joda.time.Instant;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class InstantCoderTest {
    private static final InstantCoder TEST_CODER = InstantCoder.of();
    private static final List<Long> TEST_TIMESTAMPS = Arrays.asList(0L, 1L, -1L, -255L, 256L, Long.MIN_VALUE, Long.MAX_VALUE);
    private static final List<Instant> TEST_VALUES = Lists.newArrayList();
    private static final List<String> TEST_ENCODINGS;
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testBasicEncoding() throws Exception {
        for (Instant value : TEST_VALUES) {
            CoderProperties.coderDecodeEncodeEqual((Coder)TEST_CODER, (Object)value);
        }
    }

    @Test
    public void testOrderedEncoding() throws Exception {
        ArrayList<Long> sortedTimestamps = new ArrayList<Long>(TEST_TIMESTAMPS);
        Collections.sort(sortedTimestamps);
        ArrayList<byte[]> encodings = new ArrayList<byte[]>(sortedTimestamps.size());
        Iterator iterator = sortedTimestamps.iterator();
        while (iterator.hasNext()) {
            long timestamp = (Long)iterator.next();
            encodings.add(CoderUtils.encodeToByteArray((Coder)TEST_CODER, (Object)new Instant(timestamp)));
        }
        ArrayList<byte[]> sortedEncodings = new ArrayList<byte[]>(encodings);
        sortedEncodings.sort(UnsignedBytes.lexicographicalComparator());
        Assert.assertEquals(encodings, sortedEncodings);
    }

    @Test
    public void testWireFormatEncode() throws Exception {
        CoderProperties.coderEncodesBase64((Coder)TEST_CODER, TEST_VALUES, TEST_ENCODINGS);
    }

    @Test
    public void encodeNullThrowsCoderException() throws Exception {
        this.thrown.expect(CoderException.class);
        this.thrown.expectMessage("cannot encode a null Instant");
        CoderUtils.encodeToBase64((Coder)TEST_CODER, null);
    }

    @Test
    public void testEncodedTypeDescriptor() throws Exception {
        Assert.assertThat((Object)TEST_CODER.getEncodedTypeDescriptor(), (Matcher)Matchers.equalTo((Object)TypeDescriptor.of(Instant.class)));
    }

    static {
        for (long timestamp : TEST_TIMESTAMPS) {
            TEST_VALUES.add(new Instant(timestamp));
        }
        TEST_ENCODINGS = Arrays.asList("gAAAAAAAAAA", "gAAAAAAAAAE", "f_________8", "f________wE", "gAAAAAAAAQA", "AAAAAAAAAAA", "__________8");
    }
}

