/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.util.Arrays;
import java.util.List;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.Lists;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.DurationCoder;
import org.apache.beam.sdk.testing.CoderProperties;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class DurationCoderTest {
    private static final DurationCoder TEST_CODER = DurationCoder.of();
    private static final List<Long> TEST_MILLIS = Lists.newArrayList(0L, 1L, -1L, -255L, 256L, Long.MIN_VALUE, Long.MAX_VALUE);
    private static final List<ReadableDuration> TEST_VALUES = Lists.newArrayList();
    private static final List<String> TEST_ENCODINGS;
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testBasicEncoding() throws Exception {
        for (ReadableDuration value : TEST_VALUES) {
            CoderProperties.coderDecodeEncodeEqual((Coder)TEST_CODER, (Object)value);
        }
    }

    @Test
    public void testWireFormatEncode() throws Exception {
        CoderProperties.coderEncodesBase64((Coder)TEST_CODER, TEST_VALUES, TEST_ENCODINGS);
    }

    @Test
    public void encodeNullThrowsCoderException() throws Exception {
        this.thrown.expect(CoderException.class);
        this.thrown.expectMessage("cannot encode a null ReadableDuration");
        CoderUtils.encodeToBase64((Coder)TEST_CODER, null);
    }

    @Test
    public void testEncodedTypeDescriptor() throws Exception {
        Assert.assertThat((Object)TEST_CODER.getEncodedTypeDescriptor(), (Matcher)Matchers.equalTo((Object)TypeDescriptor.of(ReadableDuration.class)));
    }

    static {
        for (long millis : TEST_MILLIS) {
            TEST_VALUES.add((ReadableDuration)Duration.millis((long)millis));
        }
        TEST_ENCODINGS = Arrays.asList("AA", "AQ", "____________AQ", "gf7_________AQ", "gAI", "gICAgICAgICAAQ", "__________9_");
    }
}

