/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.util.Arrays;
import java.util.List;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.DoubleCoder;
import org.apache.beam.sdk.testing.CoderProperties;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class DoubleCoderTest {
    private static final Coder<Double> TEST_CODER = DoubleCoder.of();
    private static final List<Double> TEST_VALUES = Arrays.asList(0.0, -0.5, 0.5, 0.3, -0.3, 1.0, -43.8956874, Math.PI, Double.MAX_VALUE, Double.MIN_VALUE, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NaN);
    private static final List<String> TEST_ENCODINGS = Arrays.asList("AAAAAAAAAAA", "v-AAAAAAAAA", "P-AAAAAAAAA", "P9MzMzMzMzM", "v9MzMzMzMzM", "P_AAAAAAAAA", "wEXypeJ9ODo", "QAkh-1RELRg", "f-________8", "AAAAAAAAAAE", "f_AAAAAAAAA", "__AAAAAAAAA", "f_gAAAAAAAA");
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testDecodeEncodeEqual() throws Exception {
        for (Double value : TEST_VALUES) {
            CoderProperties.coderDecodeEncodeEqual(TEST_CODER, (Object)value);
        }
    }

    @Test
    public void testWireFormatEncode() throws Exception {
        CoderProperties.coderEncodesBase64(TEST_CODER, TEST_VALUES, TEST_ENCODINGS);
    }

    @Test
    public void encodeNullThrowsCoderException() throws Exception {
        this.thrown.expect(CoderException.class);
        this.thrown.expectMessage("cannot encode a null Double");
        CoderUtils.encodeToBase64(TEST_CODER, null);
    }

    @Test
    public void testEncodedTypeDescriptor() throws Exception {
        Assert.assertThat((Object)TEST_CODER.getEncodedTypeDescriptor(), (Matcher)Matchers.equalTo((Object)TypeDescriptor.of(Double.class)));
    }
}

