/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.Lists;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.Sets;
import org.apache.beam.sdk.coders.BigEndianIntegerCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.DelegateCoder;
import org.apache.beam.sdk.coders.ListCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.testing.CoderProperties;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class DelegateCoderTest
implements Serializable {
    private static final List<Set<Integer>> TEST_VALUES = Arrays.asList(Collections.emptySet(), Collections.singleton(13), new HashSet<Integer>(Arrays.asList(31, -5, 83)));
    private static final TypeDescriptor<Set<Integer>> SET_INTEGER_TYPE_DESCRIPTOR = new TypeDescriptor<Set<Integer>>(){};
    private static final DelegateCoder<Set<Integer>, List<Integer>> TEST_CODER = DelegateCoder.of((Coder)ListCoder.of((Coder)VarIntCoder.of()), (DelegateCoder.CodingFunction)new DelegateCoder.CodingFunction<Set<Integer>, List<Integer>>(){

        public List<Integer> apply(Set<Integer> input) {
            return Lists.newArrayList(input);
        }

        public boolean equals(Object o) {
            return o != null && this.getClass() == o.getClass();
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }
    }, (DelegateCoder.CodingFunction)new DelegateCoder.CodingFunction<List<Integer>, Set<Integer>>(){

        public Set<Integer> apply(List<Integer> input) {
            return Sets.newHashSet(input);
        }

        public boolean equals(Object o) {
            return o != null && this.getClass() == o.getClass();
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }
    }, SET_INTEGER_TYPE_DESCRIPTOR);

    @Test
    public void testDeterministic() throws Exception {
        for (Set<Integer> value : TEST_VALUES) {
            CoderProperties.coderDeterministic(TEST_CODER, value, Sets.newHashSet(value));
        }
    }

    @Test
    public void testDecodeEncodeEqual() throws Exception {
        for (Set<Integer> value : TEST_VALUES) {
            CoderProperties.coderDecodeEncodeEqual(TEST_CODER, value);
        }
    }

    @Test
    public void testSerializable() throws Exception {
        CoderProperties.coderSerializable(TEST_CODER);
    }

    @Test
    public void testCoderEquals() throws Exception {
        DelegateCoder.CodingFunction & Serializable identityFn = (DelegateCoder.CodingFunction & Serializable)input -> input;
        DelegateCoder varIntCoder1 = DelegateCoder.of((Coder)VarIntCoder.of(), (DelegateCoder.CodingFunction)identityFn, (DelegateCoder.CodingFunction)identityFn);
        DelegateCoder varIntCoder2 = DelegateCoder.of((Coder)VarIntCoder.of(), (DelegateCoder.CodingFunction)identityFn, (DelegateCoder.CodingFunction)identityFn);
        DelegateCoder bigEndianIntegerCoder = DelegateCoder.of((Coder)BigEndianIntegerCoder.of(), (DelegateCoder.CodingFunction)identityFn, (DelegateCoder.CodingFunction)identityFn);
        Assert.assertEquals((Object)varIntCoder1, (Object)varIntCoder2);
        Assert.assertEquals((long)varIntCoder1.hashCode(), (long)varIntCoder2.hashCode());
        Assert.assertNotEquals((Object)varIntCoder1, (Object)bigEndianIntegerCoder);
        Assert.assertNotEquals((long)varIntCoder1.hashCode(), (long)bigEndianIntegerCoder.hashCode());
    }

    @Test
    public void testEncodedTypeDescriptorSimpleEncodedType() throws Exception {
        Assert.assertThat((Object)DelegateCoder.of((Coder)StringUtf8Coder.of(), String::valueOf, Integer::valueOf, (TypeDescriptor)new TypeDescriptor<Integer>(){}).getEncodedTypeDescriptor(), (Matcher)Matchers.equalTo((Object)TypeDescriptor.of(Integer.class)));
    }

    @Test
    public void testEncodedTypeDescriptor() throws Exception {
        TypeDescriptor<Set<Integer>> typeDescriptor = new TypeDescriptor<Set<Integer>>(){};
        Assert.assertThat((Object)TEST_CODER.getEncodedTypeDescriptor(), (Matcher)Matchers.equalTo((Object)typeDescriptor));
    }
}

