/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.base.Preconditions;
import org.apache.beam.sdk.coders.AvroCoder;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderProvider;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.coders.DefaultCoder;
import org.apache.beam.sdk.coders.ListCoder;
import org.apache.beam.sdk.coders.SerializableCoder;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class DefaultCoderTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testCodersWithoutComponents() throws Exception {
        CoderRegistry registry = CoderRegistry.createDefault();
        registry.registerCoderProvider((CoderProvider)new DefaultCoder.DefaultCoderProviderRegistrar.DefaultCoderProvider());
        Assert.assertThat((Object)registry.getCoder(AvroRecord.class), (Matcher)Matchers.instanceOf(AvroCoder.class));
        Assert.assertThat((Object)registry.getCoder(SerializableRecord.class), (Matcher)Matchers.instanceOf(SerializableCoder.class));
        Assert.assertThat((Object)registry.getCoder(CustomRecord.class), (Matcher)Matchers.instanceOf(CustomSerializableCoder.class));
        Assert.assertThat((Object)registry.getCoder(OldCustomRecord.class), (Matcher)Matchers.instanceOf(OldCustomSerializableCoder.class));
    }

    @Test
    public void testDefaultCoderInCollection() throws Exception {
        CoderRegistry registry = CoderRegistry.createDefault();
        registry.registerCoderProvider((CoderProvider)new DefaultCoder.DefaultCoderProviderRegistrar.DefaultCoderProvider());
        Coder avroRecordCoder = registry.getCoder((TypeDescriptor)new TypeDescriptor<List<AvroRecord>>(){});
        Assert.assertThat((Object)avroRecordCoder, (Matcher)Matchers.instanceOf(ListCoder.class));
        Assert.assertThat((Object)((ListCoder)avroRecordCoder).getElemCoder(), (Matcher)Matchers.instanceOf(AvroCoder.class));
        Assert.assertThat((Object)registry.getCoder((TypeDescriptor)new TypeDescriptor<List<SerializableRecord>>(){}), (Matcher)Matchers.equalTo((Object)ListCoder.of((Coder)SerializableCoder.of(SerializableRecord.class))));
    }

    @Test
    public void testUnknown() throws Exception {
        this.thrown.expect(CannotProvideCoderException.class);
        new DefaultCoder.DefaultCoderProviderRegistrar.DefaultCoderProvider().coderFor(TypeDescriptor.of(Unknown.class), Collections.emptyList());
    }

    private static class OldCustomSerializableCoder
    extends SerializableCoder<OldCustomRecord> {
        public static <T extends Serializable> SerializableCoder<T> of(Class<T> recordType) {
            Preconditions.checkArgument(OldCustomRecord.class.isAssignableFrom(recordType));
            return new OldCustomSerializableCoder();
        }

        protected OldCustomSerializableCoder() {
            super(OldCustomRecord.class, TypeDescriptor.of(OldCustomRecord.class));
        }

        public static CoderProvider getCoderProvider() {
            return new CoderProvider(){

                public <T> Coder<T> coderFor(TypeDescriptor<T> typeDescriptor, List<? extends Coder<?>> componentCoders) throws CannotProvideCoderException {
                    return OldCustomSerializableCoder.of(typeDescriptor.getRawType());
                }
            };
        }
    }

    private static class CustomSerializableCoder
    extends SerializableCoder<CustomRecord> {
        public static <T extends Serializable> SerializableCoder<T> of(TypeDescriptor<T> recordType) {
            Preconditions.checkArgument(recordType.isSupertypeOf((TypeDescriptor)new TypeDescriptor<CustomRecord>(){}));
            return new CustomSerializableCoder();
        }

        protected CustomSerializableCoder() {
            super(CustomRecord.class, TypeDescriptor.of(CustomRecord.class));
        }

        public static CoderProvider getCoderProvider() {
            return new CoderProvider(){

                public <T> Coder<T> coderFor(TypeDescriptor<T> typeDescriptor, List<? extends Coder<?>> componentCoders) throws CannotProvideCoderException {
                    return CustomSerializableCoder.of(typeDescriptor);
                }
            };
        }
    }

    private static class Unknown {
        private Unknown() {
        }
    }

    @DefaultCoder(value=OldCustomSerializableCoder.class)
    private static class OldCustomRecord
    extends SerializableBase {
        private OldCustomRecord() {
        }
    }

    @DefaultCoder(value=CustomSerializableCoder.class)
    private static class CustomRecord
    extends SerializableBase {
        private CustomRecord() {
        }
    }

    @DefaultCoder(value=SerializableCoder.class)
    private static class SerializableRecord
    extends SerializableBase {
        private SerializableRecord() {
        }
    }

    private static class SerializableBase
    implements Serializable {
        private SerializableBase() {
        }
    }

    @DefaultCoder(value=AvroCoder.class)
    private static class AvroRecord {
        private AvroRecord() {
        }
    }
}

