/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.testing.CoderProperties;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.sdk.values.KV;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class CustomCoderTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testEncodeDecode() throws Exception {
        MyCustomCoder coder = new MyCustomCoder("key");
        CoderProperties.coderDecodeEncodeEqual((Coder)coder, (Object)KV.of((Object)"key", (Object)3L));
        byte[] encoded2 = CoderUtils.encodeToByteArray((Coder)coder, (Object)KV.of((Object)"ignored", (Object)3L));
        Assert.assertEquals((Object)KV.of((Object)"key", (Object)3L), (Object)CoderUtils.decodeFromByteArray((Coder)coder, (byte[])encoded2));
    }

    @Test
    public void testEncodable() throws Exception {
        SerializableUtils.ensureSerializable((Coder)new MyCustomCoder("key"));
    }

    private static class MyCustomCoder
    extends CustomCoder<KV<String, Long>> {
        private final String key;

        public MyCustomCoder(String key) {
            this.key = key;
        }

        public void encode(KV<String, Long> kv, OutputStream out) throws IOException {
            new DataOutputStream(out).writeLong((Long)kv.getValue());
        }

        public KV<String, Long> decode(InputStream inStream) throws IOException {
            return KV.of((Object)this.key, (Object)new DataInputStream(inStream).readLong());
        }

        public boolean equals(Object other) {
            return other instanceof MyCustomCoder && this.key.equals(((MyCustomCoder)((Object)other)).key);
        }

        public int hashCode() {
            return this.key.hashCode();
        }
    }
}

