/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.CollectionCoder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.testing.CoderProperties;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class CollectionCoderTest {
    private static final Coder<Collection<Integer>> TEST_CODER = CollectionCoder.of((Coder)VarIntCoder.of());
    private static final List<Collection<Integer>> TEST_VALUES = Arrays.asList(Collections.emptyList(), Collections.emptySet(), Collections.singletonList(13), Arrays.asList(1, 2, 3, 4), new ArrayList<Integer>(Arrays.asList(7, 6, 5)), new TreeSet<Integer>(Arrays.asList(31, -5, 83)));
    private static final List<String> TEST_ENCODINGS = Arrays.asList("AAAAAA", "AAAAAA", "AAAAAQ0", "AAAABAECAwQ", "AAAAAwcGBQ", "AAAAA_v___8PH1M");
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testDecodeEncodeContentsEqual() throws Exception {
        for (Collection<Integer> value : TEST_VALUES) {
            CoderProperties.coderDecodeEncodeContentsEqual(TEST_CODER, value);
        }
    }

    @Test
    public void testWireFormat() throws Exception {
        CoderProperties.coderDecodesBase64ContentsEqual(TEST_CODER, TEST_ENCODINGS, TEST_VALUES);
    }

    @Test
    public void encodeNullThrowsCoderException() throws Exception {
        this.thrown.expect(CoderException.class);
        this.thrown.expectMessage("cannot encode a null Collection");
        CoderUtils.encodeToBase64(TEST_CODER, null);
    }

    @Test
    public void testCoderIsSerializableWithWellKnownCoderType() throws Exception {
        CoderProperties.coderSerializable((Coder)CollectionCoder.of((Coder)GlobalWindow.Coder.INSTANCE));
    }

    @Test
    public void testEncodedTypeDescriptor() throws Exception {
        TypeDescriptor<Collection<Integer>> expectedTypeDescriptor = new TypeDescriptor<Collection<Integer>>(){};
        Assert.assertThat((Object)TEST_CODER.getEncodedTypeDescriptor(), (Matcher)Matchers.equalTo((Object)expectedTypeDescriptor));
    }
}

