/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.util.Collections;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.VoidCoder;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class CoderTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testContextEqualsAndHashCode() {
        Assert.assertEquals((Object)Coder.Context.NESTED, (Object)new Coder.Context(false));
        Assert.assertEquals((Object)Coder.Context.OUTER, (Object)new Coder.Context(true));
        Assert.assertNotEquals((Object)Coder.Context.NESTED, (Object)Coder.Context.OUTER);
        Assert.assertEquals((long)Coder.Context.NESTED.hashCode(), (long)new Coder.Context(false).hashCode());
        Assert.assertEquals((long)Coder.Context.OUTER.hashCode(), (long)new Coder.Context(true).hashCode());
        Assert.assertNotEquals((long)Coder.Context.NESTED.hashCode(), (long)Coder.Context.OUTER.hashCode());
    }

    @Test
    public void testContextToString() {
        Assert.assertEquals((Object)"Context{NESTED}", (Object)Coder.Context.NESTED.toString());
        Assert.assertEquals((Object)"Context{OUTER}", (Object)Coder.Context.OUTER.toString());
    }

    @Test
    public void testNonDeterministicExcpetionRequiresReason() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Reasons must not be empty");
        new Coder.NonDeterministicException((Coder)VoidCoder.of(), Collections.emptyList());
    }

    @Test
    public void testNonDeterministicException() {
        Coder.NonDeterministicException rootCause = new Coder.NonDeterministicException((Coder)VoidCoder.of(), "Root Cause");
        Coder.NonDeterministicException exception = new Coder.NonDeterministicException((Coder)StringUtf8Coder.of(), "Problem", rootCause);
        Assert.assertEquals((Object)((Object)rootCause), (Object)exception.getCause());
        Assert.assertThat((Object)exception.getReasons(), (Matcher)Matchers.contains((Object[])new String[]{"Problem"}));
        Assert.assertThat((Object)exception.toString(), (Matcher)Matchers.containsString((String)"Problem"));
        Assert.assertThat((Object)exception.toString(), (Matcher)Matchers.containsString((String)"is not deterministic"));
    }

    @Test
    public void testTypeIsPreserved() throws Exception {
        Assert.assertThat((Object)VoidCoder.of().getEncodedTypeDescriptor(), (Matcher)Matchers.equalTo((Object)TypeDescriptor.of(Void.class)));
    }
}

