/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import com.google.auto.service.AutoService;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.ImmutableList;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.AvroCoder;
import org.apache.beam.sdk.coders.BigEndianIntegerCoder;
import org.apache.beam.sdk.coders.BigEndianLongCoder;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.CoderProvider;
import org.apache.beam.sdk.coders.CoderProviderRegistrar;
import org.apache.beam.sdk.coders.CoderProviders;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.coders.DefaultCoder;
import org.apache.beam.sdk.coders.DoubleCoder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.ListCoder;
import org.apache.beam.sdk.coders.MapCoder;
import org.apache.beam.sdk.coders.SerializableCoder;
import org.apache.beam.sdk.coders.SetCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.testing.ExpectedLogs;
import org.apache.beam.sdk.testing.NeedsRunner;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.util.common.ElementByteSizeObserver;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class CoderRegistryTest {
    @Rule
    public TestPipeline pipeline = TestPipeline.create();
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    @Rule
    public ExpectedLogs expectedLogs = ExpectedLogs.none(CoderRegistry.class);

    @Test
    public void testRegisterInstantiatedCoder() throws Exception {
        CoderRegistry registry = CoderRegistry.createDefault();
        registry.registerCoderForClass(MyValue.class, (Coder)MyValueCoder.of());
        Assert.assertEquals((Object)registry.getCoder(MyValue.class), (Object)((Object)MyValueCoder.of()));
    }

    @Test
    public void testSimpleDefaultCoder() throws Exception {
        CoderRegistry registry = CoderRegistry.createDefault();
        Assert.assertEquals((Object)StringUtf8Coder.of(), (Object)registry.getCoder(String.class));
    }

    @Test
    public void testSimpleUnknownDefaultCoder() throws Exception {
        CoderRegistry registry = CoderRegistry.createDefault();
        this.thrown.expect(CannotProvideCoderException.class);
        this.thrown.expectMessage(Matchers.allOf((Matcher)Matchers.containsString((String)UnknownType.class.getName()), (Matcher)Matchers.containsString((String)"Unable to provide a Coder for")));
        registry.getCoder(UnknownType.class);
    }

    @Test
    public void testParameterizedDefaultListCoder() throws Exception {
        CoderRegistry registry = CoderRegistry.createDefault();
        TypeDescriptor<List<Integer>> listToken = new TypeDescriptor<List<Integer>>(){};
        Assert.assertEquals((Object)ListCoder.of((Coder)VarIntCoder.of()), (Object)registry.getCoder((TypeDescriptor)listToken));
        registry.registerCoderProvider(CoderProviders.fromStaticMethods(MyValue.class, MyValueCoder.class));
        TypeDescriptor<KV<String, List<MyValue>>> kvToken = new TypeDescriptor<KV<String, List<MyValue>>>(){};
        Assert.assertEquals((Object)KvCoder.of((Coder)StringUtf8Coder.of(), (Coder)ListCoder.of((Coder)MyValueCoder.of())), (Object)registry.getCoder((TypeDescriptor)kvToken));
    }

    @Test
    public void testParameterizedDefaultMapCoder() throws Exception {
        CoderRegistry registry = CoderRegistry.createDefault();
        TypeDescriptor<Map<Integer, String>> mapToken = new TypeDescriptor<Map<Integer, String>>(){};
        Assert.assertEquals((Object)MapCoder.of((Coder)VarIntCoder.of(), (Coder)StringUtf8Coder.of()), (Object)registry.getCoder((TypeDescriptor)mapToken));
    }

    @Test
    public void testParameterizedDefaultNestedMapCoder() throws Exception {
        CoderRegistry registry = CoderRegistry.createDefault();
        TypeDescriptor<Map<Integer, Map<String, Double>>> mapToken = new TypeDescriptor<Map<Integer, Map<String, Double>>>(){};
        Assert.assertEquals((Object)MapCoder.of((Coder)VarIntCoder.of(), (Coder)MapCoder.of((Coder)StringUtf8Coder.of(), (Coder)DoubleCoder.of())), (Object)registry.getCoder((TypeDescriptor)mapToken));
    }

    @Test
    public void testParameterizedDefaultSetCoder() throws Exception {
        CoderRegistry registry = CoderRegistry.createDefault();
        TypeDescriptor<Set<Integer>> setToken = new TypeDescriptor<Set<Integer>>(){};
        Assert.assertEquals((Object)SetCoder.of((Coder)VarIntCoder.of()), (Object)registry.getCoder((TypeDescriptor)setToken));
    }

    @Test
    public void testParameterizedDefaultNestedSetCoder() throws Exception {
        CoderRegistry registry = CoderRegistry.createDefault();
        TypeDescriptor<Set<Set<Integer>>> setToken = new TypeDescriptor<Set<Set<Integer>>>(){};
        Assert.assertEquals((Object)SetCoder.of((Coder)SetCoder.of((Coder)VarIntCoder.of())), (Object)registry.getCoder((TypeDescriptor)setToken));
    }

    @Test
    public void testParameterizedDefaultCoderUnknown() throws Exception {
        CoderRegistry registry = CoderRegistry.createDefault();
        TypeDescriptor<List<UnknownType>> listUnknownToken = new TypeDescriptor<List<UnknownType>>(){};
        this.thrown.expect(CannotProvideCoderException.class);
        this.thrown.expectMessage(String.format("Cannot provide coder for parameterized type %s: Unable to provide a Coder for %s", listUnknownToken, UnknownType.class.getName()));
        registry.getCoder((TypeDescriptor)listUnknownToken);
    }

    @Test
    public void testTypeParameterInferenceForward() throws Exception {
        CoderRegistry registry = CoderRegistry.createDefault();
        MyGenericClass<MyValue, List<MyValue>> instance = new MyGenericClass<MyValue, List<MyValue>>(){};
        Coder bazCoder = registry.getCoder(instance.getClass(), MyGenericClass.class, Collections.singletonMap(TypeDescriptor.of(MyGenericClass.class).getTypeParameter("FooT"), MyValueCoder.of()), TypeDescriptor.of(MyGenericClass.class).getTypeParameter("BazT"));
        Assert.assertEquals((Object)ListCoder.of((Coder)MyValueCoder.of()), (Object)bazCoder);
    }

    @Test
    public void testTypeParameterInferenceBackward() throws Exception {
        CoderRegistry registry = CoderRegistry.createDefault();
        MyGenericClass<MyValue, List<MyValue>> instance = new MyGenericClass<MyValue, List<MyValue>>(){};
        Coder fooCoder = registry.getCoder(instance.getClass(), MyGenericClass.class, Collections.singletonMap(TypeDescriptor.of(MyGenericClass.class).getTypeParameter("BazT"), ListCoder.of((Coder)MyValueCoder.of())), TypeDescriptor.of(MyGenericClass.class).getTypeParameter("FooT"));
        Assert.assertEquals((Object)((Object)MyValueCoder.of()), (Object)fooCoder);
    }

    @Test
    public void testTypeCompatibility() throws Exception {
        CoderRegistry.verifyCompatible((Coder)BigEndianIntegerCoder.of(), Integer.class);
        CoderRegistry.verifyCompatible((Coder)ListCoder.of((Coder)BigEndianIntegerCoder.of()), (Type)new TypeDescriptor<List<Integer>>(){}.getType());
    }

    @Test
    public void testIntVersusStringIncompatibility() throws Exception {
        this.thrown.expect(CoderRegistry.IncompatibleCoderException.class);
        this.thrown.expectMessage("not assignable");
        CoderRegistry.verifyCompatible((Coder)BigEndianIntegerCoder.of(), String.class);
    }

    @Test
    public void testTypeOverSpecifiedWithMultipleCoders() throws Exception {
        this.thrown.expect(CannotProvideCoderException.class);
        this.thrown.expectMessage("type is over specified");
        CoderRegistry.createDefault().getCoder((TypeDescriptor)new TypeDescriptor<Integer>(){}, (TypeDescriptor)new TypeDescriptor<KV<Integer, Integer>>(){}, (Coder)KvCoder.of((Coder)BigEndianIntegerCoder.of(), (Coder)VarIntCoder.of()));
    }

    @Test
    public void testTooManyCoderArguments() throws Exception {
        this.thrown.expect(CoderRegistry.IncompatibleCoderException.class);
        this.thrown.expectMessage("type parameters");
        this.thrown.expectMessage("less than the number of coder arguments");
        CoderRegistry.verifyCompatible(new TooManyComponentCoders(BigEndianIntegerCoder.of()), List.class);
    }

    @Test
    public void testComponentIncompatibility() throws Exception {
        this.thrown.expect(CoderRegistry.IncompatibleCoderException.class);
        this.thrown.expectMessage("component coder is incompatible");
        CoderRegistry.verifyCompatible((Coder)ListCoder.of((Coder)BigEndianIntegerCoder.of()), (Type)new TypeDescriptor<List<String>>(){}.getType());
    }

    @Test
    public void testDefaultCoderAnnotationGenericRawtype() throws Exception {
        CoderRegistry registry = CoderRegistry.createDefault();
        Assert.assertEquals((Object)registry.getCoder(MySerializableGeneric.class), (Object)SerializableCoder.of(MySerializableGeneric.class));
    }

    @Test
    public void testDefaultCoderAnnotationGeneric() throws Exception {
        CoderRegistry registry = CoderRegistry.createDefault();
        Assert.assertEquals((Object)registry.getCoder((TypeDescriptor)new TypeDescriptor<MySerializableGeneric<String>>(){}), (Object)SerializableCoder.of(MySerializableGeneric.class));
    }

    @Test
    public void testTypeVariableErrorMessage() throws Exception {
        CoderRegistry registry = CoderRegistry.createDefault();
        this.thrown.expect(CannotProvideCoderException.class);
        this.thrown.expectMessage("Unable to provide a Coder");
        registry.getCoder(TypeDescriptor.of(TestGenericClass.class.getTypeParameters()[0]));
    }

    @Test
    public void testSerializableTypeVariableDefaultCoder() throws Exception {
        CoderRegistry registry = CoderRegistry.createDefault();
        TypeDescriptor type = TypeDescriptor.of(TestSerializableGenericClass.class.getTypeParameters()[0]);
        Assert.assertEquals((Object)SerializableCoder.of((TypeDescriptor)type), (Object)registry.getCoder(type));
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testSpecializedButIgnoredGenericInPipeline() throws Exception {
        ((PCollection)this.pipeline.apply((PTransform)Create.of((Object)"hello", (Object[])new String[]{"goodbye"}))).apply((PTransform)new PTransformOutputingMySerializableGeneric());
        this.pipeline.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testIgnoredGenericInPipeline() throws Exception {
        ((PCollection)this.pipeline.apply((PTransform)Create.of((Object)"hello", (Object[])new String[]{"goodbye"}))).apply(new GenericOutputMySerializedGeneric());
        this.pipeline.run();
    }

    @Test
    public void testAutomaticRegistrationOfCoderProviders() throws Exception {
        Assert.assertEquals((Object)((Object)AutoRegistrationClassCoder.INSTANCE), (Object)CoderRegistry.createDefault().getCoder(AutoRegistrationClass.class));
    }

    @Test
    public void testCoderPrecedence() throws Exception {
        CoderRegistry registry = CoderRegistry.createDefault();
        Assert.assertEquals((Object)AvroCoder.of(MyValueA.class), (Object)registry.getCoder(MyValueA.class));
        Assert.assertEquals((Object)((Object)MyValueBCoder.INSTANCE), (Object)registry.getCoder(MyValueB.class));
        Assert.assertEquals((Object)SerializableCoder.of(MyValueC.class), (Object)registry.getCoder(MyValueC.class));
    }

    @AutoService(value=CoderProviderRegistrar.class)
    public static class MyValueBCoderProviderRegistrar
    implements CoderProviderRegistrar {
        public List<CoderProvider> getCoderProviders() {
            return ImmutableList.of(CoderProviders.forCoder((TypeDescriptor)TypeDescriptor.of(MyValueB.class), (Coder)MyValueBCoder.INSTANCE));
        }
    }

    private static class MyValueBCoder
    extends CustomCoder<MyValueB> {
        private static final MyValueBCoder INSTANCE = new MyValueBCoder();

        private MyValueBCoder() {
        }

        public void encode(MyValueB value, OutputStream outStream) throws CoderException, IOException {
        }

        public MyValueB decode(InputStream inStream) throws CoderException, IOException {
            return null;
        }
    }

    @AutoService(value=CoderProviderRegistrar.class)
    public static class MyValueACoderProviderRegistrar
    implements CoderProviderRegistrar {
        public List<CoderProvider> getCoderProviders() {
            return ImmutableList.of(CoderProviders.forCoder((TypeDescriptor)TypeDescriptor.of(MyValueA.class), (Coder)MyValueACoder.INSTANCE));
        }
    }

    private static class MyValueACoder
    extends CustomCoder<MyValueA> {
        private static final MyValueACoder INSTANCE = new MyValueACoder();

        private MyValueACoder() {
        }

        public void encode(MyValueA value, OutputStream outStream) throws CoderException, IOException {
        }

        public MyValueA decode(InputStream inStream) throws CoderException, IOException {
            return null;
        }
    }

    private static class MyValueC
    implements Serializable {
        private MyValueC() {
        }
    }

    private static class MyValueB
    implements Serializable {
        private MyValueB() {
        }
    }

    @DefaultCoder(value=AvroCoder.class)
    private static class MyValueA
    implements Serializable {
        private MyValueA() {
        }
    }

    @AutoService(value=CoderProviderRegistrar.class)
    public static class RegisteredTestCoderProviderRegistrar
    implements CoderProviderRegistrar {
        public List<CoderProvider> getCoderProviders() {
            return ImmutableList.of(CoderProviders.forCoder((TypeDescriptor)TypeDescriptor.of(AutoRegistrationClass.class), (Coder)AutoRegistrationClassCoder.INSTANCE));
        }
    }

    private static class AutoRegistrationClassCoder
    extends CustomCoder<AutoRegistrationClass> {
        private static final AutoRegistrationClassCoder INSTANCE = new AutoRegistrationClassCoder();

        private AutoRegistrationClassCoder() {
        }

        public void encode(AutoRegistrationClass value, OutputStream outStream) {
        }

        public AutoRegistrationClass decode(InputStream inStream) {
            return null;
        }
    }

    private static class AutoRegistrationClass {
        private AutoRegistrationClass() {
        }
    }

    @DefaultCoder(value=SerializableCoder.class)
    private static class MySerializableGeneric<T extends Serializable>
    implements Serializable {
        private T foo;

        private MySerializableGeneric() {
        }
    }

    private static class UnknownType {
        private UnknownType() {
        }
    }

    private static class MyValueCoder
    extends AtomicCoder<MyValue> {
        private static final MyValueCoder INSTANCE = new MyValueCoder();
        private static final TypeDescriptor<MyValue> TYPE_DESCRIPTOR = TypeDescriptor.of(MyValue.class);

        private MyValueCoder() {
        }

        public static MyValueCoder of() {
            return INSTANCE;
        }

        public void encode(MyValue value, OutputStream outStream) throws CoderException, IOException {
        }

        public MyValue decode(InputStream inStream) throws CoderException, IOException {
            return new MyValue();
        }

        public void verifyDeterministic() {
        }

        public boolean consistentWithEquals() {
            return true;
        }

        public Object structuralValue(MyValue value) {
            return value;
        }

        public boolean isRegisterByteSizeObserverCheap(MyValue value) {
            return true;
        }

        public void registerByteSizeObserver(MyValue value, ElementByteSizeObserver observer) throws Exception {
            observer.update((Object)0L);
        }

        public TypeDescriptor<MyValue> getEncodedTypeDescriptor() {
            return TYPE_DESCRIPTOR;
        }
    }

    private static class MyValue {
        private MyValue() {
        }
    }

    private static class MyGenericClass<FooT, BazT> {
        private MyGenericClass() {
        }
    }

    private static class GenericOutputMySerializedGeneric<T extends Serializable>
    extends PTransform<PCollection<String>, PCollection<KV<String, MySerializableGeneric<T>>>> {
        private GenericOutputMySerializedGeneric() {
        }

        public PCollection<KV<String, MySerializableGeneric<T>>> expand(PCollection<String> input) {
            return (PCollection)input.apply((PTransform)ParDo.of((DoFn)new OutputDoFn()));
        }

        private class OutputDoFn
        extends DoFn<String, KV<String, MySerializableGeneric<T>>> {
            private OutputDoFn() {
            }

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) {
            }
        }
    }

    private static class TestSerializableGenericClass<TestGenericT extends Serializable> {
        private TestSerializableGenericClass() {
        }
    }

    private static class TestGenericClass<TestGenericT> {
        private TestGenericClass() {
        }
    }

    private static class PTransformOutputingMySerializableGeneric
    extends PTransform<PCollection<String>, PCollection<KV<String, MySerializableGeneric<String>>>> {
        private PTransformOutputingMySerializableGeneric() {
        }

        public PCollection<KV<String, MySerializableGeneric<String>>> expand(PCollection<String> input) {
            return (PCollection)input.apply((PTransform)ParDo.of((DoFn)new OutputDoFn()));
        }

        private static class OutputDoFn
        extends DoFn<String, KV<String, MySerializableGeneric<String>>> {
            private OutputDoFn() {
            }

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) {
            }
        }
    }

    private static class TooManyComponentCoders<T>
    extends ListCoder<T> {
        public TooManyComponentCoders(Coder<T> actualComponentCoder) {
            super(actualComponentCoder);
        }

        public List<? extends Coder<?>> getCoderArguments() {
            return ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll((Iterable)super.getCoderArguments())).add(BigEndianLongCoder.of())).build();
        }
    }

    private static class NotSerializableClass {
        private NotSerializableClass() {
        }
    }

    private static class SerializableClass
    implements Serializable {
        private SerializableClass() {
        }
    }
}

