/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderProvider;
import org.apache.beam.sdk.coders.CoderProviders;
import org.apache.beam.sdk.coders.DoubleCoder;
import org.apache.beam.sdk.coders.IterableCoder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.ListCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class CoderProvidersTest {
    @Test
    public void testCoderProvidersFromStaticMethodsForParameterlessTypes() throws Exception {
        CoderProvider factory = CoderProviders.fromStaticMethods(String.class, StringUtf8Coder.class);
        Assert.assertEquals((Object)StringUtf8Coder.of(), (Object)factory.coderFor(TypeDescriptors.strings(), Collections.emptyList()));
        factory = CoderProviders.fromStaticMethods(Double.class, DoubleCoder.class);
        Assert.assertEquals((Object)DoubleCoder.of(), (Object)factory.coderFor(TypeDescriptors.doubles(), Collections.emptyList()));
        factory = CoderProviders.fromStaticMethods(byte[].class, ByteArrayCoder.class);
        Assert.assertEquals((Object)ByteArrayCoder.of(), (Object)factory.coderFor(TypeDescriptor.of(byte[].class), Collections.emptyList()));
    }

    @Test
    public void testKvCoderProvider() throws Exception {
        TypeDescriptor type = TypeDescriptors.kvs((TypeDescriptor)TypeDescriptors.doubles(), (TypeDescriptor)TypeDescriptors.doubles());
        CoderProvider kvCoderProvider = CoderProviders.fromStaticMethods(KV.class, KvCoder.class);
        Assert.assertEquals((Object)KvCoder.of((Coder)DoubleCoder.of(), (Coder)DoubleCoder.of()), (Object)kvCoderProvider.coderFor(type, Arrays.asList(DoubleCoder.of(), DoubleCoder.of())));
    }

    @Test
    public void testListCoderProvider() throws Exception {
        TypeDescriptor type = TypeDescriptors.lists((TypeDescriptor)TypeDescriptors.doubles());
        CoderProvider listCoderProvider = CoderProviders.fromStaticMethods(List.class, ListCoder.class);
        Assert.assertEquals((Object)ListCoder.of((Coder)DoubleCoder.of()), (Object)listCoderProvider.coderFor(type, Arrays.asList(DoubleCoder.of())));
    }

    @Test
    public void testIterableCoderProvider() throws Exception {
        TypeDescriptor type = TypeDescriptors.iterables((TypeDescriptor)TypeDescriptors.doubles());
        CoderProvider iterableCoderProvider = CoderProviders.fromStaticMethods(Iterable.class, IterableCoder.class);
        Assert.assertEquals((Object)IterableCoder.of((Coder)DoubleCoder.of()), (Object)iterableCoderProvider.coderFor(type, Arrays.asList(DoubleCoder.of())));
    }
}

