/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.testing.CoderProperties;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ByteArrayCoderTest {
    private static final ByteArrayCoder TEST_CODER = ByteArrayCoder.of();
    private static final List<byte[]> TEST_VALUES = Arrays.asList({10, 11, 12}, {13, 3}, {13, 14}, new byte[0]);
    private static final List<String> TEST_ENCODINGS = Arrays.asList("CgsM", "DQM", "DQ4", "");
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testDecodeEncodeEquals() throws Exception {
        for (byte[] value : TEST_VALUES) {
            CoderProperties.coderDecodeEncodeEqual((Coder)TEST_CODER, (Object)value);
        }
    }

    @Test
    public void testRegisterByteSizeObserver() throws Exception {
        CoderProperties.testByteCount((Coder)ByteArrayCoder.of(), (Coder.Context)Coder.Context.OUTER, (Object[])new byte[][]{{10, 11, 12}});
        CoderProperties.testByteCount((Coder)ByteArrayCoder.of(), (Coder.Context)Coder.Context.NESTED, (Object[])new byte[][]{{10, 11, 12}, new byte[0], new byte[0], {13, 14}, new byte[0]});
    }

    @Test
    public void testStructuralValueConsistentWithEquals() throws Exception {
        for (byte[] value1 : TEST_VALUES) {
            for (byte[] value2 : TEST_VALUES) {
                CoderProperties.structuralValueConsistentWithEquals((Coder)TEST_CODER, (Object)value1, (Object)value2);
            }
        }
    }

    @Test
    public void testEncodeThenMutate() throws Exception {
        byte[] input = new byte[]{7, 3, 10, 15};
        byte[] encoded = CoderUtils.encodeToByteArray((Coder)TEST_CODER, (Object)input);
        input[1] = 9;
        byte[] decoded = (byte[])CoderUtils.decodeFromByteArray((Coder)TEST_CODER, (byte[])encoded);
        Assert.assertThat((Object)input, (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)decoded)));
    }

    @Test
    public void testEncodeAndOwn() throws Exception {
        for (byte[] value : TEST_VALUES) {
            byte[] encodedSlow = CoderUtils.encodeToByteArray((Coder)TEST_CODER, (Object)value);
            byte[] encodedFast = ByteArrayCoderTest.encodeToByteArrayAndOwn(TEST_CODER, value);
            Assert.assertThat((Object)encodedSlow, (Matcher)Matchers.equalTo((Object)encodedFast));
        }
    }

    private static byte[] encodeToByteArrayAndOwn(ByteArrayCoder coder, byte[] value) throws IOException {
        return ByteArrayCoderTest.encodeToByteArrayAndOwn(coder, value, Coder.Context.OUTER);
    }

    private static byte[] encodeToByteArrayAndOwn(ByteArrayCoder coder, byte[] value, Coder.Context context) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        coder.encodeAndOwn(value, (OutputStream)os, context);
        return os.toByteArray();
    }

    @Test
    public void testWireFormatEncode() throws Exception {
        CoderProperties.coderEncodesBase64((Coder)TEST_CODER, TEST_VALUES, TEST_ENCODINGS);
    }

    @Test
    public void encodeNullThrowsCoderException() throws Exception {
        this.thrown.expect(CoderException.class);
        this.thrown.expectMessage("cannot encode a null byte[]");
        CoderUtils.encodeToBase64((Coder)TEST_CODER, null);
    }

    @Test
    public void testEncodedTypeDescriptor() throws Exception {
        Assert.assertThat((Object)TEST_CODER.getEncodedTypeDescriptor(), (Matcher)Matchers.equalTo((Object)TypeDescriptor.of(byte[].class)));
    }
}

