/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import org.apache.beam.sdk.coders.BitSetCoder;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.testing.CoderProperties;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class BitSetCoderTest {
    private static final Coder<BitSet> TEST_CODER = BitSetCoder.of();
    private static final List<BitSet> TEST_VALUES = Arrays.asList(BitSet.valueOf(new byte[]{10, 11, 12}), BitSet.valueOf(new byte[]{13, 3}), BitSet.valueOf(new byte[]{13, 14}), BitSet.valueOf(new byte[0]));
    private static final List<String> TEST_ENCODINGS = Arrays.asList("CgsM", "DQM", "DQ4", "");
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testDecodeEncodeEquals() throws Exception {
        for (BitSet value : TEST_VALUES) {
            CoderProperties.coderDecodeEncodeEqual(TEST_CODER, (Object)value);
        }
    }

    @Test
    public void testRegisterByteSizeObserver() throws Exception {
        CoderProperties.testByteCount((Coder)ByteArrayCoder.of(), (Coder.Context)Coder.Context.OUTER, (Object[])new byte[][]{{10, 11, 12}});
        CoderProperties.testByteCount((Coder)ByteArrayCoder.of(), (Coder.Context)Coder.Context.NESTED, (Object[])new byte[][]{{10, 11, 12}, new byte[0], new byte[0], {13, 14}, new byte[0]});
    }

    @Test
    public void testStructuralValueConsistentWithEquals() throws Exception {
        for (BitSet value1 : TEST_VALUES) {
            for (BitSet value2 : TEST_VALUES) {
                CoderProperties.structuralValueConsistentWithEquals(TEST_CODER, (Object)value1, (Object)value2);
            }
        }
    }

    @Test
    public void testWireFormatEncode() throws Exception {
        CoderProperties.coderEncodesBase64(TEST_CODER, TEST_VALUES, TEST_ENCODINGS);
    }

    @Test
    public void encodeNullThrowsCoderException() throws Exception {
        this.thrown.expect(CoderException.class);
        this.thrown.expectMessage("cannot encode a null BitSet");
        CoderUtils.encodeToBase64(TEST_CODER, null);
    }

    @Test
    public void testEncodedTypeDescriptor() throws Exception {
        Assert.assertThat((Object)TEST_CODER.getEncodedTypeDescriptor(), (Matcher)Matchers.equalTo((Object)TypeDescriptor.of(BitSet.class)));
    }
}

