/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.math.BigInteger;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.ImmutableList;
import org.apache.beam.sdk.coders.BigIntegerCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.testing.CoderProperties;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.util.common.ElementByteSizeObserver;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class BigIntegerCoderTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private static final Coder<BigInteger> TEST_CODER = BigIntegerCoder.of();
    private static final ImmutableList<BigInteger> TEST_VALUES = ImmutableList.of(BigInteger.valueOf(Integer.MIN_VALUE).subtract(BigInteger.valueOf(Integer.MAX_VALUE)), BigInteger.valueOf(Integer.MIN_VALUE).subtract(BigInteger.ONE), BigInteger.valueOf(-1L), BigInteger.ZERO, BigInteger.valueOf(1L), BigInteger.valueOf(Integer.MAX_VALUE).add(BigInteger.ONE), BigInteger.valueOf(Integer.MAX_VALUE).multiply(BigInteger.TEN));
    private static final ImmutableList<String> TEST_ENCODINGS = ImmutableList.of("_wAAAAE", "_3____8", "_w", "AA", "AQ", "AIAAAAA", "BP____Y");

    @Test
    public void testDecodeEncodeEqual() throws Exception {
        for (BigInteger value : TEST_VALUES) {
            CoderProperties.coderDecodeEncodeEqual(TEST_CODER, (Object)value);
        }
    }

    @Test
    public void testWireFormatEncode() throws Exception {
        CoderProperties.coderEncodesBase64(TEST_CODER, TEST_VALUES, TEST_ENCODINGS);
    }

    @Test
    public void testGetEncodedElementByteSize() throws Exception {
        CoderProperties.TestElementByteSizeObserver observer = new CoderProperties.TestElementByteSizeObserver();
        for (BigInteger value : TEST_VALUES) {
            TEST_CODER.registerByteSizeObserver((Object)value, (ElementByteSizeObserver)observer);
            observer.advance();
            Assert.assertThat((Object)observer.getSumAndReset(), (Matcher)Matchers.equalTo((Object)CoderUtils.encodeToByteArray(TEST_CODER, (Object)value, (Coder.Context)Coder.Context.NESTED).length));
        }
    }

    @Test
    public void encodeNullThrowsCoderException() throws Exception {
        this.thrown.expect(NullPointerException.class);
        this.thrown.expectMessage("cannot encode a null BigInteger");
        CoderUtils.encodeToBase64(TEST_CODER, null);
    }
}

