/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.math.BigDecimal;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.ImmutableList;
import org.apache.beam.sdk.coders.BigDecimalCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.testing.CoderProperties;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.util.common.ElementByteSizeObserver;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class BigDecimalCoderTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private static final Coder<BigDecimal> TEST_CODER = BigDecimalCoder.of();
    private static final ImmutableList<BigDecimal> TEST_VALUES = ImmutableList.of(new BigDecimal(Double.MIN_VALUE).divide(BigDecimal.TEN), new BigDecimal(Double.MIN_VALUE), new BigDecimal(-10.5), new BigDecimal(-1), BigDecimal.ZERO, BigDecimal.ONE, new BigDecimal(13.258), new BigDecimal(Double.MAX_VALUE), new BigDecimal(Double.MAX_VALUE).multiply(BigDecimal.TEN));
    private static final ImmutableList<String> TEST_ENCODINGS = ImmutableList.of("swg12KOw51bHBNnjNkPn-wPiaWQ_AsohTe-mXyOGWcybUGt9TKi2FHqY2OH-gV0_GWqRbjNAGsSskI7K3xf9JmTjf1ySZXuvF9S9PsgV3kT-sgypaRw_i1MK_orzcJVg_s3cEGTjTY1_Xor3JM9UBVKiQy3Vpulf7aN9LMkiQEfO28mXQibyUtXL4yoLIwujoo8ArC9SayfbH5HmUxX9G0e506_cefoYIGByfq3M8GLp1_METj97ViU38jexsXkggqxXrMG8PO6pCYNB8P_jcf9i5OagpPafem18giZ8-v3fWJPN63vkbuOtaHb9u9yGQfrN25aLpNW9ooU9eYbL-1ewSBwENptcIT5SMhkulcVY6e9LyAqamGWdvnbevpwW84rTQpkeJePOkIt6G1_slfkQn6VBw7Jz3Vk", "sgg12KOw51bHBNnjNkPn-wPiaWQ_AsohTe-mXyOGWcybUGt9TKi2FHqY2OH-gV0_GWqRbjNAGsSskI7K3xf9JmTjf1ySZXuvF9S9PsgV3kT-sgypaRw_i1MK_orzcJVg_s3cEGTjTY1_Xor3JM9UBVKiQy3Vpulf7aN9LMkiQEfO28mXQibyUtXL4yoLIwujoo8ArC9SayfbH5HmUxX9G0e506_cefoYIGByfq3M8GLp1_METj97ViU38jexsXkggqxXrMG8PO6pCYNB8P_jcf9i5OagpPafem18giZ8-v3fWJPN63vkbuOtaHb9u9yGQfrN25aLpNW9ooU9eYbL-1ewSBwENptcIT5SMhkulcVY6e9LyAqamGWdvnbevpwW84rTQpkeJePOkIt6G1_slfkQn6VBw7Jz3Vk", "AZc", "AP8", "AAA", "AAE", "MAkSTUgCATUf0ayu7f08NmBSpPU2dQ", "AAD________4AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA", "AAn_______-wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA");

    @Test
    public void testDecodeEncodeEqual() throws Exception {
        for (BigDecimal value : TEST_VALUES) {
            CoderProperties.coderDecodeEncodeEqual(TEST_CODER, (Object)value);
        }
    }

    @Test
    public void testWireFormatEncode() throws Exception {
        CoderProperties.coderEncodesBase64(TEST_CODER, TEST_VALUES, TEST_ENCODINGS);
    }

    @Test
    public void testGetEncodedElementByteSize() throws Exception {
        CoderProperties.TestElementByteSizeObserver observer = new CoderProperties.TestElementByteSizeObserver();
        for (BigDecimal value : TEST_VALUES) {
            TEST_CODER.registerByteSizeObserver((Object)value, (ElementByteSizeObserver)observer);
            observer.advance();
            Assert.assertThat((Object)observer.getSumAndReset(), (Matcher)Matchers.equalTo((Object)CoderUtils.encodeToByteArray(TEST_CODER, (Object)value, (Coder.Context)Coder.Context.NESTED).length));
        }
    }

    @Test
    public void encodeNullThrowsException() throws Exception {
        this.thrown.expect(NullPointerException.class);
        this.thrown.expectMessage("cannot encode a null BigDecimal");
        CoderUtils.encodeToBase64(TEST_CODER, null);
    }
}

