/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.reflect.AvroName;
import org.apache.avro.reflect.AvroSchema;
import org.apache.avro.reflect.Nullable;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.reflect.Stringable;
import org.apache.avro.reflect.Union;
import org.apache.avro.util.Utf8;
import org.apache.beam.sdk.coders.AvroCoder;
import org.apache.beam.sdk.coders.AvroCoderTestPojo;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.DefaultCoder;
import org.apache.beam.sdk.coders.SerializableCoder;
import org.apache.beam.sdk.testing.CoderProperties;
import org.apache.beam.sdk.testing.InterceptingUrlClassLoader;
import org.apache.beam.sdk.testing.NeedsRunner;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.util.InstanceBuilder;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.objenesis.strategy.InstantiatorStrategy;
import org.objenesis.strategy.StdInstantiatorStrategy;

@RunWith(value=JUnit4.class)
public class AvroCoderTest {
    @Rule
    public TestPipeline pipeline = TestPipeline.create();

    @Test
    public void testAvroCoderEncoding() throws Exception {
        AvroCoder coder = AvroCoder.of(Pojo.class);
        CoderProperties.coderSerializable((Coder)coder);
        AvroCoder copy = (AvroCoder)SerializableUtils.clone((Serializable)coder);
        Pojo pojo = new Pojo("foo", 3);
        Pojo equalPojo = new Pojo("foo", 3);
        Pojo otherPojo = new Pojo("bar", -19);
        CoderProperties.coderConsistentWithEquals((Coder)coder, (Object)pojo, (Object)equalPojo);
        CoderProperties.coderConsistentWithEquals((Coder)copy, (Object)pojo, (Object)equalPojo);
        CoderProperties.coderConsistentWithEquals((Coder)coder, (Object)pojo, (Object)otherPojo);
        CoderProperties.coderConsistentWithEquals((Coder)copy, (Object)pojo, (Object)otherPojo);
    }

    @Test
    public void testTwoClassLoaders() throws Exception {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        InterceptingUrlClassLoader loader1 = new InterceptingUrlClassLoader(contextClassLoader, AvroCoderTestPojo.class.getName());
        InterceptingUrlClassLoader loader2 = new InterceptingUrlClassLoader(contextClassLoader, AvroCoderTestPojo.class.getName());
        Class<?> pojoClass1 = ((ClassLoader)loader1).loadClass(AvroCoderTestPojo.class.getName());
        Class<?> pojoClass2 = ((ClassLoader)loader2).loadClass(AvroCoderTestPojo.class.getName());
        Object pojo1 = InstanceBuilder.ofType(pojoClass1).withArg(String.class, (Object)"hello").build();
        Object pojo2 = InstanceBuilder.ofType(pojoClass2).withArg(String.class, (Object)"goodbye").build();
        try {
            pojoClass2.cast(pojo1);
            Assert.fail((String)"Expected ClassCastException; without it, this test is vacuous");
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        AvroCoder avroCoder1 = AvroCoder.of(pojoClass1);
        AvroCoder avroCoder2 = AvroCoder.of(pojoClass2);
        Object cloned1 = CoderUtils.clone((Coder)avroCoder1, (Object)pojo1);
        Object cloned2 = CoderUtils.clone((Coder)avroCoder2, (Object)pojo2);
        pojoClass1.cast(cloned1);
        pojoClass2.cast(cloned2);
    }

    @Test
    public void testTransientFieldInitialization() throws Exception {
        Pojo value = new Pojo("Hello", 42);
        AvroCoder coder = AvroCoder.of(Pojo.class);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bos);
        out.writeObject(coder);
        ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
        ObjectInputStream in = new ObjectInputStream(bis);
        AvroCoder copied = (AvroCoder)in.readObject();
        CoderProperties.coderDecodeEncodeEqual((Coder)copied, (Object)value);
    }

    @Test
    public void testKryoSerialization() throws Exception {
        Pojo value = new Pojo("Hello", 42);
        AvroCoder coder = AvroCoder.of(Pojo.class);
        Kryo kryo = new Kryo();
        kryo.setInstantiatorStrategy((InstantiatorStrategy)new StdInstantiatorStrategy());
        ByteArrayOutputStream coderWithoutMemoizationBos = new ByteArrayOutputStream();
        try (Output output = new Output((OutputStream)coderWithoutMemoizationBos);){
            kryo.writeObject(output, (Object)coder);
        }
        CoderProperties.coderDecodeEncodeEqual((Coder)coder, (Object)value);
        ByteArrayOutputStream coderWithMemoizationBos = new ByteArrayOutputStream();
        try (Output output = new Output((OutputStream)coderWithMemoizationBos);){
            kryo.writeObject(output, (Object)coder);
        }
        ByteArrayInputStream bisWithoutMemoization = new ByteArrayInputStream(coderWithoutMemoizationBos.toByteArray());
        AvroCoder copiedWithoutMemoization = (AvroCoder)kryo.readObject(new Input((InputStream)bisWithoutMemoization), AvroCoder.class);
        ByteArrayInputStream bisWithMemoization = new ByteArrayInputStream(coderWithMemoizationBos.toByteArray());
        AvroCoder copiedWithMemoization = (AvroCoder)kryo.readObject(new Input((InputStream)bisWithMemoization), AvroCoder.class);
        CoderProperties.coderDecodeEncodeEqual((Coder)copiedWithoutMemoization, (Object)value);
        CoderProperties.coderDecodeEncodeEqual((Coder)copiedWithMemoization, (Object)value);
    }

    @Test
    public void testPojoEncoding() throws Exception {
        Pojo value = new Pojo("Hello", 42);
        AvroCoder coder = AvroCoder.of(Pojo.class);
        CoderProperties.coderDecodeEncodeEqual((Coder)coder, (Object)value);
    }

    @Test
    public void testGenericRecordEncoding() throws Exception {
        String schemaString = "{\"namespace\": \"example.avro\",\n \"type\": \"record\",\n \"name\": \"User\",\n \"fields\": [\n     {\"name\": \"name\", \"type\": \"string\"},\n     {\"name\": \"favorite_number\", \"type\": [\"int\", \"null\"]},\n     {\"name\": \"favorite_color\", \"type\": [\"string\", \"null\"]}\n ]\n}";
        Schema schema = new Schema.Parser().parse(schemaString);
        GenericData.Record before = new GenericData.Record(schema);
        before.put("name", (Object)"Bob");
        before.put("favorite_number", (Object)256);
        AvroCoder coder = AvroCoder.of(GenericRecord.class, (Schema)schema);
        CoderProperties.coderDecodeEncodeEqual((Coder)coder, (Object)before);
        Assert.assertEquals((Object)schema, (Object)coder.getSchema());
    }

    @Test
    public void testEncodingNotBuffered() throws Exception {
        Pojo before = new Pojo("Hello", 42);
        AvroCoder coder = AvroCoder.of(Pojo.class);
        SerializableCoder intCoder = SerializableCoder.of(Integer.class);
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        Coder.Context context = Coder.Context.NESTED;
        coder.encode((Object)before, (OutputStream)outStream, context);
        intCoder.encode((Object)10, (OutputStream)outStream, context);
        ByteArrayInputStream inStream = new ByteArrayInputStream(outStream.toByteArray());
        Pojo after = (Pojo)coder.decode((InputStream)inStream, context);
        Assert.assertEquals((Object)before, (Object)after);
        Integer intAfter = (Integer)intCoder.decode((InputStream)inStream, context);
        Assert.assertEquals((Object)10, (Object)intAfter);
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testDefaultCoder() throws Exception {
        PCollection output = (PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of((Object)new Pojo("hello", 1), (Object[])new Pojo[]{new Pojo("world", 2)}))).apply((PTransform)ParDo.of((DoFn)new GetTextFn()));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new String[]{"hello", "world"});
        this.pipeline.run();
    }

    @Test
    public void testAvroCoderIsSerializable() throws Exception {
        AvroCoder coder = AvroCoder.of(Pojo.class);
        SerializableUtils.ensureSerializable((Coder)coder);
    }

    private void assertDeterministic(AvroCoder<?> coder) {
        try {
            coder.verifyDeterministic();
        }
        catch (Coder.NonDeterministicException e) {
            Assert.fail((String)("Expected " + coder + " to be deterministic, but got:\n" + (Object)((Object)e)));
        }
    }

    private void assertNonDeterministic(AvroCoder<?> coder, Matcher<String> reason1) {
        try {
            coder.verifyDeterministic();
            Assert.fail((String)("Expected " + coder + " to be non-deterministic."));
        }
        catch (Coder.NonDeterministicException e) {
            Assert.assertThat((Object)e.getReasons(), (Matcher)Matchers.iterableWithSize((int)1));
            Assert.assertThat((Object)e.getReasons(), (Matcher)Matchers.contains(reason1));
        }
    }

    @Test
    public void testDeterministicInteger() {
        this.assertDeterministic(AvroCoder.of(Integer.class));
    }

    @Test
    public void testDeterministicInt() {
        this.assertDeterministic(AvroCoder.of(Integer.TYPE));
    }

    @Test
    public void testDeterministicSimple() {
        this.assertDeterministic(AvroCoder.of(SimpleDeterministicClass.class));
    }

    private Matcher<String> reason(final String prefix, final String messagePart) {
        return new TypeSafeMatcher<String>(String.class){

            public void describeTo(Description description) {
                description.appendText(String.format("Reason starting with '%s:' containing '%s'", prefix, messagePart));
            }

            protected boolean matchesSafely(String item) {
                return item.startsWith(prefix + ":") && item.contains(messagePart);
            }
        };
    }

    private Matcher<String> reasonClass(Class<?> clazz, String message) {
        return this.reason(clazz.getName(), message);
    }

    private Matcher<String> reasonField(Class<?> clazz, String field, String message) {
        return this.reason(clazz.getName() + "#" + field, message);
    }

    @Test
    public void testDeterministicUnorderedMap() {
        this.assertNonDeterministic(AvroCoder.of(UnorderedMapClass.class), this.reasonField(UnorderedMapClass.class, "mapField", "java.util.Map<java.lang.String, java.lang.String> may not be deterministically ordered"));
    }

    @Test
    public void testDeterministicNonDeterministicArray() {
        this.assertNonDeterministic(AvroCoder.of(NonDeterministicArray.class), this.reasonField(UnorderedMapClass.class, "mapField", "java.util.Map<java.lang.String, java.lang.String> may not be deterministically ordered"));
    }

    @Test
    public void testDeterministicNonDeterministicChild() {
        this.assertNonDeterministic(AvroCoder.of(SubclassOfUnorderedMapClass.class), this.reasonField(UnorderedMapClass.class, "mapField", "may not be deterministically ordered"));
    }

    @Test
    public void testAvroProhibitsShadowing() {
        try {
            ReflectData.get().getSchema(SubclassHidingParent.class);
            Assert.fail((String)"Expected AvroTypeException");
        }
        catch (AvroRuntimeException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"mapField"));
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"two fields named"));
        }
    }

    @Test
    public void testDeterministicWithAvroName() {
        this.assertDeterministic(AvroCoder.of(FieldWithAvroName.class));
    }

    @Test
    public void testDeterminismSortedMap() {
        this.assertDeterministic(AvroCoder.of(StringSortedMapField.class));
    }

    @Test
    public void testDeterminismTreeMapValue() {
        this.assertNonDeterministic(AvroCoder.of(TreeMapNonDetValue.class), this.reasonField(UnorderedMapClass.class, "mapField", "java.util.Map<java.lang.String, java.lang.String> may not be deterministically ordered"));
    }

    @Test
    public void testDeterminismUnorderedMap() {
        this.assertNonDeterministic(AvroCoder.of(LinkedHashMapField.class), this.reasonField(LinkedHashMapField.class, "nonDeterministicMap", "java.util.LinkedHashMap<java.lang.String, java.lang.String> may not be deterministically ordered"));
    }

    @Test
    public void testDeterminismCollection() {
        this.assertNonDeterministic(AvroCoder.of(StringCollection.class), this.reasonField(StringCollection.class, "stringCollection", "java.util.Collection<java.lang.String> may not be deterministically ordered"));
    }

    @Test
    public void testDeterminismList() {
        this.assertDeterministic(AvroCoder.of(StringList.class));
        this.assertDeterministic(AvroCoder.of(StringArrayList.class));
    }

    @Test
    public void testDeterminismSet() {
        this.assertDeterministic(AvroCoder.of(StringSortedSet.class));
        this.assertDeterministic(AvroCoder.of(StringTreeSet.class));
        this.assertNonDeterministic(AvroCoder.of(StringHashSet.class), this.reasonField(StringHashSet.class, "stringCollection", "java.util.HashSet<java.lang.String> may not be deterministically ordered"));
    }

    @Test
    public void testDeterminismCollectionValue() {
        this.assertNonDeterministic(AvroCoder.of(OrderedSetOfNonDetValues.class), this.reasonField(UnorderedMapClass.class, "mapField", "may not be deterministically ordered"));
        this.assertNonDeterministic(AvroCoder.of(ListOfNonDetValues.class), this.reasonField(UnorderedMapClass.class, "mapField", "may not be deterministically ordered"));
    }

    @Test
    public void testDeterminismUnion() {
        this.assertDeterministic(AvroCoder.of(DeterministicUnionBase.class));
        this.assertNonDeterministic(AvroCoder.of(NonDeterministicUnionBase.class), this.reasonField(UnionCase3.class, "mapField", "may not be deterministically ordered"));
    }

    @Test
    public void testDeterminismStringable() {
        this.assertDeterministic(AvroCoder.of(String.class));
        this.assertNonDeterministic(AvroCoder.of(StringableClass.class), this.reasonClass(StringableClass.class, "may not have deterministic #toString()"));
    }

    @Test
    public void testDeterminismCyclicClass() {
        this.assertNonDeterministic(AvroCoder.of(Cyclic.class), this.reasonField(Cyclic.class, "cyclicField", "appears recursively"));
        this.assertNonDeterministic(AvroCoder.of(CyclicField.class), this.reasonField(Cyclic.class, "cyclicField", Cyclic.class.getName() + " appears recursively"));
        this.assertNonDeterministic(AvroCoder.of(IndirectCycle1.class), this.reasonField(IndirectCycle2.class, "field2", IndirectCycle1.class.getName() + " appears recursively"));
    }

    @Test
    public void testDeterminismHasGenericRecord() {
        this.assertDeterministic(AvroCoder.of(HasGenericRecord.class));
    }

    @Test
    public void testDeterminismHasCustomSchema() {
        this.assertNonDeterministic(AvroCoder.of(HasCustomSchema.class), this.reasonField(HasCustomSchema.class, "withCustomSchema", "Custom schemas are only supported for subtypes of IndexedRecord."));
    }

    @Test
    public void testAvroCoderTreeMapDeterminism() throws Exception, Coder.NonDeterministicException {
        TreeMapField size1 = new TreeMapField();
        TreeMapField size2 = new TreeMapField();
        size1.field.put("hello", "world");
        size1.field.put("another", "entry");
        size2.field.put("another", "entry");
        size2.field.put("hello", "world");
        AvroCoder coder = AvroCoder.of(TreeMapField.class);
        coder.verifyDeterministic();
        ByteArrayOutputStream outStream1 = new ByteArrayOutputStream();
        ByteArrayOutputStream outStream2 = new ByteArrayOutputStream();
        Coder.Context context = Coder.Context.NESTED;
        coder.encode((Object)size1, (OutputStream)outStream1, context);
        coder.encode((Object)size2, (OutputStream)outStream2, context);
        Assert.assertTrue((boolean)Arrays.equals(outStream1.toByteArray(), outStream2.toByteArray()));
    }

    @Test
    public void testAvroCoderSimpleSchemaDeterminism() {
        this.assertDeterministic(AvroCoder.of((Schema)((Schema)SchemaBuilder.record((String)"someRecord").fields().endRecord())));
        this.assertDeterministic(AvroCoder.of((Schema)((Schema)SchemaBuilder.record((String)"someRecord").fields().name("int").type().intType().noDefault().endRecord())));
        this.assertDeterministic(AvroCoder.of((Schema)((Schema)SchemaBuilder.record((String)"someRecord").fields().name("string").type().stringType().noDefault().endRecord())));
        this.assertNonDeterministic(AvroCoder.of((Schema)((Schema)((SchemaBuilder.MapDefault)SchemaBuilder.record((String)"someRecord").fields().name("map").type().map().values().stringType()).noDefault().endRecord())), this.reason("someRecord.map", "HashMap to represent MAPs"));
        this.assertDeterministic(AvroCoder.of((Schema)((Schema)((SchemaBuilder.ArrayDefault)SchemaBuilder.record((String)"someRecord").fields().name("array").type().array().items().stringType()).noDefault().endRecord())));
        this.assertDeterministic(AvroCoder.of((Schema)((Schema)((SchemaBuilder.EnumDefault)SchemaBuilder.record((String)"someRecord").fields().name("enum").type().enumeration("anEnum").symbols(new String[]{"s1", "s2"})).enumDefault("s1").endRecord())));
        this.assertDeterministic(AvroCoder.of((Schema)((Schema)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)SchemaBuilder.unionOf().intType()).and().record("someRecord").fields().nullableString("someField", "").endRecord()).endUnion())));
    }

    @Test
    public void testAvroCoderStrings() {
        this.assertDeterministic(AvroCoder.of((Schema)((Schema)((SchemaBuilder.FieldBuilder)SchemaBuilder.record((String)"someRecord").fields().name("string").prop("java-class", "java.lang.String")).type().stringType().noDefault().endRecord())));
        this.assertNonDeterministic(AvroCoder.of((Schema)((Schema)((SchemaBuilder.FieldBuilder)SchemaBuilder.record((String)"someRecord").fields().name("string").prop("java-class", "unknownString")).type().stringType().noDefault().endRecord())), this.reason("someRecord.string", "unknownString is not known to be deterministic"));
        this.assertNonDeterministic(AvroCoder.of((Schema)((Schema)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.FieldBuilder)((SchemaBuilder.UnionAccumulator)SchemaBuilder.unionOf().intType()).and().record("someRecord").fields().name("someField").prop("java-class", "unknownString")).type().stringType().noDefault().endRecord()).endUnion())), this.reason("someRecord.someField", "unknownString is not known to be deterministic"));
    }

    @Test
    public void testAvroCoderNestedRecords() {
        this.assertDeterministic(AvroCoder.of((Schema)((Schema)((SchemaBuilder.RecordDefault)SchemaBuilder.record((String)"nestedRecord").fields().name("subRecord").type().record("subRecord").fields().name("innerField").type().stringType().noDefault().endRecord()).noDefault().endRecord())));
    }

    @Test
    public void testAvroCoderCyclicRecords() {
        this.assertNonDeterministic(AvroCoder.of((Schema)((Schema)SchemaBuilder.record((String)"cyclicRecord").fields().name("cycle").type("cyclicRecord").noDefault().endRecord())), this.reason("cyclicRecord.cycle", "cyclicRecord appears recursively"));
    }

    @Test
    public void testNullableField() {
        this.assertDeterministic(AvroCoder.of(NullableField.class));
    }

    @Test
    public void testNullableNonDeterministicField() {
        this.assertNonDeterministic(AvroCoder.of(NullableCyclic.class), this.reasonField(NullableCyclic.class, "nullableNullableCyclicField", NullableCyclic.class.getName() + " appears recursively"));
        this.assertNonDeterministic(AvroCoder.of(NullableCyclicField.class), this.reasonField(Cyclic.class, "cyclicField", Cyclic.class.getName() + " appears recursively"));
        this.assertNonDeterministic(AvroCoder.of(NullableNonDeterministicField.class), this.reasonField(UnorderedMapClass.class, "mapField", " may not be deterministically ordered"));
    }

    @Test
    public void testGenericClassWithUnionAnnotation() throws Exception {
        AvroCoder coder = AvroCoder.of(GenericWithAnnotation.class);
        Assert.assertThat((Object)coder.getSchema().getField("onlySomeTypesAllowed").schema().getType(), (Matcher)Matchers.equalTo((Object)Schema.Type.UNION));
        CoderProperties.coderDecodeEncodeEqual((Coder)coder, new GenericWithAnnotation<String>("hello"));
    }

    @Test
    public void testAvroCoderForGenerics() throws Exception {
        Schema fooSchema = AvroCoder.of(Foo.class).getSchema();
        Schema schema = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"SomeGeneric\",\"namespace\":\"ns\",\"fields\":[  {\"name\":\"foo\", \"type\":" + fooSchema.toString() + "}]}");
        AvroCoder coder = AvroCoder.of(SomeGeneric.class, (Schema)schema);
        this.assertNonDeterministic(coder, this.reasonField(SomeGeneric.class, "foo", "erasure"));
    }

    @Test
    public void testEncodedTypeDescriptor() throws Exception {
        AvroCoder coder = AvroCoder.of(Pojo.class);
        Assert.assertThat((Object)coder.getEncodedTypeDescriptor(), (Matcher)Matchers.equalTo((Object)TypeDescriptor.of(Pojo.class)));
    }

    private static class Foo {
        String id;

        private Foo() {
        }
    }

    private static class SomeGeneric<T> {
        private T foo;

        private SomeGeneric() {
        }
    }

    private static class GenericWithAnnotation<T> {
        @AvroSchema(value="[\"string\", \"int\"]")
        private T onlySomeTypesAllowed;

        public GenericWithAnnotation(T value) {
            this.onlySomeTypesAllowed = value;
        }

        protected GenericWithAnnotation() {
        }

        public boolean equals(Object other) {
            return other instanceof GenericWithAnnotation && this.onlySomeTypesAllowed.equals(((GenericWithAnnotation)other).onlySomeTypesAllowed);
        }

        public int hashCode() {
            return Objects.hash(this.getClass(), this.onlySomeTypesAllowed);
        }
    }

    private static class NullableCyclicField {
        @Nullable
        private Cyclic nullableCyclicField;

        private NullableCyclicField() {
        }
    }

    private static class NullableCyclic {
        @Nullable
        private NullableCyclic nullableNullableCyclicField;

        private NullableCyclic() {
        }
    }

    private static class NullableNonDeterministicField {
        @Nullable
        private NonDeterministicArray nullableNonDetArray;

        private NullableNonDeterministicField() {
        }
    }

    private static class NullableField {
        @Nullable
        private String nullable;

        private NullableField() {
        }
    }

    private static class UnionCase3
    extends NonDeterministicUnionBase {
        private Map<String, String> mapField;

        private UnionCase3() {
        }
    }

    private static class UnionCase2
    extends DeterministicUnionBase {
        String field;

        private UnionCase2() {
        }
    }

    private static class UnionCase1
    extends DeterministicUnionBase {
        private UnionCase1() {
        }
    }

    @Union(value={UnionCase1.class, UnionCase2.class, UnionCase3.class})
    private static abstract class NonDeterministicUnionBase {
        private NonDeterministicUnionBase() {
        }
    }

    @Union(value={UnionCase1.class, UnionCase2.class})
    private static abstract class DeterministicUnionBase {
        private DeterministicUnionBase() {
        }
    }

    private static class TreeMapField {
        private TreeMap<String, String> field = new TreeMap();

        private TreeMapField() {
        }
    }

    private static class HasCustomSchema {
        @AvroSchema(value="{\"name\": \"bar\", \"type\": \"record\", \"fields\": [{\"name\": \"foo\", \"type\": \"int\"}]}")
        int withCustomSchema;

        private HasCustomSchema() {
        }
    }

    private static class HasGenericRecord {
        @AvroSchema(value="{\"name\": \"bar\", \"type\": \"record\", \"fields\": [{\"name\": \"foo\", \"type\": \"int\"}]}")
        GenericRecord genericRecord;

        private HasGenericRecord() {
        }
    }

    private static class IndirectCycle2 {
        IndirectCycle1 field2;

        private IndirectCycle2() {
        }
    }

    private static class IndirectCycle1 {
        IndirectCycle2 field1;

        private IndirectCycle1() {
        }
    }

    private static class CyclicField {
        Cyclic cyclicField2;

        private CyclicField() {
        }
    }

    private static class Cyclic {
        int intField;
        Cyclic cyclicField;

        private Cyclic() {
        }
    }

    @Stringable
    private static class StringableClass {
        private StringableClass() {
        }
    }

    private static class ListOfNonDetValues {
        List<UnorderedMapClass> set;

        private ListOfNonDetValues() {
        }
    }

    private static class OrderedSetOfNonDetValues {
        SortedSet<UnorderedMapClass> set;

        private OrderedSetOfNonDetValues() {
        }
    }

    private static class StringHashSet {
        HashSet<String> stringCollection;

        private StringHashSet() {
        }
    }

    private static class StringTreeSet {
        TreeSet<String> stringCollection;

        private StringTreeSet() {
        }
    }

    private static class StringSortedSet {
        SortedSet<String> stringCollection;

        private StringSortedSet() {
        }
    }

    private static class StringArrayList {
        ArrayList<String> stringCollection;

        private StringArrayList() {
        }
    }

    private static class StringList {
        List<String> stringCollection;

        private StringList() {
        }
    }

    private static class StringCollection {
        Collection<String> stringCollection;

        private StringCollection() {
        }
    }

    private static class LinkedHashMapField {
        LinkedHashMap<String, String> nonDeterministicMap;

        private LinkedHashMapField() {
        }
    }

    private static class TreeMapNonDetValue {
        TreeMap<String, NonDeterministicArray> nonDeterministicField;

        private TreeMapNonDetValue() {
        }
    }

    private static class StringSortedMapField {
        SortedMap<String, String> sortedMapField;

        private StringSortedMapField() {
        }
    }

    private static class FieldWithAvroName {
        @AvroName(value="name")
        private int someField;

        private FieldWithAvroName() {
        }
    }

    private static class SubclassHidingParent
    extends UnorderedMapClass {
        @AvroName(value="mapField2")
        private int mapField;

        private SubclassHidingParent() {
        }
    }

    private static class SubclassOfUnorderedMapClass
    extends UnorderedMapClass {
        private SubclassOfUnorderedMapClass() {
        }
    }

    private static class NonDeterministicArray {
        private UnorderedMapClass[] arrayField;

        private NonDeterministicArray() {
        }
    }

    private static class UnorderedMapClass {
        private Map<String, String> mapField;

        private UnorderedMapClass() {
        }
    }

    private static class SimpleDeterministicClass {
        private Integer intField;
        private char charField;
        private Integer[] intArray;
        private Utf8 utf8field;

        private SimpleDeterministicClass() {
        }
    }

    private static class GetTextFn
    extends DoFn<Pojo, String> {
        private GetTextFn() {
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) {
            c.output((Object)((Pojo)c.element()).text);
        }
    }

    @DefaultCoder(value=AvroCoder.class)
    private static class Pojo {
        public String text;
        public int count;

        public Pojo() {
        }

        public Pojo(String text, int count) {
            this.text = text;
            this.count = count;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Pojo pojo = (Pojo)o;
            if (this.count != pojo.count) {
                return false;
            }
            return !(this.text != null ? !this.text.equals(pojo.text) : pojo.text != null);
        }

        public int hashCode() {
            return 0;
        }

        public String toString() {
            return "Pojo{text='" + this.text + '\'' + ", count=" + this.count + '}';
        }
    }
}

