/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.ImmutableList;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.Iterables;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.PipelineRunner;
import org.apache.beam.sdk.io.GenerateSequence;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.runners.PTransformMatcher;
import org.apache.beam.sdk.runners.PTransformOverride;
import org.apache.beam.sdk.runners.PTransformOverrideFactory;
import org.apache.beam.sdk.runners.TransformHierarchy;
import org.apache.beam.sdk.testing.CrashingRunner;
import org.apache.beam.sdk.testing.ExpectedLogs;
import org.apache.beam.sdk.testing.NeedsRunner;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.testing.ValidatesRunner;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.Flatten;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.Max;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.Sum;
import org.apache.beam.sdk.util.UserCodeException;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TaggedPValue;
import org.apache.beam.sdk.values.TupleTag;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class PipelineTest {
    @Rule
    public final TestPipeline pipeline = TestPipeline.create();
    @Rule
    public ExpectedLogs logged = ExpectedLogs.none(Pipeline.class);
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testConflictingNames() {
        PipelineOptions options = TestPipeline.testingPipelineOptions();
        Pipeline p = Pipeline.create((PipelineOptions)options);
        this.thrown.expect(IllegalStateException.class);
        this.thrown.expectMessage((Matcher)new BaseMatcher<String>(){

            public void describeTo(Description description) {
                description.appendText("validates the conflicting instances are listed into the exception message");
            }

            public boolean matches(Object o) {
                String sanitized = ((String)String.class.cast(o)).replaceAll("\\$[\\p{Alnum}]+@[\\p{Alnum}]+", "\\$x@y");
                return sanitized.contains("Conflicting instances:\n- name=ParDo(Anonymous):\n    - org.apache.beam.sdk.PipelineTest$x@y\n    - org.apache.beam.sdk.PipelineTest$x@y\n\nYou can fix it adding a name when you call apply(): pipeline.apply(<name>, <transform>).");
            }
        });
        ((PCollection)((PCollection)p.apply((PTransform)Create.of((Object)"a", (Object[])new String[0]))).apply((PTransform)ParDo.of((DoFn)new DoFn<String, String>(){

            @DoFn.ProcessElement
            public void onElement(DoFn.ProcessContext ctx) {
                ctx.output((Object)((String)ctx.element()));
            }
        }))).apply((PTransform)ParDo.of((DoFn)new DoFn<String, String>(){

            @DoFn.ProcessElement
            public void onElement(DoFn.ProcessContext ctx) {
            }
        }));
        p.run();
    }

    @Test
    public void testPipelineUserExceptionHandling() {
        PipelineOptions options = TestPipeline.testingPipelineOptions();
        options.setRunner(TestPipelineRunnerThrowingUserException.class);
        Pipeline p = Pipeline.create((PipelineOptions)options);
        this.thrown.expect(Pipeline.PipelineExecutionException.class);
        this.thrown.expectCause(Matchers.isA(IllegalStateException.class));
        this.thrown.expectMessage("user code exception");
        p.run();
    }

    @Test
    public void testPipelineSDKExceptionHandling() {
        PipelineOptions options = TestPipeline.testingPipelineOptions();
        options.setRunner(TestPipelineRunnerThrowingSdkException.class);
        Pipeline p = Pipeline.create((PipelineOptions)options);
        try {
            p.run();
            Assert.fail((String)"Should have thrown an exception.");
        }
        catch (RuntimeException exn) {
            Assert.assertThat((Object)exn, (Matcher)Matchers.not((Matcher)Matchers.instanceOf(UserCodeException.class)));
            Assert.assertThat((Object)exn.getMessage(), (Matcher)Matchers.containsString((String)"SDK exception"));
            Assert.assertThat((Object)exn, (Matcher)Matchers.instanceOf(IllegalStateException.class));
        }
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testMultipleApply() {
        PTransform<PCollection<? extends String>, PCollection<String>> myTransform = PipelineTest.addSuffix("+");
        PCollection input = (PCollection)this.pipeline.apply((PTransform)Create.of(ImmutableList.of("a", "b")));
        PCollection left = (PCollection)((PCollection)input.apply("Left1", myTransform)).apply("Left2", myTransform);
        PCollection right = (PCollection)input.apply("Right", myTransform);
        PCollection both = (PCollection)PCollectionList.of((PCollection)left).and(right).apply((PTransform)Flatten.pCollections());
        PAssert.that((PCollection)both).containsInAnyOrder((Object[])new String[]{"a++", "b++", "a+", "b+"});
        this.pipeline.run();
    }

    private static PTransform<PCollection<? extends String>, PCollection<String>> addSuffix(final String suffix) {
        return MapElements.via((SimpleFunction)new SimpleFunction<String, String>(){

            public String apply(String input) {
                return input + suffix;
            }
        });
    }

    @Test
    public void testToString() {
        PipelineOptions options = PipelineOptionsFactory.as(PipelineOptions.class);
        options.setRunner(CrashingRunner.class);
        Pipeline pipeline = Pipeline.create((PipelineOptions)options);
        Assert.assertEquals((Object)("Pipeline#" + pipeline.hashCode()), (Object)pipeline.toString());
    }

    @Test
    public void testStableUniqueNameOff() {
        this.pipeline.enableAbandonedNodeEnforcement(false);
        this.pipeline.getOptions().setStableUniqueNames(PipelineOptions.CheckEnabled.OFF);
        this.pipeline.apply((PTransform)Create.of((Object)5, (Object[])new Integer[]{6, 7}));
        this.pipeline.apply((PTransform)Create.of((Object)5, (Object[])new Integer[]{6, 7}));
        this.pipeline.validate(this.pipeline.getOptions());
        this.logged.verifyNotLogged("do not have stable unique names");
    }

    @Test
    public void testStableUniqueNameWarning() {
        this.pipeline.enableAbandonedNodeEnforcement(false);
        this.pipeline.getOptions().setStableUniqueNames(PipelineOptions.CheckEnabled.WARNING);
        this.pipeline.apply((PTransform)Create.of((Object)5, (Object[])new Integer[]{6, 7}));
        this.pipeline.apply((PTransform)Create.of((Object)5, (Object[])new Integer[]{6, 7}));
        this.pipeline.validate(this.pipeline.getOptions());
        this.logged.verifyWarn("do not have stable unique names");
    }

    @Test
    public void testStableUniqueNameError() {
        this.pipeline.getOptions().setStableUniqueNames(PipelineOptions.CheckEnabled.ERROR);
        this.pipeline.apply((PTransform)Create.of((Object)5, (Object[])new Integer[]{6, 7}));
        this.thrown.expectMessage("do not have stable unique names");
        this.pipeline.apply((PTransform)Create.of((Object)5, (Object[])new Integer[]{6, 7}));
        this.pipeline.validate(this.pipeline.getOptions());
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testIdentityTransform() throws Exception {
        PCollection output = (PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of((Object)1, (Object[])new Integer[]{2, 3, 4}))).apply("IdentityTransform", new IdentityTransform());
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new Integer[]{1, 2, 3, 4});
        this.pipeline.run();
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testTupleProjectionTransform() throws Exception {
        PCollection input = (PCollection)this.pipeline.apply((PTransform)Create.of((Object)1, (Object[])new Integer[]{2, 3, 4}));
        TupleTag tag = new TupleTag();
        PCollectionTuple tuple = PCollectionTuple.of((TupleTag)tag, (PCollection)input);
        PCollection output = (PCollection)tuple.apply("ProjectTag", new TupleProjectionTransform(tag));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new Integer[]{1, 2, 3, 4});
        this.pipeline.run();
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testTupleInjectionTransform() throws Exception {
        PCollection input = (PCollection)this.pipeline.apply((PTransform)Create.of((Object)1, (Object[])new Integer[]{2, 3, 4}));
        TupleTag tag = new TupleTag();
        PCollectionTuple output = (PCollectionTuple)input.apply("ProjectTag", new TupleInjectionTransform(tag));
        PAssert.that((PCollection)output.get(tag)).containsInAnyOrder((Object[])new Integer[]{1, 2, 3, 4});
        this.pipeline.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testEmptyPipeline() throws Exception {
        this.pipeline.run();
    }

    @Test
    public void testReplaceAll() {
        this.pipeline.enableAbandonedNodeEnforcement(false);
        this.pipeline.apply("unbounded", (PTransform)GenerateSequence.from((long)0L));
        this.pipeline.apply("bounded", (PTransform)GenerateSequence.from((long)0L).to(100L));
        this.pipeline.replaceAll(ImmutableList.of(PTransformOverride.of(application -> application.getTransform() instanceof GenerateSequence, (PTransformOverrideFactory)new GenerateSequenceToCreateOverride()), PTransformOverride.of(application -> application.getTransform() instanceof Create.Values, new CreateValuesToEmptyFlattenOverride())));
        this.pipeline.traverseTopologically((Pipeline.PipelineVisitor)new Pipeline.PipelineVisitor.Defaults(){

            public Pipeline.PipelineVisitor.CompositeBehavior enterCompositeTransform(TransformHierarchy.Node node) {
                if (!node.isRootNode()) {
                    Assert.assertThat(node.getTransform().getClass(), (Matcher)Matchers.not((Matcher)Matchers.anyOf((Matcher)Matchers.equalTo(GenerateSequence.class), (Matcher)Matchers.equalTo(Create.Values.class))));
                }
                return Pipeline.PipelineVisitor.CompositeBehavior.ENTER_TRANSFORM;
            }
        });
    }

    @Test
    public void testReplaceAllIncomplete() {
        this.pipeline.enableAbandonedNodeEnforcement(false);
        this.pipeline.apply((PTransform)GenerateSequence.from((long)0L));
        this.thrown.expect(IllegalStateException.class);
        this.pipeline.replaceAll(ImmutableList.of(PTransformOverride.of(application -> application.getTransform() instanceof Create.Values, new CreateValuesToEmptyFlattenOverride()), PTransformOverride.of(application -> application.getTransform() instanceof GenerateSequence, (PTransformOverrideFactory)new GenerateSequenceToCreateOverride())));
    }

    @Test
    public void testReplaceWithExistingName() {
        this.pipeline.enableAbandonedNodeEnforcement(false);
        final PCollection originalInput = (PCollection)this.pipeline.apply((PTransform)Create.of((Object)1, (Object[])new Integer[]{2, 3}));
        class OriginalTransform
        extends PTransform<PCollection<Integer>, PCollection<Integer>> {
            OriginalTransform() {
            }

            public PCollection<Integer> expand(PCollection<Integer> input) {
                return (PCollection)input.apply("custom_name", (PTransform)Sum.integersGlobally());
            }
        }
        originalInput.apply("original_application", (PTransform)new OriginalTransform());
        class OriginalMatcher
        implements PTransformMatcher {
            OriginalMatcher() {
            }

            public boolean matches(AppliedPTransform<?, ?, ?> application) {
                return application.getTransform() instanceof OriginalTransform;
            }
        }
        class ReplacementOverrideFactory
        implements PTransformOverrideFactory<PCollection<Integer>, PCollection<Integer>, OriginalTransform> {
            ReplacementOverrideFactory() {
            }

            public PTransformOverrideFactory.PTransformReplacement<PCollection<Integer>, PCollection<Integer>> getReplacementTransform(AppliedPTransform<PCollection<Integer>, PCollection<Integer>, OriginalTransform> transform) {
                class ReplacementTransform
                extends PTransform<PCollection<Integer>, PCollection<Integer>> {
                    ReplacementTransform() {
                    }

                    public PCollection<Integer> expand(PCollection<Integer> input) {
                        return (PCollection)input.apply("custom_name", (PTransform)Max.integersGlobally());
                    }
                }
                return PTransformOverrideFactory.PTransformReplacement.of((PInput)originalInput, (PTransform)new ReplacementTransform());
            }

            public Map<PValue, PTransformOverrideFactory.ReplacementOutput> mapOutputs(Map<TupleTag<?>, PValue> outputs, PCollection<Integer> newOutput) {
                return Collections.singletonMap(newOutput, PTransformOverrideFactory.ReplacementOutput.of((TaggedPValue)TaggedPValue.ofExpandedValue((PValue)Iterables.getOnlyElement(outputs.values())), (TaggedPValue)TaggedPValue.ofExpandedValue(newOutput)));
            }
        }
        this.pipeline.replaceAll(Collections.singletonList(PTransformOverride.of((PTransformMatcher)new OriginalMatcher(), (PTransformOverrideFactory)new ReplacementOverrideFactory())));
        final HashMap nameToTransformClass = new HashMap();
        this.pipeline.traverseTopologically((Pipeline.PipelineVisitor)new Pipeline.PipelineVisitor.Defaults(){

            public void leaveCompositeTransform(TransformHierarchy.Node node) {
                if (!node.isRootNode()) {
                    nameToTransformClass.put(node.getFullName(), node.getTransform().getClass());
                }
            }

            public void visitPrimitiveTransform(TransformHierarchy.Node node) {
                nameToTransformClass.put(node.getFullName(), node.getTransform().getClass());
            }
        });
        Assert.assertThat(nameToTransformClass.keySet(), (Matcher)Matchers.hasItem((Object)"original_application/custom_name"));
        Assert.assertThat(nameToTransformClass.keySet(), (Matcher)Matchers.not((Matcher)Matchers.hasItem((Object)"original_application/custom_name2")));
        Assert.assertEquals(nameToTransformClass.get("original_application/custom_name"), Max.integersGlobally().getClass());
    }

    static class CreateValuesToEmptyFlattenOverride<T>
    implements PTransformOverrideFactory<PBegin, PCollection<T>, Create.Values<T>> {
        CreateValuesToEmptyFlattenOverride() {
        }

        public PTransformOverrideFactory.PTransformReplacement<PBegin, PCollection<T>> getReplacementTransform(AppliedPTransform<PBegin, PCollection<T>, Create.Values<T>> transform) {
            return PTransformOverrideFactory.PTransformReplacement.of((PInput)transform.getPipeline().begin(), new EmptyFlatten());
        }

        public Map<PValue, PTransformOverrideFactory.ReplacementOutput> mapOutputs(Map<TupleTag<?>, PValue> outputs, PCollection<T> newOutput) {
            Map.Entry<TupleTag<?>, PValue> original = Iterables.getOnlyElement(outputs.entrySet());
            Map.Entry replacement = Iterables.getOnlyElement(newOutput.expand().entrySet());
            return Collections.singletonMap(newOutput, PTransformOverrideFactory.ReplacementOutput.of((TaggedPValue)TaggedPValue.of(original.getKey(), (PValue)original.getValue()), (TaggedPValue)TaggedPValue.of((TupleTag)((TupleTag)replacement.getKey()), (PValue)((PValue)replacement.getValue()))));
        }
    }

    private static class EmptyFlatten<T>
    extends PTransform<PBegin, PCollection<T>> {
        private EmptyFlatten() {
        }

        public PCollection<T> expand(PBegin input) {
            PCollectionList empty = PCollectionList.empty((Pipeline)input.getPipeline());
            return (PCollection)empty.apply((PTransform)Flatten.pCollections());
        }
    }

    static class GenerateSequenceToCreateOverride
    implements PTransformOverrideFactory<PBegin, PCollection<Long>, GenerateSequence> {
        GenerateSequenceToCreateOverride() {
        }

        public PTransformOverrideFactory.PTransformReplacement<PBegin, PCollection<Long>> getReplacementTransform(AppliedPTransform<PBegin, PCollection<Long>, GenerateSequence> transform) {
            return PTransformOverrideFactory.PTransformReplacement.of((PInput)transform.getPipeline().begin(), (PTransform)Create.of((Object)0L, (Object[])new Long[0]));
        }

        public Map<PValue, PTransformOverrideFactory.ReplacementOutput> mapOutputs(Map<TupleTag<?>, PValue> outputs, PCollection<Long> newOutput) {
            Map.Entry<TupleTag<?>, PValue> original = Iterables.getOnlyElement(outputs.entrySet());
            Map.Entry replacement = Iterables.getOnlyElement(newOutput.expand().entrySet());
            return Collections.singletonMap(newOutput, PTransformOverrideFactory.ReplacementOutput.of((TaggedPValue)TaggedPValue.of(original.getKey(), (PValue)original.getValue()), (TaggedPValue)TaggedPValue.of((TupleTag)((TupleTag)replacement.getKey()), (PValue)((PValue)replacement.getValue()))));
        }
    }

    private static class TupleInjectionTransform<T>
    extends PTransform<PCollection<T>, PCollectionTuple> {
        private TupleTag<T> tag;

        public TupleInjectionTransform(TupleTag<T> tag) {
            this.tag = tag;
        }

        public PCollectionTuple expand(PCollection<T> input) {
            return PCollectionTuple.of(this.tag, input);
        }
    }

    private static class TupleProjectionTransform<T>
    extends PTransform<PCollectionTuple, PCollection<T>> {
        private TupleTag<T> tag;

        public TupleProjectionTransform(TupleTag<T> tag) {
            this.tag = tag;
        }

        public PCollection<T> expand(PCollectionTuple input) {
            return input.get(this.tag);
        }
    }

    private static class IdentityTransform<T extends PInput & POutput>
    extends PTransform<T, T> {
        private IdentityTransform() {
        }

        public T expand(T input) {
            return input;
        }
    }

    static class TestPipelineRunnerThrowingSdkException
    extends PipelineRunner<PipelineResult> {
        TestPipelineRunnerThrowingSdkException() {
        }

        public static TestPipelineRunnerThrowingSdkException fromOptions(PipelineOptions options) {
            return new TestPipelineRunnerThrowingSdkException();
        }

        public PipelineResult run(Pipeline pipeline) {
            throw new IllegalStateException("SDK exception");
        }
    }

    static class TestPipelineRunnerThrowingUserException
    extends PipelineRunner<PipelineResult> {
        TestPipelineRunnerThrowingUserException() {
        }

        public static TestPipelineRunnerThrowingUserException fromOptions(PipelineOptions options) {
            return new TestPipelineRunnerThrowingUserException();
        }

        public PipelineResult run(Pipeline pipeline) {
            IllegalStateException t = new IllegalStateException("user code exception");
            throw UserCodeException.wrap((Throwable)t);
        }
    }
}

