/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.implementation.bytecode.member;

import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.build.HashCodeAndEqualsPlugin;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.implementation.Implementation;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.implementation.bytecode.StackManipulation;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.jar.asm.MethodVisitor;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.utility.JavaConstant;

@HashCodeAndEqualsPlugin.Enhance
public class HandleInvocation
implements StackManipulation {
    private static final String METHOD_HANDLE_NAME = "java/lang/invoke/MethodHandle";
    private static final String INVOKE_EXACT = "invokeExact";
    private final JavaConstant.MethodType methodType;

    public HandleInvocation(JavaConstant.MethodType methodType) {
        this.methodType = methodType;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
        methodVisitor.visitMethodInsn(182, METHOD_HANDLE_NAME, INVOKE_EXACT, this.methodType.getDescriptor(), false);
        int size = this.methodType.getReturnType().getStackSize().getSize() - this.methodType.getParameterTypes().getStackSize();
        return new StackManipulation.Size(size, Math.max(size, 0));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        return this.methodType.equals(((HandleInvocation)object).methodType);
    }

    public int hashCode() {
        return 17 * 31 + this.methodType.hashCode();
    }
}

