/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.implementation.bytecode.constant;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.build.HashCodeAndEqualsPlugin;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.description.method.MethodDescription;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.description.type.TypeDescription;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.implementation.Implementation;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.implementation.bytecode.StackManipulation;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.implementation.bytecode.collection.ArrayFactory;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.implementation.bytecode.constant.ClassConstant;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.implementation.bytecode.constant.TextConstant;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.implementation.bytecode.member.FieldAccess;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.implementation.bytecode.member.MethodInvocation;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.jar.asm.MethodVisitor;

public abstract class MethodConstant
implements StackManipulation {
    protected final MethodDescription.InDefinedShape methodDescription;

    protected MethodConstant(MethodDescription.InDefinedShape methodDescription) {
        this.methodDescription = methodDescription;
    }

    public static CanCache forMethod(MethodDescription.InDefinedShape methodDescription) {
        if (methodDescription.isTypeInitializer()) {
            return CanCacheIllegal.INSTANCE;
        }
        if (methodDescription.isConstructor()) {
            return new ForConstructor(methodDescription);
        }
        return new ForMethod(methodDescription);
    }

    private static List<StackManipulation> typeConstantsFor(List<TypeDescription> parameterTypes) {
        ArrayList<StackManipulation> typeConstants = new ArrayList<StackManipulation>(parameterTypes.size());
        for (TypeDescription parameterType : parameterTypes) {
            typeConstants.add(ClassConstant.of(parameterType));
        }
        return typeConstants;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
        return new StackManipulation.Compound(this.preparation(), ArrayFactory.forType(TypeDescription.Generic.OfNonGenericType.CLASS).withValues(MethodConstant.typeConstantsFor(this.methodDescription.getParameters().asTypeList().asErasures())), MethodInvocation.invoke(this.accessorMethod())).apply(methodVisitor, implementationContext);
    }

    protected abstract StackManipulation preparation();

    protected abstract MethodDescription accessorMethod();

    public StackManipulation cached() {
        return this.methodDescription.isConstructor() ? new CachedConstructor(this) : new CachedMethod(this);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        MethodConstant methodConstant = (MethodConstant)other;
        return this.methodDescription.equals(methodConstant.methodDescription);
    }

    public int hashCode() {
        return this.methodDescription.hashCode();
    }

    @HashCodeAndEqualsPlugin.Enhance
    protected static class CachedConstructor
    implements StackManipulation {
        private static final TypeDescription CONSTRUCTOR_TYPE = TypeDescription.ForLoadedType.of(Constructor.class);
        private final StackManipulation constructorConstant;

        protected CachedConstructor(StackManipulation constructorConstant) {
            this.constructorConstant = constructorConstant;
        }

        @Override
        public boolean isValid() {
            return this.constructorConstant.isValid();
        }

        @Override
        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            return FieldAccess.forField(implementationContext.cache(this.constructorConstant, CONSTRUCTOR_TYPE)).read().apply(methodVisitor, implementationContext);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            CachedConstructor cachedConstructor = (CachedConstructor)other;
            return this.constructorConstant.equals(cachedConstructor.constructorConstant);
        }

        public int hashCode() {
            return this.constructorConstant.hashCode();
        }
    }

    protected static class CachedMethod
    implements StackManipulation {
        private static final TypeDescription METHOD_TYPE = TypeDescription.ForLoadedType.of(Method.class);
        private final StackManipulation methodConstant;

        protected CachedMethod(StackManipulation methodConstant) {
            this.methodConstant = methodConstant;
        }

        @Override
        public boolean isValid() {
            return this.methodConstant.isValid();
        }

        @Override
        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            return FieldAccess.forField(implementationContext.cache(this.methodConstant, METHOD_TYPE)).read().apply(methodVisitor, implementationContext);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            CachedMethod cachedMethod = (CachedMethod)other;
            return this.methodConstant.equals(cachedMethod.methodConstant);
        }

        public int hashCode() {
            return this.methodConstant.hashCode();
        }
    }

    protected static class ForConstructor
    extends MethodConstant
    implements CanCache {
        protected ForConstructor(MethodDescription.InDefinedShape methodDescription) {
            super(methodDescription);
        }

        @Override
        protected StackManipulation preparation() {
            return ClassConstant.of(this.methodDescription.getDeclaringType());
        }

        @Override
        protected MethodDescription accessorMethod() {
            try {
                return new MethodDescription.ForLoadedMethod(Class.class.getMethod("getDeclaredConstructor", Class[].class));
            }
            catch (NoSuchMethodException exception) {
                throw new IllegalStateException("Cannot locate Class::getDeclaredConstructor", exception);
            }
        }
    }

    protected static class ForMethod
    extends MethodConstant
    implements CanCache {
        protected ForMethod(MethodDescription.InDefinedShape methodDescription) {
            super(methodDescription);
        }

        @Override
        protected StackManipulation preparation() {
            return new StackManipulation.Compound(ClassConstant.of(this.methodDescription.getDeclaringType()), new TextConstant(this.methodDescription.getInternalName()));
        }

        @Override
        protected MethodDescription accessorMethod() {
            try {
                return new MethodDescription.ForLoadedMethod(Class.class.getMethod("getDeclaredMethod", String.class, Class[].class));
            }
            catch (NoSuchMethodException exception) {
                throw new IllegalStateException("Cannot locate Class::getDeclaredMethod", exception);
            }
        }
    }

    public static interface CanCache
    extends StackManipulation {
        public StackManipulation cached();
    }

    protected static enum CanCacheIllegal implements CanCache
    {
        INSTANCE;


        @Override
        public StackManipulation cached() {
            return StackManipulation.Illegal.INSTANCE;
        }

        @Override
        public boolean isValid() {
            return false;
        }

        @Override
        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            return StackManipulation.Illegal.INSTANCE.apply(methodVisitor, implementationContext);
        }
    }
}

