/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.implementation;

import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.build.HashCodeAndEqualsPlugin;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.description.method.MethodDescription;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.description.method.MethodList;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.description.type.TypeDescription;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.dynamic.scaffold.InstrumentedType;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.implementation.Implementation;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.implementation.bytecode.Duplication;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.implementation.bytecode.StackManipulation;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.implementation.bytecode.Throw;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.implementation.bytecode.TypeCreation;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.implementation.bytecode.constant.TextConstant;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.implementation.bytecode.member.MethodInvocation;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.jar.asm.MethodVisitor;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.matcher.ElementMatchers;

@HashCodeAndEqualsPlugin.Enhance
public class ExceptionMethod
implements Implementation,
ByteCodeAppender {
    private final ConstructionDelegate constructionDelegate;

    public ExceptionMethod(ConstructionDelegate constructionDelegate) {
        this.constructionDelegate = constructionDelegate;
    }

    public static Implementation throwing(Class<? extends Throwable> exceptionType) {
        return ExceptionMethod.throwing(TypeDescription.ForLoadedType.of(exceptionType));
    }

    public static Implementation throwing(TypeDescription exceptionType) {
        if (!exceptionType.isAssignableTo(Throwable.class)) {
            throw new IllegalArgumentException(exceptionType + " does not extend throwable");
        }
        return new ExceptionMethod(new ConstructionDelegate.ForDefaultConstructor(exceptionType));
    }

    public static Implementation throwing(Class<? extends Throwable> exceptionType, String message) {
        return ExceptionMethod.throwing(TypeDescription.ForLoadedType.of(exceptionType), message);
    }

    public static Implementation throwing(TypeDescription exceptionType, String message) {
        if (!exceptionType.isAssignableTo(Throwable.class)) {
            throw new IllegalArgumentException(exceptionType + " does not extend throwable");
        }
        return new ExceptionMethod(new ConstructionDelegate.ForStringConstructor(exceptionType, message));
    }

    @Override
    public InstrumentedType prepare(InstrumentedType instrumentedType) {
        return instrumentedType;
    }

    @Override
    public ByteCodeAppender appender(Implementation.Target implementationTarget) {
        return this;
    }

    @Override
    public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
        StackManipulation.Size stackSize = new StackManipulation.Compound(this.constructionDelegate.make(), Throw.INSTANCE).apply(methodVisitor, implementationContext);
        return new ByteCodeAppender.Size(stackSize.getMaximalSize(), instrumentedMethod.getStackSize());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        return this.constructionDelegate.equals(((ExceptionMethod)object).constructionDelegate);
    }

    public int hashCode() {
        return 17 * 31 + this.constructionDelegate.hashCode();
    }

    public static interface ConstructionDelegate {
        public StackManipulation make();

        @HashCodeAndEqualsPlugin.Enhance
        public static class ForStringConstructor
        implements ConstructionDelegate {
            private final TypeDescription exceptionType;
            private final MethodDescription targetConstructor;
            private final String message;

            public ForStringConstructor(TypeDescription exceptionType, String message) {
                this.exceptionType = exceptionType;
                this.targetConstructor = (MethodDescription)((MethodList)exceptionType.getDeclaredMethods().filter(ElementMatchers.isConstructor().and(ElementMatchers.takesArguments(String.class)))).getOnly();
                this.message = message;
            }

            @Override
            public StackManipulation make() {
                return new StackManipulation.Compound(TypeCreation.of(this.exceptionType), Duplication.SINGLE, new TextConstant(this.message), MethodInvocation.invoke(this.targetConstructor));
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                if (!this.exceptionType.equals(((ForStringConstructor)object).exceptionType)) {
                    return false;
                }
                if (!this.targetConstructor.equals(((ForStringConstructor)object).targetConstructor)) {
                    return false;
                }
                return this.message.equals(((ForStringConstructor)object).message);
            }

            public int hashCode() {
                return ((17 * 31 + this.exceptionType.hashCode()) * 31 + this.targetConstructor.hashCode()) * 31 + this.message.hashCode();
            }
        }

        @HashCodeAndEqualsPlugin.Enhance
        public static class ForDefaultConstructor
        implements ConstructionDelegate {
            private final TypeDescription exceptionType;
            private final MethodDescription targetConstructor;

            public ForDefaultConstructor(TypeDescription exceptionType) {
                this.exceptionType = exceptionType;
                this.targetConstructor = (MethodDescription)((MethodList)exceptionType.getDeclaredMethods().filter(ElementMatchers.isConstructor().and(ElementMatchers.takesArguments(0)))).getOnly();
            }

            @Override
            public StackManipulation make() {
                return new StackManipulation.Compound(TypeCreation.of(this.exceptionType), Duplication.SINGLE, MethodInvocation.invoke(this.targetConstructor));
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                if (!this.exceptionType.equals(((ForDefaultConstructor)object).exceptionType)) {
                    return false;
                }
                return this.targetConstructor.equals(((ForDefaultConstructor)object).targetConstructor);
            }

            public int hashCode() {
                return (17 * 31 + this.exceptionType.hashCode()) * 31 + this.targetConstructor.hashCode();
            }
        }
    }
}

