/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.description;

import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.description.modifier.EnumerationState;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.description.modifier.FieldManifestation;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.description.modifier.FieldPersistence;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.description.modifier.MethodManifestation;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.description.modifier.MethodStrictness;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.description.modifier.Ownership;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.description.modifier.ParameterManifestation;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.description.modifier.ProvisioningState;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.description.modifier.SynchronizationState;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.description.modifier.SyntheticState;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.description.modifier.TypeManifestation;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.description.modifier.Visibility;

public interface ModifierReviewable {
    public static final int EMPTY_MASK = 0;

    public int getModifiers();

    public boolean isFinal();

    public boolean isSynthetic();

    public SyntheticState getSyntheticState();

    public static abstract class AbstractBase
    implements ForTypeDefinition,
    ForFieldDescription,
    ForMethodDescription,
    ForParameterDescription {
        @Override
        public boolean isAbstract() {
            return this.matchesMask(1024);
        }

        @Override
        public boolean isFinal() {
            return this.matchesMask(16);
        }

        @Override
        public boolean isStatic() {
            return this.matchesMask(8);
        }

        @Override
        public boolean isPublic() {
            return this.matchesMask(1);
        }

        @Override
        public boolean isProtected() {
            return this.matchesMask(4);
        }

        @Override
        public boolean isPackagePrivate() {
            return !this.isPublic() && !this.isProtected() && !this.isPrivate();
        }

        @Override
        public boolean isPrivate() {
            return this.matchesMask(2);
        }

        @Override
        public boolean isNative() {
            return this.matchesMask(256);
        }

        @Override
        public boolean isSynchronized() {
            return this.matchesMask(32);
        }

        @Override
        public boolean isStrict() {
            return this.matchesMask(2048);
        }

        @Override
        public boolean isMandated() {
            return this.matchesMask(32768);
        }

        @Override
        public boolean isSynthetic() {
            return this.matchesMask(4096);
        }

        @Override
        public boolean isBridge() {
            return this.matchesMask(64);
        }

        @Override
        public boolean isDeprecated() {
            return this.matchesMask(131072);
        }

        @Override
        public boolean isAnnotation() {
            return this.matchesMask(8192);
        }

        @Override
        public boolean isEnum() {
            return this.matchesMask(16384);
        }

        @Override
        public boolean isInterface() {
            return this.matchesMask(512);
        }

        @Override
        public boolean isTransient() {
            return this.matchesMask(128);
        }

        @Override
        public boolean isVolatile() {
            return this.matchesMask(64);
        }

        @Override
        public boolean isVarArgs() {
            return this.matchesMask(128);
        }

        @Override
        public SyntheticState getSyntheticState() {
            return this.isSynthetic() ? SyntheticState.SYNTHETIC : SyntheticState.PLAIN;
        }

        @Override
        public Visibility getVisibility() {
            int modifiers = this.getModifiers();
            switch (modifiers & 7) {
                case 1: {
                    return Visibility.PUBLIC;
                }
                case 4: {
                    return Visibility.PROTECTED;
                }
                case 0: {
                    return Visibility.PACKAGE_PRIVATE;
                }
                case 2: {
                    return Visibility.PRIVATE;
                }
            }
            throw new IllegalStateException("Unexpected modifiers: " + modifiers);
        }

        @Override
        public Ownership getOwnership() {
            return this.isStatic() ? Ownership.STATIC : Ownership.MEMBER;
        }

        @Override
        public EnumerationState getEnumerationState() {
            return this.isEnum() ? EnumerationState.ENUMERATION : EnumerationState.PLAIN;
        }

        @Override
        public TypeManifestation getTypeManifestation() {
            int modifiers = this.getModifiers();
            switch (modifiers & 0x2610) {
                case 16: {
                    return TypeManifestation.FINAL;
                }
                case 1024: {
                    return TypeManifestation.ABSTRACT;
                }
                case 1536: {
                    return TypeManifestation.INTERFACE;
                }
                case 9728: {
                    return TypeManifestation.ANNOTATION;
                }
                case 0: {
                    return TypeManifestation.PLAIN;
                }
            }
            throw new IllegalStateException("Unexpected modifiers: " + modifiers);
        }

        @Override
        public FieldManifestation getFieldManifestation() {
            int modifiers = this.getModifiers();
            switch (modifiers & 0x50) {
                case 16: {
                    return FieldManifestation.FINAL;
                }
                case 64: {
                    return FieldManifestation.VOLATILE;
                }
                case 0: {
                    return FieldManifestation.PLAIN;
                }
            }
            throw new IllegalStateException("Unexpected modifiers: " + modifiers);
        }

        @Override
        public FieldPersistence getFieldPersistence() {
            int modifiers = this.getModifiers();
            switch (modifiers & 0x80) {
                case 128: {
                    return FieldPersistence.TRANSIENT;
                }
                case 0: {
                    return FieldPersistence.PLAIN;
                }
            }
            throw new IllegalStateException("Unexpected modifiers: " + modifiers);
        }

        @Override
        public SynchronizationState getSynchronizationState() {
            return this.isSynchronized() ? SynchronizationState.SYNCHRONIZED : SynchronizationState.PLAIN;
        }

        @Override
        public MethodManifestation getMethodManifestation() {
            int modifiers = this.getModifiers();
            switch (modifiers & 0x550) {
                case 272: {
                    return MethodManifestation.FINAL_NATIVE;
                }
                case 256: {
                    return MethodManifestation.NATIVE;
                }
                case 16: {
                    return MethodManifestation.FINAL;
                }
                case 64: {
                    return MethodManifestation.BRIDGE;
                }
                case 80: {
                    return MethodManifestation.FINAL_BRIDGE;
                }
                case 1024: {
                    return MethodManifestation.ABSTRACT;
                }
                case 0: {
                    return MethodManifestation.PLAIN;
                }
            }
            throw new IllegalStateException("Unexpected modifiers: " + modifiers);
        }

        @Override
        public MethodStrictness getMethodStrictness() {
            return this.isStrict() ? MethodStrictness.STRICT : MethodStrictness.PLAIN;
        }

        @Override
        public ParameterManifestation getParameterManifestation() {
            return this.isFinal() ? ParameterManifestation.FINAL : ParameterManifestation.PLAIN;
        }

        @Override
        public ProvisioningState getProvisioningState() {
            return this.isMandated() ? ProvisioningState.MANDATED : ProvisioningState.PLAIN;
        }

        private boolean matchesMask(int mask) {
            return (this.getModifiers() & mask) == mask;
        }
    }

    public static interface ForParameterDescription
    extends ModifierReviewable {
        public boolean isMandated();

        public ParameterManifestation getParameterManifestation();

        public ProvisioningState getProvisioningState();
    }

    public static interface ForMethodDescription
    extends OfAbstraction {
        public boolean isSynchronized();

        public boolean isVarArgs();

        public boolean isNative();

        public boolean isBridge();

        public boolean isStrict();

        public SynchronizationState getSynchronizationState();

        public MethodStrictness getMethodStrictness();

        public MethodManifestation getMethodManifestation();
    }

    public static interface ForFieldDescription
    extends OfEnumeration {
        public boolean isVolatile();

        public boolean isTransient();

        public FieldManifestation getFieldManifestation();

        public FieldPersistence getFieldPersistence();
    }

    public static interface ForTypeDefinition
    extends OfAbstraction,
    OfEnumeration {
        public boolean isInterface();

        public boolean isAnnotation();

        public TypeManifestation getTypeManifestation();
    }

    public static interface OfEnumeration
    extends OfByteCodeElement {
        public boolean isEnum();

        public EnumerationState getEnumerationState();
    }

    public static interface OfAbstraction
    extends OfByteCodeElement {
        public boolean isAbstract();
    }

    public static interface OfByteCodeElement
    extends ModifierReviewable {
        public boolean isPublic();

        public boolean isProtected();

        public boolean isPackagePrivate();

        public boolean isPrivate();

        public boolean isStatic();

        public boolean isDeprecated();

        public Ownership getOwnership();

        public Visibility getVisibility();
    }
}

