/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.local;

import org.apache.beam.runners.local.StructuralKey;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class StructuralKeyTest {
    @Test
    public void getKeyEqualToOldKey() {
        Assert.assertThat((Object)((Integer)StructuralKey.of((Object)1234, (Coder)VarIntCoder.of()).getKey()), (Matcher)Matchers.equalTo((Object)1234));
        Assert.assertThat((Object)((String)StructuralKey.of((Object)"foobar", (Coder)StringUtf8Coder.of()).getKey()), (Matcher)Matchers.equalTo((Object)"foobar"));
        Assert.assertArrayEquals((byte[])((byte[])StructuralKey.of((Object)new byte[]{2, 9, -22}, (Coder)ByteArrayCoder.of()).getKey()), (byte[])new byte[]{2, 9, -22});
    }

    @Test
    public void getKeyNotSameInstance() {
        byte[] original = new byte[]{1, 4, 9, 127, -22};
        StructuralKey key = StructuralKey.of((Object)original, (Coder)ByteArrayCoder.of());
        Assert.assertThat((Object)((byte[])key.getKey()), (Matcher)Matchers.not((Matcher)Matchers.theInstance((Object)original)));
    }

    @Test
    public void emptyKeysNotEqual() {
        StructuralKey empty = StructuralKey.empty();
        Assert.assertThat((Object)empty, (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)StructuralKey.empty())));
        Assert.assertThat((Object)empty, (Matcher)Matchers.equalTo((Object)empty));
    }

    @Test
    public void objectEqualsTrueKeyEquals() {
        StructuralKey original = StructuralKey.of((Object)1234, (Coder)VarIntCoder.of());
        Assert.assertThat((Object)StructuralKey.of((Object)1234, (Coder)VarIntCoder.of()), (Matcher)Matchers.equalTo((Object)original));
    }

    @Test
    public void objectsNotEqualEncodingsEqualEquals() {
        byte[] original = new byte[]{1, 4, 9, 127, -22};
        StructuralKey key = StructuralKey.of((Object)original, (Coder)ByteArrayCoder.of());
        StructuralKey otherKey = StructuralKey.of((Object)new byte[]{1, 4, 9, 127, -22}, (Coder)ByteArrayCoder.of());
        Assert.assertThat((Object)key, (Matcher)Matchers.equalTo((Object)otherKey));
    }

    @Test
    public void notEqualEncodingsEqual() {
        byte[] original = new byte[]{1, 4, 9, 127, -22};
        StructuralKey key = StructuralKey.of((Object)original, (Coder)ByteArrayCoder.of());
        StructuralKey otherKey = StructuralKey.of((Object)new byte[]{9, -128, 22}, (Coder)ByteArrayCoder.of());
        Assert.assertThat((Object)key, (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)otherKey)));
    }
}

