/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.fnexecution.environment;

import javax.annotation.concurrent.ThreadSafe;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.fnexecution.control.InstructionRequestHandler;
import org.apache.beam.runners.fnexecution.environment.DockerCommand;
import org.apache.beam.runners.fnexecution.environment.RemoteEnvironment;

@ThreadSafe
class DockerContainerEnvironment
implements RemoteEnvironment {
    private final Object lock = new Object();
    private final DockerCommand docker;
    private final RunnerApi.Environment environment;
    private final String containerId;
    private final InstructionRequestHandler instructionHandler;
    private boolean isClosed = false;

    static DockerContainerEnvironment create(DockerCommand docker, RunnerApi.Environment environment, String containerId, InstructionRequestHandler instructionHandler) {
        return new DockerContainerEnvironment(docker, environment, containerId, instructionHandler);
    }

    private DockerContainerEnvironment(DockerCommand docker, RunnerApi.Environment environment, String containerId, InstructionRequestHandler instructionHandler) {
        this.docker = docker;
        this.environment = environment;
        this.containerId = containerId;
        this.instructionHandler = instructionHandler;
    }

    @Override
    public RunnerApi.Environment getEnvironment() {
        return this.environment;
    }

    @Override
    public InstructionRequestHandler getInstructionRequestHandler() {
        return this.instructionHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isClosed) {
                this.isClosed = true;
                this.instructionHandler.close();
                this.docker.killContainer(this.containerId);
            }
        }
    }
}

