/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.fnexecution.status;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.beam.model.fnexecution.v1.BeamFnApi;
import org.apache.beam.runners.fnexecution.status.WorkerStatusClient;
import org.apache.beam.vendor.grpc.v1p48p1.io.grpc.stub.StreamObserver;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@RunWith(value=JUnit4.class)
public class WorkerStatusClientTest {
    @Mock
    public StreamObserver<BeamFnApi.WorkerStatusRequest> mockObserver;
    private WorkerStatusClient client;

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        this.client = WorkerStatusClient.forRequestObserver((String)"ID", this.mockObserver);
    }

    @Test
    public void testGetWorkerStatusSuccess() throws Exception {
        CompletableFuture workerStatus = this.client.getWorkerStatus(BeamFnApi.WorkerStatusRequest.newBuilder().setId("123").build());
        this.client.getResponseObserver().onNext((Object)BeamFnApi.WorkerStatusResponse.newBuilder().setId("123").setStatusInfo("status").build());
        Assert.assertEquals((Object)"status", (Object)((BeamFnApi.WorkerStatusResponse)workerStatus.get()).getStatusInfo());
    }

    @Test
    public void testGetWorkerStatusError() throws Exception {
        CompletableFuture workerStatus = this.client.getWorkerStatus(BeamFnApi.WorkerStatusRequest.newBuilder().setId("123").build());
        this.client.getResponseObserver().onNext((Object)BeamFnApi.WorkerStatusResponse.newBuilder().setId("123").setError("error").build());
        Assert.assertEquals((Object)"error", (Object)((BeamFnApi.WorkerStatusResponse)workerStatus.get()).getError());
    }

    @Test
    public void testGetWorkerStatusRequestSent() {
        this.client.getWorkerStatus();
        ((StreamObserver)Mockito.verify(this.mockObserver)).onNext((Object)((BeamFnApi.WorkerStatusRequest)ArgumentMatchers.any(BeamFnApi.WorkerStatusRequest.class)));
    }

    @Test
    public void testUnknownRequestIdResponseIgnored() {
        CompletableFuture workerStatus = this.client.getWorkerStatus();
        this.client.getResponseObserver().onNext((Object)BeamFnApi.WorkerStatusResponse.newBuilder().setId("unknown").setStatusInfo("status").build());
        Assert.assertFalse((boolean)workerStatus.isDone());
    }

    @Test
    public void testCloseOutstandingRequest() throws IOException {
        CompletableFuture workerStatus = this.client.getWorkerStatus();
        this.client.close();
        Assert.assertThrows(ExecutionException.class, workerStatus::get);
    }
}

