/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.fnexecution.state;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import org.apache.beam.model.fnexecution.v1.BeamFnApi;
import org.apache.beam.runners.fnexecution.state.GrpcStateService;
import org.apache.beam.runners.fnexecution.state.StateRequestHandler;
import org.apache.beam.sdk.fn.test.TestStreams;
import org.apache.beam.vendor.grpc.v1p48p1.com.google.protobuf.ByteString;
import org.apache.beam.vendor.grpc.v1p48p1.io.grpc.stub.CallStreamObserver;
import org.apache.beam.vendor.grpc.v1p48p1.io.grpc.stub.StreamObserver;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public class GrpcStateServiceTest {
    private static final long TIMEOUT_MS = 30000L;
    private GrpcStateService stateService;
    @Mock
    private StreamObserver<BeamFnApi.StateResponse> responseObserver;
    @Mock
    private StateRequestHandler handler;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.stateService = GrpcStateService.create();
    }

    @Test
    public void testStateRequestsHandledByRegisteredHandlers() throws Exception {
        String bundleInstructionId = "bundle_instruction";
        this.stateService.registerForProcessBundleInstructionId(bundleInstructionId, this.handler);
        StreamObserver requestObserver = this.stateService.state(this.responseObserver);
        BeamFnApi.StateRequest request = BeamFnApi.StateRequest.newBuilder().setInstructionId(bundleInstructionId).build();
        requestObserver.onNext((Object)request);
        ((StateRequestHandler)Mockito.verify((Object)this.handler)).handle(request);
    }

    @Test
    public void testHandlerResponseSentToStateStream() throws Exception {
        ByteString expectedResponseData = ByteString.copyFrom((String)"EXPECTED_RESPONSE_DATA", (Charset)StandardCharsets.UTF_8);
        String bundleInstructionId = "EXPECTED_BUNDLE_INSTRUCTION_ID";
        BeamFnApi.StateResponse.Builder expectedBuilder = BeamFnApi.StateResponse.newBuilder().setGet(BeamFnApi.StateGetResponse.newBuilder().setData(expectedResponseData));
        StateRequestHandler dummyHandler = request -> {
            CompletableFuture<BeamFnApi.StateResponse.Builder> response = new CompletableFuture<BeamFnApi.StateResponse.Builder>();
            response.complete(expectedBuilder);
            return response;
        };
        LinkedBlockingDeque responses = new LinkedBlockingDeque();
        CallStreamObserver recordingResponseObserver = TestStreams.withOnNext(responses::add).build();
        recordingResponseObserver = (StreamObserver)Mockito.spy((Object)recordingResponseObserver);
        this.stateService.registerForProcessBundleInstructionId(bundleInstructionId, dummyHandler);
        StreamObserver requestObserver = this.stateService.state((StreamObserver)recordingResponseObserver);
        BeamFnApi.StateRequest request2 = BeamFnApi.StateRequest.newBuilder().setInstructionId(bundleInstructionId).build();
        requestObserver.onNext((Object)request2);
        BeamFnApi.StateResponse response = (BeamFnApi.StateResponse)responses.poll(30000L, TimeUnit.MILLISECONDS);
        ((StreamObserver)Mockito.verify((Object)recordingResponseObserver, (VerificationMode)Mockito.times((int)1))).onNext((Object)((BeamFnApi.StateResponse)Matchers.any()));
        ((StreamObserver)Mockito.verify((Object)recordingResponseObserver, (VerificationMode)Mockito.never())).onCompleted();
        ((StreamObserver)Mockito.verify((Object)recordingResponseObserver, (VerificationMode)Mockito.never())).onError((Throwable)Matchers.any());
        MatcherAssert.assertThat((Object)response.getGet().getData(), (Matcher)CoreMatchers.equalTo((Object)expectedResponseData));
    }
}

