/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.fnexecution.environment;

import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.construction.Environments;
import org.apache.beam.runners.fnexecution.control.InstructionRequestHandler;
import org.apache.beam.runners.fnexecution.environment.RemoteEnvironment;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class RemoteEnvironmentTest {
    @Test
    public void closeClosesInstructionRequestHandler() throws Exception {
        final InstructionRequestHandler handler = (InstructionRequestHandler)Mockito.mock(InstructionRequestHandler.class);
        RemoteEnvironment env = new RemoteEnvironment(){

            public RunnerApi.Environment getEnvironment() {
                throw new UnsupportedOperationException();
            }

            public InstructionRequestHandler getInstructionRequestHandler() {
                return handler;
            }
        };
        env.close();
        ((InstructionRequestHandler)Mockito.verify((Object)handler)).close();
    }

    @Test
    public void forHandlerClosesHandlerOnClose() throws Exception {
        InstructionRequestHandler handler = (InstructionRequestHandler)Mockito.mock(InstructionRequestHandler.class);
        RemoteEnvironment.forHandler((RunnerApi.Environment)RunnerApi.Environment.getDefaultInstance(), (InstructionRequestHandler)handler).close();
        ((InstructionRequestHandler)Mockito.verify((Object)handler)).close();
    }

    @Test
    public void forHandlerReturnsProvided() {
        InstructionRequestHandler handler = (InstructionRequestHandler)Mockito.mock(InstructionRequestHandler.class);
        RunnerApi.Environment environment = Environments.createDockerEnvironment((String)"my_url");
        RemoteEnvironment remoteEnvironment = RemoteEnvironment.forHandler((RunnerApi.Environment)environment, (InstructionRequestHandler)handler);
        MatcherAssert.assertThat((Object)remoteEnvironment.getEnvironment(), (Matcher)Matchers.theInstance((Object)environment));
        MatcherAssert.assertThat((Object)remoteEnvironment.getInstructionRequestHandler(), (Matcher)Matchers.theInstance((Object)handler));
    }
}

