/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.fnexecution.environment;

import java.io.IOException;
import java.util.Collections;
import org.apache.beam.model.pipeline.v1.Endpoints;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.construction.Environments;
import org.apache.beam.runners.fnexecution.control.InstructionRequestHandler;
import org.apache.beam.runners.fnexecution.environment.ProcessEnvironmentFactory;
import org.apache.beam.runners.fnexecution.environment.ProcessManager;
import org.apache.beam.runners.fnexecution.environment.RemoteEnvironment;
import org.apache.beam.runners.fnexecution.provisioning.StaticGrpcProvisionService;
import org.apache.beam.sdk.fn.IdGenerator;
import org.apache.beam.sdk.fn.IdGenerators;
import org.apache.beam.sdk.fn.server.GrpcFnServer;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.options.RemoteEnvironmentOptions;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@RunWith(value=JUnit4.class)
public class ProcessEnvironmentFactoryTest {
    private static final Endpoints.ApiServiceDescriptor SERVICE_DESCRIPTOR = Endpoints.ApiServiceDescriptor.newBuilder().setUrl("service-url").build();
    private static final String COMMAND = "my-command";
    private static final RunnerApi.Environment ENVIRONMENT = Environments.createProcessEnvironment((String)"", (String)"", (String)"my-command", Collections.emptyMap());
    private static final InspectibleIdGenerator ID_GENERATOR = new InspectibleIdGenerator();
    @Mock
    private ProcessManager processManager;
    @Mock
    private GrpcFnServer<StaticGrpcProvisionService> provisioningServiceServer;
    @Mock
    private InstructionRequestHandler client;
    private ProcessEnvironmentFactory factory;

    @Before
    public void initMocks() throws IOException {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.processManager.startProcess(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), org.mockito.Matchers.anyList(), org.mockito.Matchers.anyMap())).thenReturn((Object)((ProcessManager.RunningProcess)Mockito.mock(ProcessManager.RunningProcess.class)));
        Mockito.when((Object)this.provisioningServiceServer.getApiServiceDescriptor()).thenReturn((Object)SERVICE_DESCRIPTOR);
        this.factory = ProcessEnvironmentFactory.create((ProcessManager)this.processManager, this.provisioningServiceServer, (workerId, timeout) -> this.client, (IdGenerator)ID_GENERATOR, (PipelineOptions)PipelineOptionsFactory.as(RemoteEnvironmentOptions.class));
    }

    @Test
    public void createsCorrectEnvironment() throws Exception {
        RemoteEnvironment handle = this.factory.createEnvironment(ENVIRONMENT, "workerId");
        MatcherAssert.assertThat((Object)handle.getInstructionRequestHandler(), (Matcher)Matchers.is((Object)this.client));
        MatcherAssert.assertThat((Object)handle.getEnvironment(), (Matcher)Matchers.equalTo((Object)ENVIRONMENT));
        ((ProcessManager)Mockito.verify((Object)this.processManager)).startProcess((String)org.mockito.Matchers.eq((Object)"workerId"), ArgumentMatchers.anyString(), org.mockito.Matchers.anyList(), org.mockito.Matchers.anyMap());
    }

    @Test
    public void destroysCorrectContainer() throws Exception {
        RemoteEnvironment handle = this.factory.createEnvironment(ENVIRONMENT, "workerId");
        handle.close();
        ((ProcessManager)Mockito.verify((Object)this.processManager)).stopProcess("workerId");
    }

    @Test
    public void createsMultipleEnvironments() throws Exception {
        RunnerApi.Environment fooEnv = Environments.createProcessEnvironment((String)"", (String)"", (String)"foo", Collections.emptyMap());
        RemoteEnvironment fooHandle = this.factory.createEnvironment(fooEnv, "workerId");
        MatcherAssert.assertThat((Object)fooHandle.getEnvironment(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)fooEnv)));
        RunnerApi.Environment barEnv = Environments.createProcessEnvironment((String)"", (String)"", (String)"bar", Collections.emptyMap());
        RemoteEnvironment barHandle = this.factory.createEnvironment(barEnv, "workerId");
        MatcherAssert.assertThat((Object)barHandle.getEnvironment(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)barEnv)));
    }

    private static class InspectibleIdGenerator
    implements IdGenerator {
        private IdGenerator generator = IdGenerators.incrementingLongs();
        String currentId;

        private InspectibleIdGenerator() {
        }

        public String getId() {
            this.currentId = this.generator.getId();
            return this.currentId;
        }
    }
}

