/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.fnexecution.control;

import org.apache.beam.model.fnexecution.v1.BeamFnApi;
import org.apache.beam.runners.fnexecution.control.BundleFinalizationHandlers;
import org.apache.beam.runners.fnexecution.control.InstructionRequestHandler;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class BundleFinalizationHandlersTest {
    @Test
    public void testInMemoryFinalizer() {
        InstructionRequestHandler mockHandler = (InstructionRequestHandler)Mockito.mock(InstructionRequestHandler.class);
        BundleFinalizationHandlers.InMemoryFinalizer finalizer = BundleFinalizationHandlers.inMemoryFinalizer((InstructionRequestHandler)mockHandler);
        finalizer.finalizeAllOutstandingBundles();
        Mockito.verifyZeroInteractions((Object[])new Object[]{mockHandler});
        finalizer.requestsFinalization("A");
        finalizer.requestsFinalization("B");
        Mockito.verifyZeroInteractions((Object[])new Object[]{mockHandler});
        finalizer.finalizeAllOutstandingBundles();
        ((InstructionRequestHandler)Mockito.verify((Object)mockHandler)).handle(BundleFinalizationHandlersTest.requestFor("A"));
        ((InstructionRequestHandler)Mockito.verify((Object)mockHandler)).handle(BundleFinalizationHandlersTest.requestFor("B"));
    }

    private static BeamFnApi.InstructionRequest requestFor(String bundleId) {
        return BeamFnApi.InstructionRequest.newBuilder().setFinalizeBundle(BeamFnApi.FinalizeBundleRequest.newBuilder().setInstructionId(bundleId).build()).build();
    }
}

