/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.fnexecution.provisioning;

import com.google.protobuf.ListValue;
import com.google.protobuf.NullValue;
import com.google.protobuf.Struct;
import com.google.protobuf.Value;
import io.grpc.Channel;
import io.grpc.inprocess.InProcessChannelBuilder;
import org.apache.beam.model.fnexecution.v1.ProvisionApi;
import org.apache.beam.model.fnexecution.v1.ProvisionServiceGrpc;
import org.apache.beam.runners.fnexecution.FnService;
import org.apache.beam.runners.fnexecution.GrpcFnServer;
import org.apache.beam.runners.fnexecution.InProcessServerFactory;
import org.apache.beam.runners.fnexecution.ServerFactory;
import org.apache.beam.runners.fnexecution.provisioning.StaticGrpcProvisionService;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class StaticGrpcProvisionServiceTest {
    @Test
    public void returnsProvisionInfo() throws Exception {
        Struct options = Struct.newBuilder().putFields("foo", Value.newBuilder().setBoolValue(true).build()).putFields("bar", Value.newBuilder().setNumberValue(2.5).build()).putFields("baz", Value.newBuilder().setListValue(ListValue.newBuilder().addValues(Value.newBuilder().setStructValue(Struct.newBuilder().putFields("spam", Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build()))).build()).build()).build();
        ProvisionApi.Resources resourceLimits = ProvisionApi.Resources.newBuilder().setCpu(ProvisionApi.Resources.Cpu.newBuilder().setShares(0.75f).buildPartial()).setMemory(ProvisionApi.Resources.Memory.newBuilder().setSize(0x80000000L).build()).setSemiPersistentDisk(ProvisionApi.Resources.Disk.newBuilder().setSize(0x10000000000L).build()).build();
        ProvisionApi.ProvisionInfo info = ProvisionApi.ProvisionInfo.newBuilder().setJobId("id").setJobName("name").setWorkerId("worker").setPipelineOptions(options).setResourceLimits(resourceLimits).build();
        GrpcFnServer server = GrpcFnServer.allocatePortAndCreateFor((FnService)StaticGrpcProvisionService.create((ProvisionApi.ProvisionInfo)info), (ServerFactory)InProcessServerFactory.create());
        ProvisionServiceGrpc.ProvisionServiceBlockingStub stub = ProvisionServiceGrpc.newBlockingStub((Channel)InProcessChannelBuilder.forName((String)server.getApiServiceDescriptor().getUrl()).build());
        ProvisionApi.GetProvisionInfoResponse provisionResponse = stub.getProvisionInfo(ProvisionApi.GetProvisionInfoRequest.getDefaultInstance());
        Assert.assertThat((Object)provisionResponse.getInfo(), (Matcher)Matchers.equalTo((Object)info));
    }
}

