/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.fnexecution.graph;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.construction.CoderTranslation;
import org.apache.beam.runners.core.construction.RehydratedComponents;
import org.apache.beam.runners.fnexecution.graph.LengthPrefixUnknownCoders;
import org.apache.beam.runners.java.fn.execution.repackaged.com.google.common.collect.ImmutableList;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.LengthPrefixCoder;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.util.WindowedValue;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class LengthPrefixUnknownCodersTest {
    @Parameterized.Parameter
    public Coder<?> original;
    @Parameterized.Parameter(value=1)
    public Coder<?> expected;
    @Parameterized.Parameter(value=2)
    public boolean replaceWithByteArray;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return ImmutableList.of((Object)new Object[]{WindowedValue.getFullCoder((Coder)KvCoder.of((Coder)UnknownCoder.INSTANCE, (Coder)UnknownCoder.INSTANCE), (Coder)GlobalWindow.Coder.INSTANCE), WindowedValue.getFullCoder((Coder)KvCoder.of((Coder)LengthPrefixCoder.of((Coder)UnknownCoder.INSTANCE), (Coder)LengthPrefixCoder.of((Coder)UnknownCoder.INSTANCE)), (Coder)GlobalWindow.Coder.INSTANCE), false}, (Object)new Object[]{WindowedValue.getFullCoder((Coder)KvCoder.of((Coder)UnknownCoder.INSTANCE, (Coder)LengthPrefixCoder.of((Coder)UnknownCoder.INSTANCE)), (Coder)GlobalWindow.Coder.INSTANCE), WindowedValue.getFullCoder((Coder)KvCoder.of((Coder)LengthPrefixCoder.of((Coder)UnknownCoder.INSTANCE), (Coder)LengthPrefixCoder.of((Coder)UnknownCoder.INSTANCE)), (Coder)GlobalWindow.Coder.INSTANCE), false}, (Object)new Object[]{WindowedValue.getFullCoder((Coder)KvCoder.of((Coder)LengthPrefixCoder.of((Coder)UnknownCoder.INSTANCE), (Coder)UnknownCoder.INSTANCE), (Coder)GlobalWindow.Coder.INSTANCE), WindowedValue.getFullCoder((Coder)KvCoder.of((Coder)LengthPrefixCoder.of((Coder)ByteArrayCoder.of()), (Coder)LengthPrefixCoder.of((Coder)ByteArrayCoder.of())), (Coder)GlobalWindow.Coder.INSTANCE), true}, (Object)new Object[]{LengthPrefixCoder.of((Coder)UnknownCoder.INSTANCE), LengthPrefixCoder.of((Coder)UnknownCoder.INSTANCE), false}, (Object)new Object[]{LengthPrefixCoder.of((Coder)UnknownCoder.INSTANCE), LengthPrefixCoder.of((Coder)ByteArrayCoder.of()), true});
    }

    @Test
    public void test() throws IOException {
        RunnerApi.MessageWithComponents originalCoderProto = CoderTranslation.toProto(this.original);
        RunnerApi.Components.Builder builder = originalCoderProto.getComponents().toBuilder();
        String coderId = LengthPrefixUnknownCoders.generateUniqueId((String)"rootTestId", originalCoderProto.getComponents().getCodersMap().keySet());
        builder.putCoders(coderId, originalCoderProto.getCoder());
        RunnerApi.MessageWithComponents updatedCoderProto = LengthPrefixUnknownCoders.forCoder((String)coderId, (RunnerApi.Components)builder.build(), (boolean)this.replaceWithByteArray);
        Assert.assertEquals(this.expected, (Object)CoderTranslation.fromProto((RunnerApi.Coder)updatedCoderProto.getCoder(), (RehydratedComponents)RehydratedComponents.forComponents((RunnerApi.Components)updatedCoderProto.getComponents())));
    }

    private static class UnknownCoder
    extends CustomCoder<String> {
        private static final Coder<?> INSTANCE = new UnknownCoder();

        private UnknownCoder() {
        }

        public void encode(String value, OutputStream outStream) throws CoderException, IOException {
        }

        public String decode(InputStream inStream) throws CoderException, IOException {
            return "";
        }

        public int hashCode() {
            return 1278890232;
        }

        public boolean equals(Object obj) {
            return obj instanceof UnknownCoder;
        }
    }
}

